/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.condition;

import edu.berkeley.guir.lib.util.condition.AbsoluteDateCondition;
import edu.berkeley.guir.lib.util.condition.BooleanCondition;
import edu.berkeley.guir.lib.util.condition.Condition;
import edu.berkeley.guir.lib.util.condition.ConditionConstructor;
import edu.berkeley.guir.lib.util.condition.ConditionConstructorMulti;
import edu.berkeley.guir.lib.util.condition.MultiCondition;
import edu.berkeley.guir.lib.util.condition.SetCondition;
import java.util.Iterator;

public class AndCondition
extends MultiCondition {
    public static final ConditionConstructor CONSTRUCTOR = new SelfConstructor();

    public AndCondition() {
    }

    public AndCondition(Condition condAA) {
        super(condAA);
    }

    public AndCondition(Condition condAA, Condition condBB) {
        super(condAA, condBB);
    }

    public AndCondition(Condition condAA, Condition condBB, Condition condCC) {
        super(condAA, condBB, condCC);
    }

    public String getConditionType() {
        return CONSTRUCTOR.getType();
    }

    protected boolean isValidRelation(int newRelation) {
        return true;
    }

    public void setRelationValue(String str) {
        throw new IllegalArgumentException();
    }

    public String getRelationValue() {
        throw new IllegalArgumentException();
    }

    public boolean evaluate(String strVal) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Condition cond = (Condition)it.next();
            try {
                if (cond.evaluate(strVal)) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean evaluate(String strValAA, String strValBB) {
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Condition cond = (Condition)it.next();
            try {
                if (cond.evaluate(strValAA, strValBB)) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public static Condition getTestInstanceAAA() {
        AndCondition condAnd = new AndCondition();
        condAnd.add(AbsoluteDateCondition.getTestInstanceAAA());
        condAnd.add(BooleanCondition.getTestInstanceAAA());
        condAnd.add(SetCondition.getTestInstanceAAA());
        return condAnd;
    }

    private static void runTestAAA() {
        System.out.println(AndCondition.getTestInstanceAAA());
    }

    private static void runTestBBB() {
        System.out.println(AndCondition.getTestInstanceAAA().evaluate("a"));
    }

    private static void runTestCCC() throws Exception {
        Condition cond = AndCondition.getTestInstanceAAA();
        cond.setName("MyName");
        String str = cond.toString();
        System.out.println(str);
        System.out.println(cond.getClass());
        System.out.println("------------");
        cond = Condition.parse(str);
        str = cond.toString();
        System.out.println(str);
        System.out.println(cond.getClass());
        System.out.println(cond.getName());
    }

    public static void main(String[] argv) throws Exception {
        AndCondition.runTestCCC();
    }

    static class SelfConstructor
    extends ConditionConstructorMulti {
        SelfConstructor() {
        }

        public Condition createInstance() {
            return new AndCondition();
        }

        public String getType() {
            return "And";
        }

        public boolean isMulti() {
            return true;
        }
    }
}

