/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util.condition;

import edu.berkeley.guir.lib.util.condition.Condition;
import edu.berkeley.guir.lib.util.condition.ConditionConstructor;
import edu.berkeley.guir.lib.util.condition.ConditionConstructorSingle;
import java.text.DateFormat;
import java.util.Date;

public class AbsoluteDateCondition
extends Condition {
    public static final ConditionConstructor CONSTRUCTOR = new SelfConstructor();
    Date relationVal;
    DateFormat df = Condition.getDateFormat();

    public AbsoluteDateCondition() {
    }

    public AbsoluteDateCondition(int newRelation, Date newVal) {
        this.setRelation(newRelation);
        this.setRelationValue(newVal);
    }

    public AbsoluteDateCondition(int newRelation, Date newVal, DateFormat format) {
        this.df = format;
        this.setRelation(newRelation);
        this.setRelationValue(newVal);
    }

    public AbsoluteDateCondition(int newRelation, String newVal) {
        this.setRelation(newRelation);
        this.setRelationValue(newVal);
    }

    public AbsoluteDateCondition(int newRelation, String newVal, DateFormat format) {
        this.df = format;
        this.setRelation(newRelation);
        this.setRelationValue(newVal);
    }

    public String getConditionType() {
        return CONSTRUCTOR.getType();
    }

    protected boolean isValidRelation(int newRelation) {
        switch (newRelation) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 5: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    public void setRelationValue(Date newVal) {
        this.relationVal = newVal;
    }

    public void setRelationValue(String str) {
        try {
            this.relationVal = this.df.parse(str);
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public String getRelationValue() {
        return this.df.format(this.relationVal);
    }

    public boolean evaluate(String strVal) {
        return this.evaluate(strVal, this.df);
    }

    public boolean evaluate(String strValAA, String strValBB) {
        return this.evaluate(strValAA, strValBB, this.df);
    }

    public boolean evaluate(String strVal, DateFormat df) {
        try {
            return this.evaluate(df.parse(strVal));
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public boolean evaluate(String strValAA, String strValBB, DateFormat df) {
        try {
            return this.evaluate(df.parse(strValAA), df.parse(strValBB));
        }
        catch (Exception e) {
            IllegalArgumentException ex = new IllegalArgumentException();
            ex.initCause(e);
            throw ex;
        }
    }

    public boolean evaluate(Date d) {
        if (this.relationVal == null) {
            this.relationVal = new Date();
        }
        return this.evaluate(d, this.relationVal);
    }

    public boolean evaluate(Date dAA, Date dBB) {
        switch (this.relation) {
            case 0: {
                return dAA.compareTo(dBB) == 0;
            }
            case 1: {
                return dAA.compareTo(dBB) != 0;
            }
            case 2: {
                return dAA.compareTo(dBB) < 0;
            }
            case 3: {
                return dAA.compareTo(dBB) <= 0;
            }
            case 4: {
                return dAA.compareTo(dBB) > 0;
            }
            case 5: {
                return dAA.compareTo(dBB) >= 0;
            }
        }
        throw new IllegalArgumentException();
    }

    public static AbsoluteDateCondition getTestInstanceAAA() {
        return new AbsoluteDateCondition(0, "2003.May.07 10:10:30 PDT");
    }

    public static AbsoluteDateCondition getTestInstanceBBB() {
        return new AbsoluteDateCondition(1, "2003.May.07 10:10:30 PDT");
    }

    public static AbsoluteDateCondition getTestInstanceCCC() {
        return new AbsoluteDateCondition(2, "2003.May.07 10:10:30 PDT");
    }

    public static AbsoluteDateCondition getTestInstanceDDD() {
        return new AbsoluteDateCondition(3, "2003.May.07 10:10:30 PDT");
    }

    public static AbsoluteDateCondition getTestInstanceEEE() {
        return new AbsoluteDateCondition(4, "2003.May.07 10:10:30 PDT");
    }

    public static AbsoluteDateCondition getTestInstanceFFF() {
        return new AbsoluteDateCondition(5, "2003.May.07 10:10:30 PDT");
    }

    private static void runTestAAA() {
        System.out.println(AbsoluteDateCondition.getTestInstanceAAA());
        System.out.println(AbsoluteDateCondition.getTestInstanceBBB());
        System.out.println(AbsoluteDateCondition.getTestInstanceCCC());
        System.out.println(AbsoluteDateCondition.getTestInstanceDDD());
        System.out.println(AbsoluteDateCondition.getTestInstanceEEE());
        System.out.println(AbsoluteDateCondition.getTestInstanceFFF());
    }

    private static void runTestBBB() {
        System.out.println(AbsoluteDateCondition.getTestInstanceAAA().evaluate(new Date()));
        System.out.println(AbsoluteDateCondition.getTestInstanceBBB().evaluate(new Date()));
        System.out.println(AbsoluteDateCondition.getTestInstanceCCC().evaluate(new Date()));
        System.out.println(AbsoluteDateCondition.getTestInstanceDDD().evaluate(new Date()));
        System.out.println(AbsoluteDateCondition.getTestInstanceEEE().evaluate(new Date()));
        System.out.println(AbsoluteDateCondition.getTestInstanceFFF().evaluate(new Date()));
    }

    public static void main(String[] argv) {
        AbsoluteDateCondition.runTestAAA();
        AbsoluteDateCondition.runTestBBB();
    }

    static class SelfConstructor
    extends ConditionConstructorSingle {
        SelfConstructor() {
        }

        public Condition createInstance() {
            return new AbsoluteDateCondition();
        }

        public String getType() {
            return "AbsDate";
        }
    }
}

