/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util;

public class Timer {
    private long lStartTime = -1L;
    private long lStopTime = -1L;
    private long lElapsedTime = 0L;
    private boolean flagRunning = false;

    public long getElapsedTime() {
        if (this.flagRunning) {
            return System.currentTimeMillis() - this.lStartTime;
        }
        return this.lElapsedTime;
    }

    public long getStartTime() {
        return this.lStartTime;
    }

    public long getStopTime() {
        return this.lStopTime;
    }

    public boolean isRunning() {
        return this.flagRunning;
    }

    public void start() {
        this.lStartTime = System.currentTimeMillis();
        this.flagRunning = true;
    }

    public void stop() {
        if (this.flagRunning) {
            this.lStopTime = System.currentTimeMillis();
            this.lElapsedTime += this.lStopTime - this.lStartTime;
            this.flagRunning = false;
        }
    }

    public void resetTimer() {
        this.lElapsedTime = 0L;
        this.lStartTime = 0L;
        this.lStopTime = 0L;
        this.flagRunning = false;
    }

    public String toString() {
        return "[(Start: " + this.getStartTime() + ")" + " (Stop: " + this.getStopTime() + ")" + " (Elapsed: " + this.getElapsedTime() + ")" + " (Running: " + this.flagRunning + ")]";
    }
}

