/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class TimeLib {
    public static final long MILLIS_MINUTE = 60000L;
    public static final long MILLIS_HOUR = 3600000L;
    public static final long MILLIS_DAY = 86400000L;
    public static final long MILLIS_WEEK = 604800000L;
    public static final long MILLIS_MONTH = 2419200000L;
    public static final long SECONDS_MINUTE = 60L;
    public static final long SECONDS_HOUR = 3600L;
    public static final long SECONDS_DAY = 86400L;
    public static final long SECONDS_WEEK = 604800L;
    public static final long SECONDS_MONTH = 2419200L;

    private TimeLib() {
    }

    public static boolean isBetween(String strStartTime, String strEndTime) {
        return TimeLib.isBetween(new Date(), strStartTime, strEndTime);
    }

    public static boolean isBetween(Date d, String strStartTime, String strEndTime) {
        GregorianCalendar calendar = new GregorianCalendar();
        int startTimeInMinutes = TimeLib.timeToMinuteOfDay(strStartTime);
        int endTimeInMinutes = TimeLib.timeToMinuteOfDay(strEndTime);
        calendar.setTime(d);
        int hours = calendar.get(11);
        int minutes = calendar.get(12);
        int curTimeInMinutes = 60 * hours + minutes;
        if (startTimeInMinutes > endTimeInMinutes) {
            throw new IllegalArgumentException("start time " + strStartTime + " after end time " + strEndTime);
        }
        return startTimeInMinutes < curTimeInMinutes && curTimeInMinutes < endTimeInMinutes;
    }

    public static int timeToMinuteOfDay(String strTime) {
        int offset = 0;
        String strHours = "";
        int hours = 0;
        String strMinutes = "";
        int minutes = 0;
        if (strTime.equals("12noon") || strTime.equals("12Noon")) {
            return 720;
        }
        if (strTime.equals("12midnight") || strTime.equals("12Midnight")) {
            return 0;
        }
        if (strTime.endsWith("AM")) {
            offset = 0;
        } else if (strTime.endsWith("PM")) {
            offset = 720;
        } else {
            int len = strTime.length();
            if (len == 3) {
                String strFront = strTime.substring(0, 1);
                String strEnd = strTime.substring(1);
                return TimeLib.timeToMinuteOfDay(String.valueOf(strFront) + ":" + strEnd + "AM");
            }
            if (len == 4) {
                String strFront = strTime.substring(0, 2);
                String strEnd = strTime.substring(2);
                return TimeLib.timeToMinuteOfDay(String.valueOf(strFront) + ":" + strEnd + "AM");
            }
            throw new IllegalArgumentException("Can't parse: " + strTime);
        }
        strTime = strTime.substring(0, strTime.length() - 2);
        int indexColon = strTime.indexOf(":");
        if (indexColon > 0) {
            strHours = strTime.substring(0, indexColon);
            strMinutes = strTime.substring(indexColon + 1);
        } else {
            strHours = strTime;
            strMinutes = "0";
        }
        try {
            hours = Integer.parseInt(strHours);
            minutes = Integer.parseInt(strMinutes);
            if (hours < 0 || minutes < 0) {
                throw new IllegalArgumentException("Can't parse: " + strTime);
            }
            if (minutes >= 60) {
                throw new IllegalArgumentException("Too many minutes: " + strTime);
            }
            if (hours == 12) {
                hours = 0;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't parse: " + strTime);
        }
        return offset + 60 * hours + minutes;
    }

    /*
     * WARNING - void declaration
     */
    public static long timespanToMillis(String strTimespan) {
        void var5_6;
        long factor;
        int num;
        int index = strTimespan.indexOf(" ");
        if (index < 0) {
            throw new IllegalArgumentException("No time unit? " + strTimespan);
        }
        String strNum = strTimespan.substring(0, index);
        String strTime = strTimespan.substring(index + 1);
        try {
            num = Integer.parseInt(strNum);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a number or out of range? " + strNum);
        }
        if (strTime.startsWith("month")) {
            factor = 2419200000L;
        } else if (strTime.startsWith("week")) {
            factor = 604800000L;
        } else if (strTime.startsWith("day")) {
            factor = 86400000L;
        } else if (strTime.startsWith("hour")) {
            factor = 3600000L;
        } else if (strTime.startsWith("minute")) {
            factor = 60000L;
        } else if (strTime.startsWith("second")) {
            factor = 1000L;
        } else {
            throw new IllegalArgumentException("Unknown time unit: " + strTimespan);
        }
        return (long)num * var5_6;
    }

    public static String timespanToString(long seconds) {
        String strUnit;
        long val;
        if (seconds % 2419200L == 0L) {
            val = seconds / 2419200L;
            strUnit = "month";
        } else if (seconds % 604800L == 0L) {
            val = seconds / 604800L;
            strUnit = "week";
        } else if (seconds % 86400L == 0L) {
            val = seconds / 86400L;
            strUnit = "day";
        } else if (seconds % 3600L == 0L) {
            val = seconds / 3600L;
            strUnit = "hour";
        } else if (seconds % 60L == 0L) {
            val = seconds / 60L;
            strUnit = "minute";
        } else {
            val = seconds;
            strUnit = "second";
        }
        if (val == 1L) {
            return "1 " + strUnit;
        }
        return String.valueOf(val) + " " + strUnit + "s";
    }

    public static boolean compare(Date d, String strTime) {
        if (strTime.endsWith(" old")) {
            strTime = strTime.substring(0, strTime.length() - 4);
        }
        boolean flagMoreThan = false;
        if (strTime.startsWith("more than ")) {
            flagMoreThan = true;
        } else if (strTime.startsWith("less than ")) {
            flagMoreThan = false;
        } else {
            throw new IllegalArgumentException("must begin with 'more than' or 'less than': " + strTime);
        }
        strTime = strTime.substring(10);
        long deltaTime = TimeLib.timespanToMillis(strTime);
        long baseTime = System.currentTimeMillis() - deltaTime;
        long compareTime = d.getTime();
        if (flagMoreThan) {
            return compareTime <= baseTime;
        }
        return compareTime >= baseTime;
    }

    public static long calculateNextDay() {
        return TimeLib.calculateNextDay(System.currentTimeMillis());
    }

    public static long calculateNextDay(long millis) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(millis);
        ((Calendar)calendar).add(6, 1);
        return calendar.getTimeInMillis();
    }

    public static long calculateNextMidnight() {
        return TimeLib.calculateNextMidnight(System.currentTimeMillis());
    }

    public static long calculateNextMidnight(long millis) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(millis);
        ((Calendar)calendar).add(6, 1);
        calendar.set(10, 0);
        calendar.set(12, 0);
        return calendar.getTimeInMillis();
    }

    public static long calculateNextSundayMidnight() {
        return TimeLib.calculateNextSundayMidnight(System.currentTimeMillis());
    }

    public static long calculateNextSundayMidnight(long millis) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(millis);
        int i = 0;
        while (i < 7) {
            int val = calendar.get(7);
            if (val == 1) break;
            ((Calendar)calendar).add(6, 1);
            ++i;
        }
        calendar.set(10, 0);
        calendar.set(12, 0);
        return calendar.getTimeInMillis();
    }

    public static long calculateNextFirstOfMonthMidnight() {
        return TimeLib.calculateNextFirstOfMonthMidnight(System.currentTimeMillis());
    }

    public static long calculateNextFirstOfMonthMidnight(long millis) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTimeInMillis(millis);
        ((Calendar)calendar).add(2, 1);
        int i = 0;
        while (i < 31) {
            int val = calendar.get(5);
            if (val <= 1) break;
            ((Calendar)calendar).roll(5, false);
            ++i;
        }
        calendar.set(10, 0);
        calendar.set(12, 0);
        return calendar.getTimeInMillis();
    }

    private static void runTestAAA() {
        System.out.println("HOUR 3600000");
        System.out.println("DAY  86400000");
        System.out.println("----------");
        System.out.println(3600000L);
        System.out.println(TimeLib.timespanToMillis("1 hour"));
        System.out.println("----------");
        System.out.println(0x6DDD00L);
        System.out.println(TimeLib.timespanToMillis("2 hours"));
        System.out.println("----------");
        System.out.println(86400000L);
        System.out.println(TimeLib.timespanToMillis("1 day"));
        System.out.println("----------");
        System.out.println(172800000L);
        System.out.println(TimeLib.timespanToMillis("2 days"));
        System.out.println("----------");
        System.out.println(2592000000L);
        System.out.println(TimeLib.timespanToMillis("30 days"));
    }

    private static void testTimeToMinuteOfDay(String str) {
        try {
            System.out.print(String.valueOf(str) + "\t- ");
            System.out.println(TimeLib.timeToMinuteOfDay(str));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void runTestBBB() {
        TimeLib.testTimeToMinuteOfDay("12:00AM");
        TimeLib.testTimeToMinuteOfDay("12:01AM");
        TimeLib.testTimeToMinuteOfDay("12:59AM");
        TimeLib.testTimeToMinuteOfDay("1AM");
        TimeLib.testTimeToMinuteOfDay("1:00AM");
        TimeLib.testTimeToMinuteOfDay("2AM");
        TimeLib.testTimeToMinuteOfDay("2:30AM");
        TimeLib.testTimeToMinuteOfDay("5AM");
        TimeLib.testTimeToMinuteOfDay("9AM");
        TimeLib.testTimeToMinuteOfDay("9:59AM");
        TimeLib.testTimeToMinuteOfDay("10AM");
        TimeLib.testTimeToMinuteOfDay("10:00AM");
        TimeLib.testTimeToMinuteOfDay("11:00AM");
        TimeLib.testTimeToMinuteOfDay("11:59AM");
        TimeLib.testTimeToMinuteOfDay("12PM");
        TimeLib.testTimeToMinuteOfDay("12:00PM");
        TimeLib.testTimeToMinuteOfDay("12:59PM");
        TimeLib.testTimeToMinuteOfDay("1PM");
        TimeLib.testTimeToMinuteOfDay("9PM");
        TimeLib.testTimeToMinuteOfDay("9:59PM");
        TimeLib.testTimeToMinuteOfDay("10PM");
        TimeLib.testTimeToMinuteOfDay("10:00PM");
        TimeLib.testTimeToMinuteOfDay("11:59PM");
        TimeLib.testTimeToMinuteOfDay("12midnight");
        TimeLib.testTimeToMinuteOfDay("12noon");
        TimeLib.testTimeToMinuteOfDay("1400");
        TimeLib.testTimeToMinuteOfDay("0500");
    }

    private static void runTestCCC() {
        System.out.println(TimeLib.isBetween("5AM", "9PM"));
        System.out.println(TimeLib.isBetween("8PM", "9PM"));
        System.out.println(TimeLib.isBetween("9PM", "10PM"));
        System.out.println(TimeLib.isBetween("9PM", "10AM"));
    }

    private static void runTestDDD() {
        System.out.println("2419200000");
        System.out.println("604800000");
        System.out.println("86400000");
        System.out.println("3600000");
        System.out.println("60000");
        System.out.println(TimeLib.timespanToString(86400L));
        System.out.println(TimeLib.timespanToString(86401L));
        System.out.println(TimeLib.timespanToString(3600L));
        System.out.println(TimeLib.timespanToString(7200L));
        System.out.println(TimeLib.timespanToString(604800L));
        System.out.println(TimeLib.timespanToString(1209600L));
    }

    private static void runTestEEE() {
        System.out.println(TimeLib.compare(new Date(), "less than 1 hour old"));
        System.out.println(TimeLib.compare(new Date(), "more than 2 hours"));
    }

    private static void runTestFFF() {
        Date dAA = new Date(1072573550593L);
        Date dBB = new Date(1072919150593L);
        System.out.println(dAA);
        System.out.println(dBB);
        System.out.println();
        System.out.println("Next Day");
        System.out.println(new Date(TimeLib.calculateNextDay()));
        System.out.println(new Date(TimeLib.calculateNextDay(dAA.getTime())));
        System.out.println(new Date(TimeLib.calculateNextDay(dBB.getTime())));
        System.out.println();
        System.out.println("Midnight");
        System.out.println(new Date(TimeLib.calculateNextMidnight()));
        System.out.println(new Date(TimeLib.calculateNextMidnight(dAA.getTime())));
        System.out.println(new Date(TimeLib.calculateNextMidnight(dBB.getTime())));
        System.out.println();
        System.out.println("Next Sunday Midnight");
        System.out.println(new Date(TimeLib.calculateNextSundayMidnight()));
        System.out.println(new Date(TimeLib.calculateNextSundayMidnight(dAA.getTime())));
        System.out.println(new Date(TimeLib.calculateNextSundayMidnight(dBB.getTime())));
        System.out.println();
        System.out.println("Next First of Month Midnight");
        System.out.println(new Date(TimeLib.calculateNextFirstOfMonthMidnight()));
        System.out.println(new Date(TimeLib.calculateNextFirstOfMonthMidnight(dAA.getTime())));
        System.out.println(new Date(TimeLib.calculateNextFirstOfMonthMidnight(dBB.getTime())));
    }

    public static void main(String[] argv) {
        TimeLib.runTestBBB();
    }
}

