/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ThreadPool {
    private static final int DEFAULT_NUMTHREADS = 5;
    private static final boolean DEBUG = false;
    int counter = 0;
    List listAvailableThreads = Collections.synchronizedList(new LinkedList());
    List listRunningThreads = Collections.synchronizedList(new LinkedList());
    List listRunnable = Collections.synchronizedList(new LinkedList());
    boolean flagExpandable = false;
    int maxNumThreads = 5;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.util.ThreadPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private static final void println(String str) {
    }

    public ThreadPool() {
        this.createNThreads(this.maxNumThreads);
    }

    public ThreadPool(int newNumThreads) {
        this.maxNumThreads = newNumThreads;
        this.createNThreads(this.maxNumThreads);
    }

    public ThreadPool(int newNumThreads, boolean newExpandable) {
        this.maxNumThreads = newNumThreads;
        this.flagExpandable = newExpandable;
        this.createNThreads(this.maxNumThreads);
    }

    private int getNumActiveThreads() {
        return this.listAvailableThreads.size() + this.listRunningThreads.size();
    }

    private void createNThreads(int val) {
        if (!$assertionsDisabled && val < 0) {
            throw new AssertionError();
        }
        int i = 0;
        while (i < val) {
            this.createNewThread();
            ++i;
        }
    }

    private PoolThread createNewThread() {
        ThreadPool.println("creating new thread...");
        PoolThread t = new PoolThread("ThreadPool-Thread" + this.counter++);
        this.listAvailableThreads.add(t);
        t.start();
        return t;
    }

    private void waitForNextAvailableThread() {
        ThreadPool.println("waiting for next available thread...");
        while (this.listAvailableThreads.isEmpty()) {
            try {
                Thread.yield();
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ThreadPool.println("done waiting for next available thread...");
    }

    private synchronized PoolThread getNextAvailableThread() {
        ThreadPool.println("getting next available thread...");
        if (this.listAvailableThreads.isEmpty()) {
            if (this.flagExpandable) {
                this.createNewThread();
            } else {
                this.waitForNextAvailableThread();
            }
        }
        PoolThread t = (PoolThread)this.listAvailableThreads.remove(0);
        this.listRunningThreads.add(t);
        ThreadPool.println("returning available thread...");
        return t;
    }

    public void run(Runnable job) {
        PoolThread t = this.getNextAvailableThread();
        t.run(job);
    }

    class PoolThread
    extends Thread {
        Runnable job;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.lib.util.ThreadPool$PoolThread");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public PoolThread(String strName) {
            super(strName);
        }

        public synchronized void run(Runnable newJob) {
            ThreadPool.println(String.valueOf(this.getName()) + " starting new job...");
            if (!$assertionsDisabled && newJob == null) {
                throw new AssertionError();
            }
            this.job = newJob;
            this.notify();
        }

        public synchronized void run() {
            while (true) {
                if (this.job == null) {
                    try {
                        ThreadPool.println(String.valueOf(this.getName()) + " now sleeping...");
                        this.wait();
                        ThreadPool.println(String.valueOf(this.getName()) + " awoken...");
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                }
                try {
                    ThreadPool.println(String.valueOf(this.getName()) + " running job " + this.job.toString());
                    this.job.run();
                    ThreadPool.println(String.valueOf(this.getName()) + " job completed...");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.job = null;
                if (ThreadPool.this.getNumActiveThreads() >= ThreadPool.this.maxNumThreads) {
                    ThreadPool.this.listRunningThreads.remove(this);
                    ThreadPool.this.listAvailableThreads.remove(this);
                    ThreadPool.println(String.valueOf(this.getName()) + " going away...");
                    continue;
                }
                ThreadPool.this.listRunningThreads.remove(this);
                ThreadPool.this.listAvailableThreads.add(this);
                ThreadPool.println(String.valueOf(this.getName()) + " enqueued back to pool...");
            }
        }
    }
}

