/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util;

import edu.berkeley.guir.lib.util.ParserLib;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Polygon;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.SwingUtilities;

public final class StringLib {
    private static final String EOLN;
    public static int DEFAULT_FOLD_LENGTH;
    public static String SPACES;
    private static String foldTokens;
    private static int foldLength;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.util.StringLib");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        EOLN = System.getProperty("line.separator");
        DEFAULT_FOLD_LENGTH = 80;
        SPACES = "                                                                                                                                                                                                                                                  ";
        foldTokens = " \n\t\r";
        foldLength = DEFAULT_FOLD_LENGTH;
    }

    public static void setFoldTokens(String tokens) {
        foldTokens = tokens;
    }

    public static void setFoldLength(int val) {
        if (!$assertionsDisabled && val <= 0) {
            throw new AssertionError();
        }
        foldLength = val;
    }

    private StringLib() {
    }

    public static String blank(int len) {
        if (len <= 0) {
            return "";
        }
        return SPACES.substring(SPACES.length() - len);
    }

    public static String toCSV(String[] strtoks) {
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while (i < strtoks.length) {
            if (i > 0) {
                strbuf.append(",");
            }
            if (strtoks[i] != null) {
                if (strtoks[i].indexOf(44) >= 0) {
                    strbuf.append("\"");
                    strbuf.append(strtoks[i]);
                    strbuf.append("\"");
                } else {
                    strbuf.append(strtoks[i]);
                }
            }
            ++i;
        }
        return strbuf.toString();
    }

    public static String toCSV(Iterator it) {
        StringBuffer strbuf = new StringBuffer();
        while (it.hasNext()) {
            String str = (String)it.next();
            if (str == null) continue;
            if (str.indexOf(44) >= 0) {
                strbuf.append("\"");
                strbuf.append(str);
                strbuf.append("\"");
            } else {
                strbuf.append(str);
            }
            if (!it.hasNext()) continue;
            strbuf.append(",");
        }
        return strbuf.toString();
    }

    public static String toCSV(List list) {
        return StringLib.toCSV(list.iterator());
    }

    public static String padAtFront(String str, int len) {
        return String.valueOf(StringLib.blank(len - str.length())) + str;
    }

    public static String padAtEnd(String str, int len) {
        return String.valueOf(str) + StringLib.blank(len - str.length());
    }

    public static int getNumRows(String str) {
        int count = StringLib.countNumOfChar('\n', str);
        if (str.charAt(str.length() - 1) != '\n') {
            ++count;
        }
        return count;
    }

    public static int getNumRows(String str, int numCols) {
        String strTmp = StringLib.fold("", str, numCols);
        return StringLib.getNumRows(strTmp);
    }

    public static int getMaxNumCols(String str, String eoln) {
        StringTokenizer strtok = new StringTokenizer(str, eoln);
        int maxlen = 0;
        while (strtok.hasMoreTokens()) {
            String strTmp = strtok.nextToken();
            if (strTmp.length() <= maxlen) continue;
            maxlen = strTmp.length();
        }
        return maxlen;
    }

    public static int getMaxNumCols(String str, String eoln, int numCols) {
        String strTmp = StringLib.fold("", str, eoln, numCols);
        return StringLib.getMaxNumCols(strTmp, eoln);
    }

    public static int getMaxNumCols(String str) {
        return StringLib.getMaxNumCols(str, EOLN);
    }

    public static int getMaxNumCols(String str, int numCols) {
        return StringLib.getMaxNumCols(str, EOLN, numCols);
    }

    public static String fold(Object obj1, Object obj2) {
        return StringLib.fold(obj1.toString(), obj2.toString());
    }

    public static String fold(String strText, int numCols) {
        return StringLib.fold("", strText, EOLN, numCols);
    }

    public static String fold(String strPrefix, String strText, int numCols) {
        return StringLib.fold(strPrefix, strText, EOLN, numCols);
    }

    public static String fold(String strPrefix, String strText) {
        return StringLib.fold(strPrefix, strText, EOLN, foldLength);
    }

    public static String fold(String strPrefix, String strText, String eoln, int numCols) {
        StringBuffer strbuf = new StringBuffer();
        int currentLen = strPrefix.length();
        String spaces = StringLib.blank(strPrefix.length());
        boolean flagStart = true;
        strbuf.append(strPrefix);
        StringTokenizer strtok = new StringTokenizer(strText, foldTokens, true);
        while (strtok.hasMoreTokens()) {
            String strAppend = strtok.nextToken();
            int appendLen = strAppend.length();
            if (!flagStart && currentLen + appendLen > numCols || strAppend.endsWith("\r") || strAppend.endsWith("\n")) {
                strbuf.append(String.valueOf(eoln) + spaces + strAppend.trim());
                currentLen = spaces.length() + appendLen;
                flagStart = true;
                continue;
            }
            strbuf.append(strAppend);
            currentLen += appendLen;
            flagStart = false;
        }
        return strbuf.toString();
    }

    public static final String alignRight(String str, char ch) {
        return StringLib.alignRight(ParserLib.parseAsMap(str, ch), "" + ch, "");
    }

    public static final String alignLeft(String str, char ch) {
        return StringLib.alignLeft(ParserLib.parseAsMap(str, ch), "" + ch, "");
    }

    public static final String alignLeft(Map map) {
        return StringLib.alignLeft(map, ":", "");
    }

    public static final String alignLeft(Map map, String pre, String post) {
        return StringLib.align(map, new LinkedList(map.keySet()), pre, post, 1);
    }

    public static String alignLeft(Map map, List listKeys, String pre, String post) {
        return StringLib.align(map, listKeys, pre, post, 1);
    }

    public static String alignRight(Map map) {
        return StringLib.alignRight(map, "=", "");
    }

    public static String alignRight(Map map, String pre, String post) {
        return StringLib.align(map, new LinkedList(map.keySet()), pre, post, 0);
    }

    public static String alignRight(Map map, List listKeys, String pre, String post) {
        return StringLib.align(map, listKeys, pre, post, 0);
    }

    private static String align(Map map, List listKeys, String pre, String post, int alignType) {
        Object objVal;
        Object objKey;
        int maxlen = 0;
        int numKeys = 0;
        Iterator<Object> it = listKeys.iterator();
        LinkedHashMap mapCopy = new LinkedHashMap();
        while (it.hasNext()) {
            objKey = it.next();
            objVal = map.get(objKey);
            if (objVal == null) continue;
            mapCopy.put(objKey, objVal);
            maxlen = Math.max(maxlen, objKey.toString().length());
            ++numKeys;
        }
        StringBuffer strbuf = new StringBuffer();
        it = mapCopy.keySet().iterator();
        while (it.hasNext()) {
            --numKeys;
            objKey = it.next();
            objVal = map.get(objKey);
            if (objVal == null) continue;
            int paddingNeeded = maxlen - objKey.toString().length();
            if (alignType == 0) {
                strbuf.append(StringLib.blank(paddingNeeded));
                strbuf.append(objKey);
                strbuf.append(pre);
                strbuf.append(objVal);
                strbuf.append(post);
            } else if (alignType == 1) {
                strbuf.append(objKey);
                strbuf.append(pre);
                strbuf.append(StringLib.blank(paddingNeeded + 1));
                strbuf.append(objVal);
                strbuf.append(post);
            }
            if (numKeys <= 0) continue;
            strbuf.append("\n");
        }
        return strbuf.toString();
    }

    public static boolean containsChars(String str, String strChars) {
        return StringLib.containsChars(str, strChars.toCharArray());
    }

    public static boolean containsChars(String str, char[] chars) {
        int i = 0;
        while (i < str.length()) {
            char compare = str.charAt(i);
            int j = 0;
            while (j < chars.length) {
                if (compare == chars[j]) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public boolean isDecimalNumber(String str) {
        int i = 0;
        while (i < str.length()) {
            if (!Character.isDigit(str.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String interpretString(String str) {
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (ch == '\\') {
                if (str.charAt(i + 1) == 'u') {
                    ch = StringLib.interpretEscapeSequence(str.substring(i, i + 6));
                    i += 5;
                } else {
                    ch = StringLib.interpretEscapeSequence(str.substring(i, i + 2));
                    ++i;
                }
            }
            strbuf.append(ch);
            ++i;
        }
        return strbuf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static char interpretEscapeSequence(String str) {
        if (str.length() < 2 || str.charAt(0) != '\\') return '\u0000';
        switch (str.charAt(1)) {
            case 'b': {
                return '\b';
            }
            case 't': {
                return '\t';
            }
            case 'n': {
                return '\n';
            }
            case 'f': {
                return '\f';
            }
            case 'r': {
                return '\r';
            }
            case '\"': {
                return '\"';
            }
            case '\'': {
                return '\'';
            }
            case '\\': {
                return '\\';
            }
            case 'u': {
                try {
                    String strRest = str.substring(2);
                    int val = Integer.parseInt(strRest, 16);
                    if (val >= 65535) return '\u0000';
                    return (char)val;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return '\u0000';
    }

    public static String reverseInterpretString(String str) {
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            strbuf.append(StringLib.reverseInterpretEscapeSequence(str.charAt(i)));
            ++i;
        }
        return strbuf.toString();
    }

    public static String reverseInterpretEscapeSequence(byte b) {
        return StringLib.reverseInterpretEscapeSequence((char)b);
    }

    public static String reverseInterpretEscapeSequence(char ch) {
        switch (ch) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
        }
        return "" + ch;
    }

    public static int countNumOfChar(char chSearch, String strLine) {
        int iNumOccurrences = 0;
        int iStartIndex = 0;
        iStartIndex = strLine.indexOf(chSearch, 0);
        while (iStartIndex != -1) {
            ++iNumOccurrences;
            iStartIndex = strLine.indexOf(chSearch, iStartIndex + 1);
        }
        return iNumOccurrences;
    }

    public static int countNumOfString(String strSearch, String strLine) {
        int iNumOccurrences = 0;
        int iStartIndex = 0;
        iStartIndex = strLine.indexOf(strSearch, 0);
        while (iStartIndex != -1) {
            ++iNumOccurrences;
            iStartIndex = strLine.indexOf(strSearch, iStartIndex + 1);
        }
        return iNumOccurrences;
    }

    public static int calcLongestStringLen(Collection col, boolean flagNullIsZero) {
        Iterator it = col.iterator();
        int maxLen = 0;
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj == null) {
                if (flagNullIsZero) continue;
                obj = "null";
            }
            maxLen = Math.max(maxLen, obj.toString().length());
        }
        return maxLen;
    }

    public static String generateString(int len) {
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while (i < len) {
            strbuf.append("" + i % 10);
            ++i;
        }
        return strbuf.toString();
    }

    public static String getBarredLine(char ch) {
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while (i < 80) {
            strbuf.append(ch);
            ++i;
        }
        return strbuf.toString();
    }

    public static String getBarredLine(String strText, char ch) {
        StringBuffer strbuf = new StringBuffer();
        int len = 0;
        len = 0;
        while (len < 3) {
            strbuf.append(ch);
            ++len;
        }
        strbuf.append("   ");
        len += 3;
        strbuf.append(strText);
        len += strText.length();
        strbuf.append("   ");
        len += 3;
        while (len < 80) {
            strbuf.append(ch);
            ++len;
        }
        return strbuf.toString();
    }

    public static String spaces(int len) {
        return SPACES.substring(0, len);
    }

    public static String join(String[] strings) {
        return StringLib.join(strings, " ");
    }

    public static String join(Collection strings) {
        return StringLib.join(strings, " ");
    }

    public static String join(String[] strings, String delimiter) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int n = strings.length;
        while (i < n) {
            sb.append(strings[i]);
            if (i < n - 1) {
                sb.append(delimiter);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String join(Collection strings, String delimiter) {
        StringBuffer sb = new StringBuffer();
        Iterator i = strings.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            sb.append(s);
            if (!i.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String removeSubstring(char chFrom, char chTo, String strLine) {
        int iStartIndex = strLine.indexOf(chFrom);
        int iEndIndex = strLine.indexOf(chTo, iStartIndex + 1);
        if (iStartIndex == -1 || iEndIndex == -1) {
            return strLine;
        }
        return String.valueOf(strLine.substring(0, iStartIndex)) + strLine.substring(iEndIndex + 1);
    }

    public static String replaceSubstring(String str, String strSearch, String strReplace) {
        if (strSearch.equals("")) {
            return str;
        }
        int start = 0;
        int end = str.indexOf(strSearch);
        if (end >= 0) {
            int len = strSearch.length();
            StringBuffer strbuf = new StringBuffer(2 * len);
            while (end >= 0) {
                strbuf.append(String.valueOf(str.substring(start, end)) + strReplace);
                start = end + len;
                end = str.indexOf(strSearch, start);
            }
            strbuf.append(str.substring(start));
            return strbuf.toString();
        }
        return str;
    }

    public static String indent(String str, int numSpaces) {
        String strReplace = "\n" + StringLib.blank(numSpaces);
        str = str.replaceAll("\n", strReplace);
        str = String.valueOf(StringLib.blank(numSpaces)) + str;
        if (str.endsWith(strReplace)) {
            str = str.substring(0, str.length() - strReplace.length());
            str = String.valueOf(str) + "\n";
        }
        return str;
    }

    public static byte[] toByteArray(String str) throws IOException {
        ByteArrayOutputStream bostream = new ByteArrayOutputStream();
        OutputStreamWriter wtr = new OutputStreamWriter(bostream);
        wtr.write(str);
        wtr.flush();
        return bostream.toByteArray();
    }

    public static final String toString(Object obj) {
        return obj.toString();
    }

    public static final String toString(MouseEvent evt) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("MouseEvent[");
        switch (evt.getID()) {
            case 500: {
                strbuf.append("MOUSE_CLICKED,  ");
                break;
            }
            case 506: {
                strbuf.append("MOUSE_DRAGGED,  ");
                break;
            }
            case 504: {
                strbuf.append("MOUSE_ENTERED,  ");
                break;
            }
            case 505: {
                strbuf.append("MOUSE_EXITED,   ");
                break;
            }
            case 503: {
                strbuf.append("MOUSE_MOVED,    ");
                break;
            }
            case 501: {
                strbuf.append("MOUSE_PRESSED,  ");
                break;
            }
            case 502: {
                strbuf.append("MOUSE_RELEASED, ");
            }
        }
        if (SwingUtilities.isLeftMouseButton(evt)) {
            strbuf.append("L");
        } else {
            strbuf.append(" ");
        }
        if (SwingUtilities.isMiddleMouseButton(evt)) {
            strbuf.append("M");
        } else {
            strbuf.append(" ");
        }
        if (SwingUtilities.isRightMouseButton(evt)) {
            strbuf.append("R ");
        } else {
            strbuf.append("  ");
        }
        strbuf.append("(" + evt.getX() + "," + evt.getY() + ")");
        strbuf.append(" on " + ((Component)evt.getSource()).getName());
        strbuf.append("]");
        return strbuf.toString();
    }

    public static final String toString(Iterator it) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        while (it.hasNext()) {
            strbuf.append(it.next() + ", ");
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static final String toString(Enumeration en) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        while (en.hasMoreElements()) {
            strbuf.append(en.nextElement() + ", ");
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static final String toString(Object[] array) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        int i = 0;
        while (i < array.length) {
            if (array[i] != null) {
                strbuf.append(String.valueOf(array[i].toString()) + ", ");
            } else {
                strbuf.append("null, ");
            }
            ++i;
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static final String toString(boolean[] array) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        int i = 0;
        while (i < array.length) {
            if (array[i]) {
                strbuf.append("T");
            } else {
                strbuf.append("F");
            }
            ++i;
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static final String toString(char[] array) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        int i = 0;
        while (i < array.length) {
            strbuf.append(array[i]);
            ++i;
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static final String toString(byte[] array) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        int i = 0;
        while (i < array.length) {
            strbuf.append(String.valueOf(array[i]) + ", ");
            ++i;
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static final String toString(short[] array) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        int i = 0;
        while (i < array.length) {
            strbuf.append(String.valueOf(array[i]) + ", ");
            ++i;
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static final String toString(int[] array) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        int i = 0;
        while (i < array.length) {
            strbuf.append(String.valueOf(array[i]) + ", ");
            ++i;
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static final String toString(long[] array) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        int i = 0;
        while (i < array.length) {
            strbuf.append(String.valueOf(array[i]) + ", ");
            ++i;
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static final String toString(float[] array) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        int i = 0;
        while (i < array.length) {
            strbuf.append(String.valueOf(array[i]) + ", ");
            ++i;
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static final String toString(double[] array) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        int i = 0;
        while (i < array.length) {
            strbuf.append(String.valueOf(array[i]) + ", ");
            ++i;
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static final String toString(Rectangle2D rect) {
        if (rect == null) {
            return "null";
        }
        double x1 = rect.getX();
        double y1 = rect.getY();
        double w = rect.getWidth();
        double h = rect.getHeight();
        double x2 = x1 + w;
        double y2 = y1 + h;
        return "[x1=" + x1 + " y1=" + y1 + " x2=" + x2 + " y2=" + y2 + " w=" + w + " h=" + h + "]";
    }

    public static final String toString(Line2D line) {
        if (line == null) {
            return "null";
        }
        double x1 = line.getX1();
        double y1 = line.getY1();
        double x2 = line.getX2();
        double y2 = line.getY2();
        return "Line2D(" + x1 + ", " + y1 + ")-(" + x2 + ", " + y2 + ")";
    }

    public static final String toString(Polygon poly) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        int i = 0;
        while (i < poly.npoints) {
            strbuf.append("(" + poly.xpoints[i] + "," + poly.ypoints[i] + ")");
            ++i;
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static final String toString(Ellipse2D ellipse) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(String.valueOf(ellipse.toString()) + " " + ellipse.getBounds());
        return strbuf.toString();
    }

    public static String getSegmentType(int val) {
        switch (val) {
            case 4: {
                return "SEG_CLOSE  ";
            }
            case 3: {
                return "SEG_CUBICTO";
            }
            case 1: {
                return "SEG_LINETO ";
            }
            case 0: {
                return "SEG_MOVETO ";
            }
            case 2: {
                return "SEG_QUADTO ";
            }
        }
        return "unknown";
    }

    public static final String toString(PathIterator it) {
        StringBuffer strbuf = new StringBuffer();
        float[] f = new float[6];
        while (!it.isDone()) {
            strbuf.append(StringLib.getSegmentType(it.currentSegment(f)));
            strbuf.append(" ");
            strbuf.append(StringLib.toString(f));
            strbuf.append("\n");
            it.next();
        }
        return strbuf.toString();
    }

    private static String getJoinString(BasicStroke bstk) {
        switch (bstk.getLineJoin()) {
            case 0: {
                return "Miter";
            }
            case 1: {
                return "Round";
            }
            case 2: {
                return "Bevel";
            }
        }
        return "Unknown";
    }

    private static String getCapString(BasicStroke bstk) {
        switch (bstk.getEndCap()) {
            case 0: {
                return "Butt";
            }
            case 1: {
                return "Round";
            }
            case 2: {
                return "Square";
            }
        }
        return "Unknown";
    }

    public static final String toString(BasicStroke bstk) {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append("[");
        strbuf.append("LineWidth: " + bstk.getLineWidth() + ", ");
        strbuf.append("EndCap: " + StringLib.getCapString(bstk) + ", ");
        strbuf.append("LineJoin: " + StringLib.getJoinString(bstk) + ", ");
        strbuf.append("MiterLimit: " + bstk.getMiterLimit() + ", ");
        strbuf.append("DashPhase: " + bstk.getDashPhase() + ", ");
        if (bstk.getDashArray() != null) {
            strbuf.append("DashArray: " + StringLib.toString(bstk.getDashArray()));
        }
        strbuf.append("]");
        return strbuf.toString();
    }

    public static void main(String[] argv) {
        System.out.println(StringLib.toCSV(new String[]{"a", "b", "c,d", ""}));
        LinkedList<String> list = new LinkedList<String>();
        list.add("");
        list.add("washington,dc");
        list.add("a");
        list.add("");
        list.add("");
        System.out.println(StringLib.toCSV(list));
    }
}

