/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util;

import edu.berkeley.guir.lib.debugging.Debug;
import edu.berkeley.guir.lib.util.Comparison;
import java.util.Random;

public class Sort {
    private static final void swap(int[] theArray, int index1, int index2) {
        int temp = theArray[index1];
        theArray[index1] = theArray[index2];
        theArray[index2] = temp;
    }

    private static final void swap(Object[] theArray, int index1, int index2) {
        Object temp = theArray[index1];
        theArray[index1] = theArray[index2];
        theArray[index2] = temp;
    }

    public static final long bubbleSort(int[] theArray) {
        boolean flagSwapped = true;
        long t0 = System.currentTimeMillis();
        int i = theArray.length - 1;
        while (i >= 0 && flagSwapped) {
            int j = 0;
            while (j < i) {
                flagSwapped = false;
                if (theArray[j] > theArray[j + 1]) {
                    Sort.swap(theArray, j, j + 1);
                    flagSwapped = true;
                }
                ++j;
            }
            --i;
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    public static final long bubbleSort(Object[] theArray, Comparison compare) {
        boolean flagSwapped = true;
        long t0 = System.currentTimeMillis();
        int i = theArray.length - 1;
        while (i >= 0 && flagSwapped) {
            int j = 0;
            while (j < i) {
                flagSwapped = false;
                if (compare.isGreaterThan(theArray[j], theArray[j + 1])) {
                    Sort.swap(theArray, j, j + 1);
                    flagSwapped = true;
                }
                ++j;
            }
            --i;
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    public static final long bidirBubbleSort(int[] theArray) {
        int limit = theArray.length;
        int st = -1;
        boolean flagSwapped = true;
        long t0 = System.currentTimeMillis();
        while (st < limit) {
            --limit;
            flagSwapped = false;
            int j = ++st;
            while (j < limit) {
                if (theArray[j] > theArray[j + 1]) {
                    Sort.swap(theArray, j, j + 1);
                    flagSwapped = true;
                }
                ++j;
            }
            if (!flagSwapped) break;
            j = limit - 1;
            while (j >= st) {
                if (theArray[j] > theArray[j + 1]) {
                    Sort.swap(theArray, j, j + 1);
                    flagSwapped = true;
                }
                --j;
            }
            if (!flagSwapped) break;
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    public static final long bidirBubbleSort(Object[] theArray, Comparison compare) {
        int limit = theArray.length;
        int st = -1;
        boolean flagSwapped = true;
        long t0 = System.currentTimeMillis();
        while (st < limit) {
            --limit;
            flagSwapped = false;
            int j = ++st;
            while (j < limit) {
                if (compare.isGreaterThan(theArray[j], theArray[j + 1])) {
                    Sort.swap(theArray, j, j + 1);
                    flagSwapped = true;
                }
                ++j;
            }
            if (!flagSwapped) break;
            j = limit - 1;
            while (j >= st) {
                if (compare.isGreaterThan(theArray[j], theArray[j + 1])) {
                    Sort.swap(theArray, j, j + 1);
                    flagSwapped = true;
                }
                --j;
            }
            if (!flagSwapped) break;
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    public static final long heapSort(int[] theArray) {
        long t0 = System.currentTimeMillis();
        int heapSize = theArray.length;
        int i = heapSize / 2;
        while (i > 0) {
            Sort.siftDown(theArray, i, heapSize);
            --i;
        }
        do {
            Sort.swap(theArray, 0, heapSize - 1);
            Sort.siftDown(theArray, 1, --heapSize);
        } while (heapSize > 1);
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private static final void siftDown(int[] theArray, int k, int heapSize) {
        boolean done = false;
        int temp = theArray[k - 1];
        while (k <= heapSize / 2 && !done) {
            int j = 2 * k;
            if (j < heapSize && theArray[j - 1] < theArray[j]) {
                ++j;
            }
            if (temp >= theArray[j - 1]) {
                done = true;
                continue;
            }
            theArray[k - 1] = theArray[j - 1];
            k = j;
        }
        theArray[k - 1] = temp;
    }

    public static final long heapSort(Object[] theArray, Comparison compare) {
        long t0 = System.currentTimeMillis();
        int heapSize = theArray.length;
        int i = heapSize / 2;
        while (i > 0) {
            Sort.siftDown(theArray, i, heapSize, compare);
            --i;
        }
        do {
            Sort.swap(theArray, 0, heapSize - 1);
            Sort.siftDown(theArray, 1, --heapSize, compare);
        } while (heapSize > 1);
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private static final void siftDown(Object[] theArray, int k, int heapSize, Comparison compare) {
        boolean done = false;
        Object temp = theArray[k - 1];
        while (k <= heapSize / 2 && !done) {
            int j = 2 * k;
            if (j < heapSize && compare.isLessThan(theArray[j - 1], theArray[j])) {
                ++j;
            }
            if (compare.isGreaterThanOrEqual(temp, theArray[j - 1])) {
                done = true;
                continue;
            }
            theArray[k - 1] = theArray[j - 1];
            k = j;
        }
        theArray[k - 1] = temp;
    }

    public static final long insertionSort(int[] theArray) {
        long t0 = System.currentTimeMillis();
        if (theArray.length > 0) {
            int i = 1;
            while (i < theArray.length) {
                Sort.insertLeft(theArray, theArray[i], i - 1);
                ++i;
            }
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private static final void insertLeft(int[] theArray, int aNumber, int index) {
        while (index >= 0 && aNumber < theArray[index]) {
            theArray[index + 1] = theArray[index];
            --index;
        }
        theArray[index + 1] = aNumber;
    }

    public static final long insertionSort(Object[] theArray, Comparison compare) {
        long t0 = System.currentTimeMillis();
        if (theArray.length > 0) {
            int i = 1;
            while (i < theArray.length) {
                Sort.insertLeft(theArray, theArray[i], i - 1, compare);
                ++i;
            }
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private static final void insertLeft(Object[] theArray, Object anObj, int index, Comparison compare) {
        while (index >= 0 && compare.isLessThan(anObj, theArray[index])) {
            theArray[index + 1] = theArray[index];
            --index;
        }
        theArray[index + 1] = anObj;
    }

    public static final long mergeSort(int[] theArray) {
        long t0 = System.currentTimeMillis();
        if (theArray.length > 0) {
            Sort.mergeSort(theArray, 0, theArray.length - 1);
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private static final void mergeSort(int[] theArray, int first, int last) {
        if (first < last) {
            int middle = (first + last) / 2;
            Sort.mergeSort(theArray, first, middle);
            Sort.mergeSort(theArray, middle + 1, last);
            Sort.merge(theArray, first, middle, last);
        }
    }

    private static final void merge(int[] theArray, int first, int middle, int last) {
        int[] tempArray = new int[theArray.length];
        int nextLeft = first;
        int nextRight = middle + 1;
        int index = first;
        while (nextLeft <= middle && nextRight <= last) {
            if (theArray[nextLeft] < theArray[nextRight]) {
                tempArray[index] = theArray[nextLeft];
                ++nextLeft;
                ++index;
                continue;
            }
            tempArray[index] = theArray[nextRight];
            ++nextRight;
            ++index;
        }
        while (nextLeft <= middle) {
            tempArray[index] = theArray[nextLeft];
            ++nextLeft;
            ++index;
        }
        while (nextRight <= last) {
            tempArray[index] = theArray[nextRight];
            ++nextRight;
            ++index;
        }
        index = first;
        while (index <= last) {
            theArray[index] = tempArray[index];
            ++index;
        }
    }

    public static final long mergeSort(Object[] theArray, Comparison compare) {
        long t0 = System.currentTimeMillis();
        if (theArray.length > 0) {
            Sort.mergeSort(theArray, 0, theArray.length - 1, compare);
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private static final void mergeSort(Object[] theArray, int first, int last, Comparison compare) {
        if (first < last) {
            int middle = (first + last) / 2;
            Sort.mergeSort(theArray, first, middle, compare);
            Sort.mergeSort(theArray, middle + 1, last, compare);
            Sort.merge(theArray, first, middle, last, compare);
        }
    }

    private static final void merge(Object[] theArray, int first, int middle, int last, Comparison compare) {
        Object[] tempArray = new Object[theArray.length];
        int nextLeft = first;
        int nextRight = middle + 1;
        int index = first;
        while (nextLeft <= middle && nextRight <= last) {
            if (compare.isLessThan(theArray[nextLeft], theArray[nextRight])) {
                tempArray[index] = theArray[nextLeft];
                ++nextLeft;
                ++index;
                continue;
            }
            tempArray[index] = theArray[nextRight];
            ++nextRight;
            ++index;
        }
        while (nextLeft <= middle) {
            tempArray[index] = theArray[nextLeft];
            ++nextLeft;
            ++index;
        }
        while (nextRight <= last) {
            tempArray[index] = theArray[nextRight];
            ++nextRight;
            ++index;
        }
        index = first;
        while (index <= last) {
            theArray[index] = tempArray[index];
            ++index;
        }
    }

    public static final long quickSort(int[] theArray) {
        long t0 = System.currentTimeMillis();
        if (theArray.length > 0) {
            Sort.quickSort(theArray, 0, theArray.length - 1);
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private static final void quickSort(int[] theArray, int low, int high) {
        if (low < high) {
            int pivot = theArray[low];
            int left = low;
            int right = high + 1;
            while (true) {
                if (++left < theArray.length && theArray[left] <= pivot) {
                    continue;
                }
                while (--right > 0 && theArray[right] > pivot) {
                }
                if (left < right) {
                    Sort.swap(theArray, left, right);
                }
                if (left >= right) break;
            }
            Sort.swap(theArray, low, right);
            Sort.quickSort(theArray, low, right - 1);
            Sort.quickSort(theArray, right + 1, high);
        }
    }

    public static final long quickSort(Object[] theArray, Comparison compare) {
        long t0 = System.currentTimeMillis();
        if (theArray.length > 0) {
            Sort.quickSort(theArray, 0, theArray.length - 1, compare);
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    private static final void quickSort(Object[] theArray, int low, int high, Comparison compare) {
        if (low < high) {
            Object pivot = theArray[low];
            int left = low;
            int right = high + 1;
            while (true) {
                if (++left < theArray.length && compare.isLessThanOrEqual(theArray[left], pivot)) {
                    continue;
                }
                while (--right > 0 && compare.isGreaterThan(theArray[right], pivot)) {
                }
                if (left < right) {
                    Sort.swap(theArray, left, right);
                }
                if (left >= right) break;
            }
            Sort.swap(theArray, low, right);
            Sort.quickSort(theArray, low, right - 1, compare);
            Sort.quickSort(theArray, right + 1, high, compare);
        }
    }

    public static final long selectionSort(int[] theArray) {
        long t0 = System.currentTimeMillis();
        int i = 0;
        while (i < theArray.length - 1) {
            int min = i;
            int j = min + 1;
            while (j < theArray.length) {
                if (theArray[j] < theArray[min]) {
                    min = j;
                }
                ++j;
            }
            Sort.swap(theArray, i, min);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    public static final long selectionSort(Object[] theArray, Comparison compare) {
        long t0 = System.currentTimeMillis();
        int i = 0;
        while (i < theArray.length - 1) {
            int min = i;
            int j = min + 1;
            while (j < theArray.length) {
                if (compare.isLessThan(theArray[j], theArray[min])) {
                    min = j;
                }
                ++j;
            }
            Sort.swap(theArray, i, min);
            ++i;
        }
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    public static final long shellSort(int[] theArray) {
        long t0 = System.currentTimeMillis();
        long t1 = System.currentTimeMillis();
        return t1 - t0;
    }

    public static void main(String[] argv) {
        Random rand = new Random();
        int arrSize = Integer.parseInt(argv[0]);
        if (argv.length == 0) {
            System.out.println("java util.Sort [size of array]");
            System.exit(1);
        }
        int[] origArray = new int[arrSize];
        int[] array = new int[arrSize];
        int i = 0;
        while (i < origArray.length) {
            origArray[i] = rand.nextInt();
            ++i;
        }
        int j = 0;
        while (j < 7) {
            int i2 = 0;
            while (i2 < origArray.length) {
                array[i2] = origArray[i2];
                ++i2;
            }
            switch (j) {
                case 0: {
                    System.out.println("SelectionSort on " + array.length);
                    System.out.println("Elapsed (ms): " + Sort.selectionSort(array));
                    Debug.println(array);
                    break;
                }
                case 1: {
                    System.out.println("BubbleSort on " + array.length);
                    System.out.println("Elapsed (ms): " + Sort.bubbleSort(array));
                    Debug.println(array);
                    break;
                }
                case 2: {
                    System.out.println("BidirectionalBubbleSort on " + array.length);
                    System.out.println("Elapsed (ms): " + Sort.bidirBubbleSort(array));
                    Debug.println(array);
                    break;
                }
                case 3: {
                    System.out.println("InsertionSort on " + array.length);
                    System.out.println("Elapsed (ms): " + Sort.insertionSort(array));
                    Debug.println(array);
                    break;
                }
                case 4: {
                    System.out.println("MergeSort on " + array.length);
                    System.out.println("Elapsed (ms): " + Sort.mergeSort(array));
                    Debug.println(array);
                    break;
                }
                case 5: {
                    System.out.println("HeapSort on " + array.length);
                    System.out.println("Elapsed (ms): " + Sort.heapSort(array));
                    Debug.println(array);
                    break;
                }
                case 6: {
                    System.out.println("QuickSort on " + array.length);
                    System.out.println("Elapsed (ms): " + Sort.quickSort(array));
                    Debug.println(array);
                }
            }
            System.out.println();
            ++j;
        }
    }
}

