/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util;

import edu.berkeley.guir.lib.io.IOLib;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;

public class ResourceLib {
    private ResourceLib() {
    }

    private static String clipPath(Class cl, String strFile) {
        String strPath = cl.getName();
        int index = strPath.lastIndexOf(".");
        strPath = strPath.substring(0, index + 1);
        if (strFile.length() >= strPath.length()) {
            return strFile.substring(strPath.length());
        }
        return null;
    }

    private static File toFile(String strPath, String strFile) {
        return new File(strPath, strFile);
    }

    private static String toFileUrl(File f) throws IOException {
        return "file:/" + f.getCanonicalPath();
    }

    private static String toFileUrl(String strPath, String strFile) {
        if (!strPath.endsWith("/") && !strFile.startsWith("/")) {
            strPath = String.valueOf(strPath) + "/";
        }
        return "file:/" + strPath + strFile;
    }

    public static URL getResourceAsUrl(Class cl, String strFile) {
        URL url = cl.getResource(strFile);
        if (url == null) {
            url = cl.getResource(ResourceLib.clipPath(cl, strFile));
        }
        if (url != null) {
            return url;
        }
        File f = ResourceLib.toFile(System.getProperty("user.dir"), strFile);
        if (!f.exists()) {
            return null;
        }
        try {
            return new URL(ResourceLib.toFileUrl(f));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static InputStream getResourceAsStream(Class cl, String strFile) {
        InputStream istream = cl.getResourceAsStream(strFile);
        if (istream == null) {
            istream = cl.getResourceAsStream(ResourceLib.clipPath(cl, strFile));
        }
        if (istream != null) {
            return istream;
        }
        File f = ResourceLib.toFile(System.getProperty("user.dir"), strFile);
        if (!f.exists()) {
            return null;
        }
        try {
            return new FileInputStream(f);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Reader getResourceAsReader(Class cl, String strFile) {
        InputStream istream = ResourceLib.getResourceAsStream(cl, strFile);
        if (istream == null) {
            return null;
        }
        return new InputStreamReader(istream);
    }

    public static String getResourceAsString(Class cl, String strFile) {
        try {
            Reader rdr = ResourceLib.getResourceAsReader(cl, strFile);
            StringBuffer strbuf = IOLib.readAll(rdr);
            return strbuf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

