/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util;

import java.util.Random;

public class RandomLib {
    static Random librand;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.util.RandomLib");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        librand = new Random();
    }

    private RandomLib() {
    }

    public static double nextDouble(double a, double b) {
        return RandomLib.nextDouble(librand, a, b);
    }

    public static double nextDouble(Random rand, double a, double b) {
        if (!$assertionsDisabled && !(a < b)) {
            throw new AssertionError();
        }
        double r = rand.nextDouble();
        r *= b - a;
        if ((r += a) > b) {
            r = b;
        }
        return r;
    }

    public static float nextFloat(float a, float b) {
        return RandomLib.nextFloat(librand, a, b);
    }

    public static float nextFloat(Random rand, float a, float b) {
        if (!$assertionsDisabled && !(a < b)) {
            throw new AssertionError();
        }
        float r = rand.nextFloat();
        r *= b - a;
        if ((r += a) > b) {
            r = b;
        }
        return r;
    }

    public static int nextInt(int a, int b) {
        return RandomLib.nextInt(librand, a, b);
    }

    public static int nextInt(Random rand, int a, int b) {
        if (!$assertionsDisabled && a >= b) {
            throw new AssertionError();
        }
        double r = rand.nextDouble();
        r *= (double)(b - a + 1);
        r += (double)a;
        if ((r = Math.floor(r)) > (double)b) {
            r = b;
        }
        return (int)r;
    }

    public static void main(String[] argv) {
        int iterations = 100000;
        int minval = 1;
        int maxval = 6;
        int[] arr = new int[maxval - minval + 1];
        int i = 0;
        while (i < iterations) {
            int val = RandomLib.nextInt(minval, maxval);
            int n = val - minval;
            arr[n] = arr[n] + 1;
            ++i;
        }
        i = 0;
        while (i < arr.length) {
            System.out.println("array[" + (i + minval) + "] - " + arr[i]);
            ++i;
        }
        i = 0;
        while (i < 20) {
            System.out.println(RandomLib.nextFloat(1.0f, 6.0f));
            ++i;
        }
    }
}

