/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util;

import edu.berkeley.guir.lib.util.Pollable;
import edu.berkeley.guir.lib.util.ThreadPool;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class PollingPool {
    public static final int DEFAULT_SLEEPTIME = 500;
    private static final boolean DEBUG = false;
    Set setPollable = new HashSet();
    Thread t;
    int sleepTime = 500;
    Random rand = new Random();
    ThreadPool tpool = null;
    List listPollableTmp = new LinkedList();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.util.PollingPool");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    private static final void println(String str) {
    }

    public PollingPool() {
        this.t = new Thread(new PollJob());
        this.t.start();
    }

    public PollingPool(ThreadPool newTpool) {
        this.setThreadPool(newTpool);
        this.t = new Thread(new PollJob());
        this.t.start();
    }

    public void setSleepTime(int newSleepTime) {
        if (!$assertionsDisabled && newSleepTime <= 0) {
            throw new AssertionError();
        }
        this.sleepTime = newSleepTime;
    }

    public void setThreadPool(ThreadPool newTpool) {
        if (!$assertionsDisabled && newTpool == null) {
            throw new AssertionError();
        }
        this.tpool = newTpool;
    }

    public void add(Pollable p) {
        this.setPollable.add(p);
    }

    public void remove(Pollable p) {
        this.setPollable.remove(p);
    }

    public void clear() {
        this.setPollable.clear();
    }

    public Iterator iterator() {
        return this.setPollable.iterator();
    }

    public Set getPollables() {
        return new HashSet(this.setPollable);
    }

    private void fireEvent(Pollable p) {
        if (this.tpool == null) {
            p.onReady();
        } else {
            this.tpool.run(new ReadyCallbackJob(p));
        }
    }

    private synchronized void poll() {
        this.listPollableTmp.clear();
        this.listPollableTmp.addAll(this.setPollable);
        Iterator it = this.listPollableTmp.iterator();
        while (it.hasNext()) {
            Pollable p = (Pollable)it.next();
            try {
                if (!p.isReady()) continue;
                this.fireEvent(p);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }

    class PollJob
    implements Runnable {
        PollJob() {
        }

        public void run() {
            while (true) {
                try {
                    PollingPool.println("polling...");
                    PollingPool.this.poll();
                    Thread.yield();
                    PollingPool.println("sleeping...");
                    Thread.sleep(PollingPool.this.sleepTime + Math.abs(PollingPool.this.rand.nextInt()) % 1000);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }
    }

    class ReadyCallbackJob
    implements Runnable {
        Pollable p;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("edu.berkeley.guir.lib.util.PollingPool$ReadyCallbackJob");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public ReadyCallbackJob(Pollable newP) {
            if (!$assertionsDisabled && newP == null) {
                throw new AssertionError();
            }
            this.p = newP;
        }

        public void run() {
            this.p.onReady();
        }
    }
}

