/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util;

import edu.berkeley.guir.lib.util.ParseException;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.Color;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class ParserLib {
    private static final boolean DEBUG = false;
    public static final String DELIMITERS = " ,\t\n\r";

    public static String[] parseSSV(String strLine) {
        return ParserLib.parseByDelimiter(strLine, ' ', true);
    }

    public static String[] parseTSV(String strLine) {
        int startIndex = 0;
        int endIndex = 0;
        int len = strLine.length();
        LinkedList<String> listToks = new LinkedList<String>();
        while (startIndex < len && endIndex < len) {
            String strTmp;
            endIndex = strLine.indexOf(9, startIndex);
            if (endIndex < 0) {
                strTmp = strLine.substring(startIndex);
                endIndex = len;
            } else {
                strTmp = strLine.substring(startIndex, endIndex);
                startIndex = endIndex + 1;
            }
            listToks.add(strTmp);
        }
        if (strLine.endsWith("\t")) {
            listToks.add("");
        }
        return listToks.toArray(new String[0]);
    }

    public static String[] parseCSV(String strLine) {
        return ParserLib.parseByDelimiter(strLine, ',', false);
    }

    public static String[] parseByDelimiter(String strLine, char chDelimiter, boolean flagCoalesce) {
        int startIndex = 0;
        int endIndex = 0;
        int len = strLine.length();
        LinkedList<String> listToks = new LinkedList<String>();
        if (flagCoalesce) {
            int i = 0;
            while (i < len) {
                if (strLine.charAt(i) != chDelimiter) break;
                ++startIndex;
                ++i;
            }
        }
        while (startIndex < len && endIndex < len) {
            String strTmp;
            if (strLine.charAt(startIndex) == '\"') {
                endIndex = strLine.indexOf(34, ++startIndex);
                strTmp = strLine.substring(startIndex, endIndex);
                startIndex = endIndex + 2;
            } else {
                boolean flagIncrementingEnd = false;
                endIndex = strLine.indexOf(chDelimiter, startIndex);
                while (flagCoalesce && endIndex >= 0 && endIndex + 1 < len) {
                    if (strLine.charAt(endIndex + 1) != chDelimiter) break;
                    if (++endIndex + 1 < len) continue;
                    flagIncrementingEnd = true;
                    break;
                }
                if (flagCoalesce && flagIncrementingEnd && endIndex + 1 >= len) break;
                if (endIndex < 0) {
                    strTmp = strLine.substring(startIndex);
                    endIndex = len;
                } else {
                    strTmp = strLine.substring(startIndex, endIndex);
                    startIndex = endIndex + 1;
                }
            }
            listToks.add(strTmp);
        }
        if (!flagCoalesce && strLine.endsWith("" + chDelimiter)) {
            listToks.add("");
        }
        return listToks.toArray(new String[0]);
    }

    private static int getArraySize(String str) {
        int size = StringLib.countNumOfChar(',', str);
        if (str.charAt(str.length() - 1) != ',') {
            ++size;
        }
        return size;
    }

    public static final int[] parseIntArray(String str) throws ParseException {
        StringTokenizer strtok = new StringTokenizer(str, DELIMITERS);
        str = str.trim();
        int size = ParserLib.getArraySize(str);
        int[] intArray = new int[size];
        int i = 0;
        while (i < size) {
            intArray[i] = Integer.parseInt(strtok.nextToken());
            ++i;
        }
        return intArray;
    }

    public static final float[] parseFloatArray(String str) throws ParseException {
        StringTokenizer strtok = new StringTokenizer(str, DELIMITERS);
        str = str.trim();
        int size = ParserLib.getArraySize(str);
        float[] fArray = new float[size];
        int i = 0;
        while (i < size) {
            fArray[i] = Float.valueOf(strtok.nextToken()).floatValue();
            ++i;
        }
        return fArray;
    }

    public static final List parseList(String str) throws ParseException {
        if (!str.startsWith("[") || !str.endsWith("]")) {
            throw new ParseException("Not a valid List: " + str);
        }
        str = str.substring(1, str.length() - 1);
        LinkedList<String> list = new LinkedList<String>();
        StringTokenizer strtok = new StringTokenizer(str, ", ");
        while (strtok.hasMoreTokens()) {
            list.add(strtok.nextToken());
        }
        return list;
    }

    public static final Map parseAsMap(String str, char ch) {
        char[] chArray = new char[]{ch, '\r', '\n'};
        StringTokenizer strtok = new StringTokenizer(str, new String(chArray));
        HashMap<String, String> map = new HashMap<String, String>();
        String strKey = "";
        String strVal = "";
        boolean flagParsingName = true;
        while (strtok.hasMoreTokens()) {
            if (flagParsingName) {
                strKey = strtok.nextToken();
                flagParsingName = false;
                continue;
            }
            strVal = strtok.nextToken();
            flagParsingName = true;
            map.put(strKey, strVal);
        }
        return map;
    }

    public static final Color parseColor(String str) throws ParseException {
        try {
            str = str.toLowerCase();
            if (StringLib.containsChars(str, "0123456789")) {
                return ParserLib.parseColorTuple(str);
            }
            return ParserLib.parseColorName(str);
        }
        catch (Exception e) {
            throw new ParseException(e.getMessage());
        }
    }

    private static final Color parseColorTuple(String str) throws Exception {
        StringTokenizer strtok = new StringTokenizer(str, DELIMITERS);
        String strR = strtok.nextToken();
        String strG = strtok.nextToken();
        String strB = strtok.nextToken();
        int r = Integer.parseInt(strR);
        int g = Integer.parseInt(strG);
        int b = Integer.parseInt(strB);
        if (strtok.hasMoreTokens()) {
            String strA = strtok.nextToken();
            int a = Integer.parseInt(strA);
            return new Color(r, g, b, a);
        }
        return new Color(r, g, b);
    }

    private static final Color parseColorName(String str) throws Exception {
        if (str.equalsIgnoreCase("black")) {
            return Color.black;
        }
        if (str.equalsIgnoreCase("blue")) {
            return Color.blue;
        }
        if (str.equalsIgnoreCase("cyan")) {
            return Color.cyan;
        }
        if (str.equalsIgnoreCase("darkGray")) {
            return Color.darkGray;
        }
        if (str.equalsIgnoreCase("gray")) {
            return Color.gray;
        }
        if (str.equalsIgnoreCase("green")) {
            return Color.green;
        }
        if (str.equalsIgnoreCase("lightGray")) {
            return Color.lightGray;
        }
        if (str.equalsIgnoreCase("magenta")) {
            return Color.magenta;
        }
        if (str.equalsIgnoreCase("orange")) {
            return Color.orange;
        }
        if (str.equalsIgnoreCase("pink")) {
            return Color.pink;
        }
        if (str.equalsIgnoreCase("red")) {
            return Color.red;
        }
        if (str.equalsIgnoreCase("white")) {
            return Color.white;
        }
        if (str.equalsIgnoreCase("yellow")) {
            return Color.yellow;
        }
        return Color.black;
    }

    private static void runTestAAA() throws Exception {
        System.out.println(ParserLib.parseColor("black"));
        System.out.println(ParserLib.parseColor("white"));
        System.out.println(ParserLib.parseColor("180, 180, 180"));
        System.out.println(ParserLib.parseColor("200, 200, 200, 200"));
        System.out.println(StringLib.toString(ParserLib.parseFloatArray("1,2, 3,  4, 5.0, 6.145, 7.123")));
        System.out.println("--------------");
        System.out.println(ParserLib.parseList("[location, activity]"));
        System.out.println(ParserLib.parseList("[a, b, c, d, e, f, g]"));
        System.out.println(ParserLib.parseList("[]"));
        System.out.println(ParserLib.parseList(""));
    }

    private static void runTestBBB() {
        ParserLib.parseCSV("A,B,C,D,E");
        System.out.println("----------------");
        ParserLib.parseCSV("A,B,C,D,E,");
        System.out.println("----------------");
        ParserLib.parseCSV("A,,C,,E,");
        System.out.println("----------------");
        ParserLib.parseCSV(",,C,,E,");
        System.out.println("----------------");
        ParserLib.parseCSV(",");
        System.out.println("----------------");
        ParserLib.parseCSV("");
        System.out.println("----------------");
        ParserLib.parseCSV("\"Washington, DC\"");
        System.out.println("----------------");
        ParserLib.parseCSV("\"Washington, DC\",Atlanta,\"Washington, DC\"");
        System.out.println("----------------");
        ParserLib.parseCSV("\"Washington, DC\",Atlanta,\"Washington, DC\",");
        System.out.println("----------------");
        ParserLib.parseCSV("\"Washington, DC\",\"Washington, DC\",");
    }

    private static void runTestCCC() {
        ParserLib.parseSSV("A B C D E");
        System.out.println("----------------");
        ParserLib.parseSSV("A B C D E ");
        System.out.println("----------------");
        ParserLib.parseSSV("A  C  E ");
        System.out.println("----------------");
        ParserLib.parseSSV("  C  E ");
        System.out.println("----------------");
        ParserLib.parseSSV(" ");
        System.out.println("----------------");
        ParserLib.parseSSV("");
        System.out.println("----------------");
        ParserLib.parseSSV("\"Washington, DC\"");
        System.out.println("----------------");
        ParserLib.parseSSV("\"Washington, DC\" Atlanta \"Washington, DC\"");
        System.out.println("----------------");
        ParserLib.parseSSV("\"Washington, DC\" Atlanta \"Washington, DC\" ");
        System.out.println("----------------");
        ParserLib.parseSSV("\"Washington, DC\" \"Washington, DC\" ");
    }

    public static void main(String[] argv) throws Exception {
        ParserLib.runTestBBB();
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println();
        ParserLib.runTestCCC();
    }
}

