/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util;

public abstract class DelayedThread {
    long timeWakeup;
    boolean flagRunning = false;
    boolean flagAbort = false;

    public void setDelay(int millisOffset) {
        this.timeWakeup = System.currentTimeMillis() + (long)millisOffset;
        if (!this.flagRunning) {
            this.flagRunning = true;
            new InternalThread().start();
        }
    }

    public abstract void doTask();

    public void abort() {
        this.flagAbort = true;
        this.flagRunning = false;
    }

    public int getDelay() {
        return (int)Math.max(0L, this.timeWakeup - System.currentTimeMillis());
    }

    private static DelayedThread getTestInstanceAAA() {
        DelayedThread t = new DelayedThread(){

            public void doTask() {
                System.out.println("running thread");
            }
        };
        return t;
    }

    private static void runTestAAA() throws Exception {
        DelayedThread t = DelayedThread.getTestInstanceAAA();
        t.setDelay(5000);
        System.out.println("Delay 5000");
        System.out.println(t.getDelay());
        System.out.println("Sleep 3000");
        System.out.println(t.getDelay());
        Thread.sleep(3000L);
        System.out.println(t.getDelay());
        System.out.println("Delay 5000");
        t.setDelay(5000);
        System.out.println(t.getDelay());
    }

    private static void runTestBBB() throws Exception {
        DelayedThread t = DelayedThread.getTestInstanceAAA();
        t.setDelay(5000);
        System.out.println("Delay 5000");
        System.out.println(t.getDelay());
        System.out.println("Sleep 3000");
        System.out.println(t.getDelay());
        Thread.sleep(3000L);
        t.abort();
        System.out.println("abort");
        System.out.println(t.getDelay());
    }

    public static void main(String[] argv) throws Exception {
        DelayedThread.runTestBBB();
    }

    class InternalThread
    extends Thread {
        InternalThread() {
        }

        public void run() {
            long currentTimeMillis = System.currentTimeMillis();
            while (currentTimeMillis < DelayedThread.this.timeWakeup) {
                try {
                    Thread.sleep(DelayedThread.this.timeWakeup - currentTimeMillis);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                currentTimeMillis = System.currentTimeMillis();
            }
            DelayedThread.this.flagRunning = false;
            if (!DelayedThread.this.flagAbort) {
                DelayedThread.this.doTask();
            }
        }
    }
}

