/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util;

import edu.berkeley.guir.lib.util.StringLib;
import edu.berkeley.guir.lib.util.condition.DayOfWeekCondition;

public class DayOfWeekLib {
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    private static final String[] DAYS_FULL = new String[]{"sunday", "monday", "tuesday", "wednesday", "thursday", "friday", "saturday"};
    private static final String[] DAYS_SHORT = new String[]{"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
    public static final String[] ARRAY_WEEKDAYS = new String[]{"mon", "tue", "wed", "thu", "fri"};
    public static final String[] ARRAY_WEEKEND = new String[]{"sun", "sat"};

    public static String[] asStringArray(int[] arrDays, boolean flagUseFullDay) {
        String[] strArr = new String[arrDays.length];
        int i = 0;
        while (i < arrDays.length) {
            strArr[i] = flagUseFullDay ? DayOfWeekLib.toFullDay(arrDays[i]) : DayOfWeekLib.toShortDay(arrDays[i]);
            ++i;
        }
        return strArr;
    }

    public static int[] asIntArray(String[] arrDays) {
        int[] arr = new int[arrDays.length];
        int i = 0;
        while (i < arrDays.length) {
            arr[i] = DayOfWeekLib.fromString(arrDays[i]);
            ++i;
        }
        return arr;
    }

    public static String toCSVDays(int[] arrDays, boolean flagUseFullDay) {
        StringBuffer strbuf = new StringBuffer();
        int i = 0;
        while (i < arrDays.length) {
            if (i != 0) {
                strbuf.append(",");
            }
            if (flagUseFullDay) {
                strbuf.append(DayOfWeekLib.toFullDay(arrDays[i]));
            } else {
                strbuf.append(DayOfWeekLib.toShortDay(arrDays[i]));
            }
            ++i;
        }
        return strbuf.toString();
    }

    public static String toConsecutiveDays(int[] arrDays, String strThru, boolean flagUseFullDay) {
        if (arrDays.length == 1) {
            if (flagUseFullDay) {
                return DayOfWeekLib.toFullDay(arrDays[0]);
            }
            return DayOfWeekLib.toShortDay(arrDays[0]);
        }
        StringBuffer strbuf = new StringBuffer();
        int start = 0;
        int end = arrDays.length;
        while (start < arrDays.length) {
            String strStart;
            if (start != 0) {
                strbuf.append(",");
            }
            end = DayOfWeekLib.getIndexOfConsecutiveEnd(arrDays, start);
            String strEnd = "";
            if (flagUseFullDay) {
                strStart = DayOfWeekLib.toFullDay(arrDays[start]);
                if (start + 1 != end) {
                    strEnd = String.valueOf(strThru) + DayOfWeekLib.toFullDay(arrDays[end - 1]);
                }
            } else {
                strStart = DayOfWeekLib.toShortDay(arrDays[start]);
                if (start + 1 != end) {
                    strEnd = String.valueOf(strThru) + DayOfWeekLib.toShortDay(arrDays[end - 1]);
                }
            }
            strbuf.append(String.valueOf(strStart) + strEnd);
            start = end;
        }
        return strbuf.toString();
    }

    private static int getIndexOfConsecutiveEnd(int[] arr, int start) {
        int valAA = arr[start];
        int i = start + 1;
        while (i < arr.length) {
            int valBB = arr[i];
            if (valAA + 1 != valBB) {
                return i;
            }
            valAA = valBB;
            ++i;
        }
        return arr.length;
    }

    public static String toShortDay(int val) {
        switch (val) {
            case 0: {
                return "Sun";
            }
            case 1: {
                return "Mon";
            }
            case 2: {
                return "Tue";
            }
            case 3: {
                return "Wed";
            }
            case 4: {
                return "Thu";
            }
            case 5: {
                return "Fri";
            }
            case 6: {
                return "Sat";
            }
        }
        throw new IllegalArgumentException("unknown value: " + val);
    }

    public static String toFullDay(int val) {
        switch (val) {
            case 0: {
                return "Sunday";
            }
            case 1: {
                return "Monday";
            }
            case 2: {
                return "Tuesday";
            }
            case 3: {
                return "Wednesday";
            }
            case 4: {
                return "Thursday";
            }
            case 5: {
                return "Friday";
            }
            case 6: {
                return "Saturday";
            }
        }
        throw new IllegalArgumentException("unknown value: " + val);
    }

    public static int fromString(String str) {
        str = str.toLowerCase();
        int i = 0;
        while (i < DAYS_FULL.length) {
            if (DAYS_FULL[i].equals(str) || DAYS_SHORT[i].equals(str)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("unknown value: " + str);
    }

    private static void testDays(int[] arrDays) {
        System.out.println(DayOfWeekLib.toConsecutiveDays(arrDays, "-", true));
        Object[] arr = DayOfWeekLib.asStringArray(arrDays, true);
        System.out.println(StringLib.toString(arr));
        arr = DayOfWeekLib.asStringArray(arrDays, false);
        System.out.println(StringLib.toString(arr));
        System.out.println(new DayOfWeekCondition((String[])arr));
        System.out.println("----------------");
    }

    private static void runTestAAA() {
        int[] nArray = new int[7];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArray[4] = 4;
        nArray[5] = 5;
        nArray[6] = 6;
        DayOfWeekLib.testDays(nArray);
        int[] nArray2 = new int[4];
        nArray2[1] = 2;
        nArray2[2] = 4;
        nArray2[3] = 6;
        DayOfWeekLib.testDays(nArray2);
        DayOfWeekLib.testDays(new int[]{1, 2, 4, 5});
        DayOfWeekLib.testDays(new int[1]);
        int[] nArray3 = new int[2];
        nArray3[1] = 1;
        DayOfWeekLib.testDays(nArray3);
    }

    private static void runTestBBB() {
        System.out.println(DayOfWeekLib.fromString("Sunday"));
        System.out.println(DayOfWeekLib.fromString("Sun"));
        System.out.println(DayOfWeekLib.fromString("Fri"));
        System.out.println(DayOfWeekLib.fromString("Friday"));
        System.out.println(DayOfWeekLib.fromString("error"));
    }

    public static void main(String[] argv) {
        DayOfWeekLib.runTestBBB();
    }
}

