/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateLib {
    static final Calendar cal = Calendar.getInstance();

    private DateLib() {
    }

    public static String getCurrentISODate() {
        return DateLib.DateToISO(new Date());
    }

    public static int compareDate(Date date1, Date date2) {
        if (date2.after(date1)) {
            return -1;
        }
        if (date1.after(date2)) {
            return 1;
        }
        return 0;
    }

    public static int compareDate(Date date1, String strDate2) {
        Date d2 = DateLib.ISOToDate(strDate2);
        return DateLib.compareDate(date1, d2);
    }

    public static int compareDate(String strDate1, Date date2) {
        Date d1 = DateLib.ISOToDate(strDate1);
        return DateLib.compareDate(d1, date2);
    }

    public static int compareDate(String strDate1, String strDate2) {
        Date d1 = DateLib.ISOToDate(strDate1);
        Date d2 = DateLib.ISOToDate(strDate2);
        return DateLib.compareDate(d1, d2);
    }

    private static String padValue(int val) {
        if (val >= 0 && val <= 9) {
            return "0" + val;
        }
        return "" + val;
    }

    public static synchronized String DateToISO(Date date) {
        cal.setTime(date);
        return String.valueOf(DateLib.padValue(cal.get(1))) + DateLib.padValue(cal.get(2) + 1) + DateLib.padValue(cal.get(5)) + "T" + DateLib.padValue(cal.get(11)) + DateLib.padValue(cal.get(12)) + DateLib.padValue(cal.get(13));
    }

    public static boolean isValidISODate(String str) {
        try {
            DateLib.ISOToDate(str);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static synchronized Date ISOToDate(String str) {
        int strlen = str.length();
        if (15 > strlen || strlen > 16) {
            throw new IllegalArgumentException("String must be 15 or 16 chars long");
        }
        if (str.charAt(8) != 'T') {
            throw new IllegalArgumentException("Missing the 'T' in the ISO Date");
        }
        String strYear = str.substring(0, 4);
        String strMonth = str.substring(4, 6);
        String strDay = str.substring(6, 8);
        String strHour = str.substring(9, 11);
        String strMinute = str.substring(11, 13);
        String strSecond = str.substring(13, 15);
        if (str.length() == 16 && str.charAt(15) == 'Z') {
            cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        int year = Integer.parseInt(strYear);
        int month = Integer.parseInt(strMonth) - 1;
        int day = Integer.parseInt(strDay);
        int hour = Integer.parseInt(strHour);
        int minute = Integer.parseInt(strMinute);
        int second = Integer.parseInt(strSecond);
        if (year < 0 || year > 9999) {
            throw new IllegalArgumentException("Year value " + year + " is out of range");
        }
        if (month < 0 || month > 11) {
            throw new IllegalArgumentException("Month value " + month + " is out of range");
        }
        if (1 > day || day > 31) {
            throw new IllegalArgumentException("Day value " + day + " is out of range");
        }
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("Hour value " + hour + " is out of range");
        }
        if (hour < 0 || hour > 59) {
            throw new IllegalArgumentException("Minute value " + minute + " is out of range");
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("Seconds value " + second + " is out of range");
        }
        cal.set(year, month, day, hour, minute, second);
        return cal.getTime();
    }

    public static void main(String[] argv) {
        System.out.println(DateLib.ISOToDate("19960101T000000"));
        System.out.println(DateLib.ISOToDate("19990101T000000"));
        System.out.println(DateLib.compareDate("19960101T000000", "19990101T000000"));
    }
}

