/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.util;

import java.util.LinkedList;
import java.util.List;

public final class ClassLib {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    private ClassLib() {
    }

    public static final List flatten(Class cl) {
        LinkedList listClasses = new LinkedList();
        while (cl != null) {
            listClasses.add(cl);
            Class<?>[] clArr = cl.getInterfaces();
            int i = 0;
            while (i < clArr.length) {
                listClasses.add(clArr[i]);
                ++i;
            }
            cl = cl.getSuperclass();
        }
        return listClasses;
    }

    public static String getShortClassName(Object obj) {
        String longName = obj instanceof Class ? ((Class)obj).getName() : obj.getClass().getName();
        return ClassLib.toShortClassName(longName);
    }

    public static final String toShortClassName(String strClassName) {
        int index = strClassName.lastIndexOf(46);
        if (index >= 0) {
            return strClassName.substring(index + 1);
        }
        return strClassName;
    }

    public static Class load(String strClassName, ClassLoader loader) {
        if (loader != null) {
            try {
                return loader.loadClass(strClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Class loadClass(String strClassName) throws ClassNotFoundException {
        return ClassLib.loadClass(strClassName, null);
    }

    public static Class loadClass(String strClassName, Class clCaller) throws ClassNotFoundException {
        Class cl = ClassLib.load(strClassName, Thread.currentThread().getContextClassLoader());
        if (cl != null) {
            return cl;
        }
        cl = ClassLib.load(strClassName, clCaller.getClassLoader());
        if (cl != null) {
            return cl;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.util.ClassLib");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((cl = ClassLib.load(strClassName, clazz.getClassLoader())) != null) {
            return cl;
        }
        return Class.forName(strClassName);
    }

    private static void runTestAAA() {
        System.out.println("".getClass());
        System.out.println(ClassLib.getShortClassName(""));
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Cloneable");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(ClassLib.getShortClassName(clazz));
    }

    private static void runTestBBB() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(ClassLib.flatten(clazz));
        System.out.println();
        Class<?> clazz2 = class$3;
        if (clazz2 == null) {
            try {
                clazz2 = class$3 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(ClassLib.flatten(clazz2));
        System.out.println();
        Class<?> clazz3 = class$4;
        if (clazz3 == null) {
            try {
                clazz3 = class$4 = Class.forName("java.lang.StringBuffer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(ClassLib.flatten(clazz3));
        System.out.println();
        Class<?> clazz4 = class$5;
        if (clazz4 == null) {
            try {
                clazz4 = class$5 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(ClassLib.flatten(clazz4));
        System.out.println();
        Class<?> clazz5 = class$6;
        if (clazz5 == null) {
            try {
                clazz5 = class$6 = Class.forName("java.util.LinkedList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        System.out.println(ClassLib.flatten(clazz5));
        System.out.println();
    }

    private static void runTestJackHasBeenHereHahaha() {
        String testString = "";
        System.out.println("String =?= " + ClassLib.getShortClassName(""));
        System.out.println("String =?= " + ClassLib.getShortClassName("".getClass()));
        LinkedList testList = new LinkedList();
        System.out.println("LinkedList =?= " + ClassLib.getShortClassName(testList));
        System.out.println("LinkedList =?= " + ClassLib.getShortClassName(testList.getClass()));
    }

    public static void main(String[] argv) {
        ClassLib.runTestJackHasBeenHereHahaha();
    }
}

