/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing.treetable;

import edu.berkeley.guir.lib.swing.treetable.AbstractCellEditor;
import edu.berkeley.guir.lib.swing.treetable.TreeTableModel;
import edu.berkeley.guir.lib.swing.treetable.TreeTableModelAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class JTreeTable
extends JTable {
    protected TreeTableCellRenderer tree;
    protected TreeTableCellEditor editor;
    protected TreeTableModel model;
    static /* synthetic */ Class class$0;

    public JTreeTable(TreeTableModel treeTableModel) {
        this.tree = new TreeTableCellRenderer(treeTableModel);
        this.editor = new TreeTableCellEditor();
        this.model = treeTableModel;
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.swing.treetable.TreeTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultRenderer(clazz, this.tree);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("edu.berkeley.guir.lib.swing.treetable.TreeTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDefaultEditor(clazz2, this.editor);
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        }
        Listener l = new Listener();
        this.addMouseListener(l);
        this.addMouseMotionListener(l);
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    public int getEditingRow() {
        Class<?> clazz = this.getColumnClass(this.editingColumn);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("edu.berkeley.guir.lib.swing.treetable.TreeTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz == clazz2 ? -1 : this.editingRow;
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int visibleRow;

        public TreeTableCellRenderer(TreeModel model) {
            super(model);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w + 300, JTreeTable.this.getHeight());
        }

        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * this.getRowHeight());
            super.paint(g);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }
    }

    public class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return JTreeTable.this.tree;
        }

        public boolean isCellEditable(EventObject e) {
            return false;
        }
    }

    class Listener
    implements MouseListener,
    MouseMotionListener {
        static /* synthetic */ Class class$0;

        Listener() {
        }

        public void forwardToTree(MouseEvent me) {
            int counter = JTreeTable.this.getColumnCount() - 1;
            while (counter >= 0) {
                Class<?> clazz = JTreeTable.this.getColumnClass(counter);
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("edu.berkeley.guir.lib.swing.treetable.TreeTableModel");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2) {
                    MouseEvent newME = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX() - JTreeTable.this.getCellRect((int)0, (int)counter, (boolean)true).x, me.getY(), me.getClickCount(), me.isPopupTrigger());
                    JTreeTable.this.getTree().dispatchEvent(newME);
                    break;
                }
                --counter;
            }
        }

        public void mouseMoved(MouseEvent evt) {
            this.forwardToTree(evt);
        }

        public void mouseDragged(MouseEvent evt) {
            this.forwardToTree(evt);
        }

        public void mouseClicked(MouseEvent evt) {
            this.forwardToTree(evt);
        }

        public void mouseEntered(MouseEvent evt) {
            this.forwardToTree(evt);
        }

        public void mouseExited(MouseEvent evt) {
            this.forwardToTree(evt);
        }

        public void mousePressed(MouseEvent evt) {
            this.forwardToTree(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.forwardToTree(evt);
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void resetRowSelection() {
            if (this.updatingListSelectionModel) return;
            this.updatingListSelectionModel = true;
            try {
                super.resetRowSelection();
            }
            catch (Throwable throwable) {
                Object var1_2 = null;
                this.updatingListSelectionModel = false;
                throw throwable;
            }
            {
                Object var1_3 = null;
                this.updatingListSelectionModel = false;
                return;
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (this.updatingListSelectionModel) return;
            this.updatingListSelectionModel = true;
            try {
                int min = this.listSelectionModel.getMinSelectionIndex();
                int max = this.listSelectionModel.getMaxSelectionIndex();
                this.clearSelection();
                if (min != -1 && max != -1) {
                    int counter = min;
                    while (counter <= max) {
                        TreePath selPath;
                        if (this.listSelectionModel.isSelectedIndex(counter) && (selPath = JTreeTable.this.tree.getPathForRow(counter)) != null) {
                            this.addSelectionPath(selPath);
                        }
                        ++counter;
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.updatingListSelectionModel = false;
                throw throwable;
            }
            {
                Object var5_7 = null;
                this.updatingListSelectionModel = false;
                return;
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }
}

