/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing.treetable;

import edu.berkeley.guir.lib.swing.treetable.AbstractTreeTableModel;
import edu.berkeley.guir.lib.swing.treetable.MergeSort;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Stack;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class FileSystemModel2
extends AbstractTreeTableModel {
    protected static String[] cNames = new String[]{"Name", "Size", "Type", "Modified"};
    protected static Class[] cTypes;
    public static final Integer ZERO;
    static Stack sorters;
    protected boolean isValid = true;
    protected FileNode reloadNode;
    int reloadCount;
    protected boolean descendLinks;
    protected static FileNode[] EMPTY_CHILDREN;
    private static MergeSort fileMS;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class[] classArray = new Class[4];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.swing.treetable.TreeTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz4;
        cTypes = classArray;
        ZERO = new Integer(0);
        sorters = new Stack();
        EMPTY_CHILDREN = new FileNode[0];
        fileMS = new MergeSort(){

            public int compareElementsAt(int beginLoc, int endLoc) {
                return ((String)this.toSort[beginLoc]).compareTo((String)this.toSort[endLoc]);
            }
        };
    }

    protected static MergeSort getSizeSorter() {
        Stack stack = sorters;
        synchronized (stack) {
            if (sorters.size() == 0) {
                return new SizeSorter();
            }
            return (MergeSort)sorters.pop();
        }
    }

    protected static void recycleSorter(MergeSort sorter) {
        Stack stack = sorters;
        synchronized (stack) {
            sorters.push(sorter);
        }
    }

    public FileSystemModel2() {
        this(File.separator);
    }

    public FileSystemModel2(String rootPath) {
        super(null);
        this.root = new FileNode(new File(rootPath));
    }

    public int getChildCount(Object node) {
        Object[] children = this.getChildren(node);
        return children == null ? 0 : children.length;
    }

    public Object getChild(Object node, int i) {
        return this.getChildren(node)[i];
    }

    public boolean isLeaf(Object node) {
        return ((FileNode)node).isLeaf();
    }

    public int getColumnCount() {
        return cNames.length;
    }

    public String getColumnName(int column) {
        return cNames[column];
    }

    public Class getColumnClass(int column) {
        return cTypes[column];
    }

    public Object getValueAt(Object node, int column) {
        FileNode fn = (FileNode)node;
        try {
            switch (column) {
                case 0: {
                    return fn.getFile().getName();
                }
                case 1: {
                    if (fn.isTotalSizeValid()) {
                        return new Integer((int)((FileNode)node).totalSize());
                    }
                    return null;
                }
                case 2: {
                    return fn.isLeaf() ? "File" : "Directory";
                }
                case 3: {
                    return fn.lastModified();
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    public void reloadChildren(Object node) {
        FileNode fn = (FileNode)node;
        FileSystemModel2 fileSystemModel2 = this;
        synchronized (fileSystemModel2) {
            ++this.reloadCount;
        }
        fn.resetSize();
        new Thread(new FileNodeLoader((FileNode)node)).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stopLoading() {
        this.isValid = false;
        FileSystemModel2 fileSystemModel2 = this;
        synchronized (fileSystemModel2) {
            while (this.reloadCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.isValid = true;
    }

    public void setDescendsLinks(boolean newValue) {
        this.descendLinks = newValue;
    }

    public boolean getDescendsLinks() {
        return this.descendLinks;
    }

    public String getPath(Object node) {
        return ((FileNode)node).getFile().getPath();
    }

    public long getTotalSize(Object node) {
        return ((FileNode)node).totalSize();
    }

    public boolean isReloading() {
        return this.reloadCount > 0;
    }

    public TreePath getPathLoading() {
        FileNode rn = this.reloadNode;
        if (rn != null) {
            return new TreePath(rn.getPath());
        }
        return null;
    }

    public Object getNodeLoading() {
        return this.reloadNode;
    }

    protected File getFile(Object node) {
        FileNode fileNode = (FileNode)node;
        return fileNode.getFile();
    }

    protected Object[] getChildren(Object node) {
        FileNode fileNode = (FileNode)node;
        return fileNode.getChildren();
    }

    class FileNode {
        protected File file;
        private FileNode parent;
        protected FileNode[] children;
        protected long totalSize;
        protected boolean totalSizeValid;
        protected String canonicalPath;
        protected boolean isLink;
        protected Date lastModified;

        protected FileNode(File file) {
            this(null, file);
        }

        protected FileNode(FileNode parent, File file) {
            this.parent = parent;
            this.file = file;
            try {
                this.canonicalPath = file.getCanonicalPath();
            }
            catch (IOException ioe) {
                this.canonicalPath = "";
            }
            this.isLink = parent != null ? !this.canonicalPath.startsWith(parent.getCanonicalPath()) : false;
            if (this.isLeaf()) {
                this.totalSize = file.length();
                this.totalSizeValid = true;
            }
        }

        public Date lastModified() {
            if (this.lastModified == null && this.file != null) {
                this.lastModified = new Date(this.file.lastModified());
            }
            return this.lastModified;
        }

        public String toString() {
            return this.file.getName();
        }

        public File getFile() {
            return this.file;
        }

        public long totalSize() {
            return this.totalSize;
        }

        public FileNode getParent() {
            return this.parent;
        }

        public boolean isLeaf() {
            return this.file.isFile();
        }

        public boolean isTotalSizeValid() {
            return this.totalSizeValid;
        }

        protected void resetLastModified() {
            this.lastModified = null;
        }

        protected void resetSize() {
            this.alterTotalSize(-this.totalSize);
        }

        protected FileNode[] getChildren() {
            return this.children;
        }

        protected void loadChildren(MergeSort sorter) {
            this.totalSize = this.file.length();
            this.children = this.createChildren(null);
            int counter = this.children.length - 1;
            while (counter >= 0) {
                Thread.yield();
                if (!(this.children[counter].isLeaf() || !FileSystemModel2.this.descendLinks && this.children[counter].isLink())) {
                    this.children[counter].loadChildren(sorter);
                }
                this.totalSize += this.children[counter].totalSize();
                if (!FileSystemModel2.this.isValid) {
                    counter = 0;
                }
                --counter;
            }
            if (FileSystemModel2.this.isValid) {
                if (sorter != null) {
                    sorter.sort(this.children);
                }
                this.totalSizeValid = true;
            }
        }

        protected FileNode[] createChildren(MergeSort sorter) {
            FileNode[] retArray = null;
            try {
                Object[] files = this.file.list();
                if (files != null) {
                    if (sorter != null) {
                        sorter.sort(files);
                    }
                    retArray = new FileNode[files.length];
                    String path = this.file.getPath();
                    int i = 0;
                    while (i < files.length) {
                        File childFile = new File(path, (String)files[i]);
                        retArray[i] = new FileNode(this, childFile);
                        ++i;
                    }
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (retArray == null) {
                retArray = EMPTY_CHILDREN;
            }
            return retArray;
        }

        protected boolean loadedChildren() {
            return this.file.isFile() || this.children != null;
        }

        public FileNode[] getPath() {
            return this.getPathToRoot(this, 0);
        }

        public String getCanonicalPath() {
            return this.canonicalPath;
        }

        public boolean isLink() {
            return this.isLink;
        }

        protected FileNode[] getPathToRoot(FileNode aNode, int depth) {
            FileNode[] retNodes;
            if (aNode == null) {
                if (depth == 0) {
                    return null;
                }
                retNodes = new FileNode[depth];
            } else {
                retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
                retNodes[retNodes.length - depth] = aNode;
            }
            return retNodes;
        }

        protected void setChildren(FileNode[] newChildren, boolean generateEvent) {
            long oldSize = this.totalSize;
            this.totalSize = this.file.length();
            this.children = newChildren;
            int counter = this.children.length - 1;
            while (counter >= 0) {
                this.totalSize += this.children[counter].totalSize();
                --counter;
            }
            if (generateEvent) {
                Object[] path = this.getPath();
                FileSystemModel2.this.fireTreeStructureChanged(FileSystemModel2.this, path, null, null);
                FileNode parent = this.getParent();
                if (parent != null) {
                    parent.alterTotalSize(this.totalSize - oldSize);
                }
            }
        }

        protected synchronized void alterTotalSize(long sizeDelta) {
            if (sizeDelta != 0L && (this.parent = this.getParent()) != null) {
                this.totalSize += sizeDelta;
                this.nodeChanged();
                this.parent.alterTotalSize(sizeDelta);
            } else {
                this.totalSize += sizeDelta;
            }
        }

        protected synchronized void setTotalSizeValid(boolean newValue) {
            if (this.totalSizeValid != newValue) {
                this.nodeChanged();
                this.totalSizeValid = newValue;
                FileNode parent = this.getParent();
                if (parent != null) {
                    parent.childTotalSizeChanged(this);
                }
            }
        }

        protected synchronized void forceTotalSizeValid() {
            this.totalSizeValid = true;
        }

        protected synchronized void childTotalSizeChanged(FileNode child) {
            if (this.totalSizeValid != child.isTotalSizeValid()) {
                if (this.totalSizeValid) {
                    this.setTotalSizeValid(false);
                } else {
                    FileNode[] children = this.getChildren();
                    int counter = children.length - 1;
                    while (counter >= 0) {
                        if (!children[counter].isTotalSizeValid()) {
                            return;
                        }
                        --counter;
                    }
                    this.setTotalSizeValid(true);
                }
            }
        }

        protected void nodeChanged() {
            FileNode parent = this.getParent();
            if (parent != null) {
                Object[] path = parent.getPath();
                int[] index = new int[]{FileSystemModel2.this.getIndexOfChild(parent, this)};
                Object[] children = new Object[]{this};
                FileSystemModel2.this.fireTreeNodesChanged(FileSystemModel2.this, path, index, children);
            }
        }
    }

    class FileNodeLoader
    implements Runnable {
        FileNode node;
        MergeSort sizeMS;

        FileNodeLoader(FileNode node) {
            this.node = node;
            node.resetLastModified();
            node.setChildren(node.createChildren(fileMS), true);
            node.setTotalSizeValid(false);
        }

        public void run() {
            FileNode[] children = this.node.getChildren();
            this.sizeMS = FileSystemModel2.getSizeSorter();
            int counter = children.length - 1;
            while (counter >= 0) {
                if (!children[counter].isLeaf()) {
                    FileSystemModel2.this.reloadNode = children[counter];
                    this.loadChildren(children[counter]);
                    FileSystemModel2.this.reloadNode = null;
                }
                if (!FileSystemModel2.this.isValid) {
                    counter = 0;
                }
                --counter;
            }
            FileSystemModel2.recycleSorter(this.sizeMS);
            if (FileSystemModel2.this.isValid) {
                SwingUtilities.invokeLater(new Runnable(this){
                    final /* synthetic */ FileNodeLoader this$1;
                    {
                        this.this$1 = fileNodeLoader;
                    }

                    public void run() {
                        MergeSort sorter = FileSystemModel2.getSizeSorter();
                        sorter.sort(this.this$1.node.getChildren());
                        FileSystemModel2.recycleSorter(sorter);
                        this.this$1.node.setChildren(this.this$1.node.getChildren(), true);
                        FileSystemModel2 fileSystemModel2 = FileNodeLoader.access$0(this.this$1);
                        synchronized (fileSystemModel2) {
                            --FileNodeLoader.access$0((FileNodeLoader)this.this$1).reloadCount;
                            FileNodeLoader.access$0(this.this$1).notifyAll();
                        }
                    }
                });
            } else {
                FileSystemModel2 fileSystemModel2 = FileSystemModel2.this;
                synchronized (fileSystemModel2) {
                    --FileSystemModel2.this.reloadCount;
                    FileSystemModel2.this.notifyAll();
                }
            }
        }

        protected void loadChildren(FileNode node) {
            if (!(node.isLeaf() || !FileSystemModel2.this.descendLinks && node.isLink())) {
                FileNode[] children = node.createChildren(null);
                int counter = children.length - 1;
                while (counter >= 0) {
                    if (!children[counter].isLeaf()) {
                        if (FileSystemModel2.this.descendLinks || !children[counter].isLink()) {
                            children[counter].loadChildren(this.sizeMS);
                        } else {
                            children[counter].forceTotalSizeValid();
                        }
                    }
                    if (!FileSystemModel2.this.isValid) {
                        counter = 0;
                    }
                    --counter;
                }
                if (FileSystemModel2.this.isValid) {
                    FileNode fn = node;
                    SwingUtilities.invokeLater(new Runnable(this, children, fn){
                        final /* synthetic */ FileNodeLoader this$1;
                        private final /* synthetic */ FileNode[] val$children;
                        private final /* synthetic */ FileNode val$fn;
                        {
                            this.this$1 = fileNodeLoader;
                            this.val$children = fileNodeArray;
                            this.val$fn = fileNode;
                        }

                        public void run() {
                            MergeSort sorter = FileSystemModel2.getSizeSorter();
                            sorter.sort(this.val$children);
                            FileSystemModel2.recycleSorter(sorter);
                            this.val$fn.setChildren(this.val$children, true);
                            this.val$fn.setTotalSizeValid(true);
                            this.val$fn.nodeChanged();
                        }
                    });
                }
            } else {
                node.forceTotalSizeValid();
            }
        }

        static /* synthetic */ FileSystemModel2 access$0(FileNodeLoader fileNodeLoader) {
            return fileNodeLoader.FileSystemModel2.this;
        }
    }

    static class SizeSorter
    extends MergeSort {
        SizeSorter() {
        }

        public int compareElementsAt(int beginLoc, int endLoc) {
            long secondSize;
            long firstSize = ((FileNode)this.toSort[beginLoc]).totalSize();
            if (firstSize != (secondSize = ((FileNode)this.toSort[endLoc]).totalSize())) {
                return (int)(secondSize - firstSize);
            }
            return ((FileNode)this.toSort[beginLoc]).toString().compareTo(((FileNode)this.toSort[endLoc]).toString());
        }
    }
}

