/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing.tree;

import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class JTreeLib {
    public static void expandTree(JTree tree) {
        TreeModel model = tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)model.getRoot();
        Enumeration<TreeNode> en = root.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            if (!node.isLeaf()) continue;
            TreePath path = new TreePath(node.getPath());
            tree.makeVisible(path);
        }
    }

    public static DefaultMutableTreeNode getOrCreateNode(DefaultMutableTreeNode parent, String str) {
        DefaultMutableTreeNode child;
        Enumeration<TreeNode> en = parent.children();
        while (en.hasMoreElements()) {
            child = (DefaultMutableTreeNode)en.nextElement();
            if (!str.equals(child.getUserObject().toString())) continue;
            return child;
        }
        child = new DefaultMutableTreeNode(str);
        parent.add(child);
        return child;
    }

    public static void print(JTree tree) {
        TreeModel model = tree.getModel();
        Object root = model.getRoot();
        JTreeLib.printHelper(model, root, 0);
    }

    private static void printHelper(TreeModel model, Object obj, int depth) {
        int i = 0;
        while (i < depth) {
            System.out.print("   ");
            ++i;
        }
        System.out.println(obj);
        int size = model.getChildCount(obj);
        int i2 = 0;
        while (i2 < size) {
            JTreeLib.printHelper(model, model.getChild(obj, i2), depth + 1);
            ++i2;
        }
    }

    public static void print(DefaultMutableTreeNode root) {
        JTreeLib.printHelper(new DefaultTreeModel(root), root, 0);
    }

    public static void main(String[] argv) {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        JTree tree = new JTree(root);
        System.out.println(tree);
        System.out.println();
        System.out.println(JTreeLib.getOrCreateNode(root, "childA"));
        JTreeLib.print(tree);
        System.out.println();
        JTreeLib.getOrCreateNode(root, "childB");
        JTreeLib.print(tree);
        System.out.println();
        JTreeLib.getOrCreateNode(root, "childA");
        JTreeLib.print(tree);
        System.out.println();
        JTreeLib.print(root);
    }
}

