/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing.table;

import edu.berkeley.guir.lib.collection.Map2D;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class Map2DTableModel
extends AbstractTableModel {
    Map2D map;

    public Map2DTableModel(Map2D aMap) {
        this.map = aMap;
    }

    public String getColumnName(int col) {
        Object colHeader = this.map.getColHeader(col);
        if (colHeader == null) {
            return null;
        }
        return colHeader.toString();
    }

    public int getRowCount() {
        return this.map.numRows();
    }

    public int getColumnCount() {
        return this.map.numCols();
    }

    public Object getValueAt(int row, int col) {
        Object rowHeader = this.map.getRowHeader(row);
        Object colHeader = this.map.getColHeader(col);
        return this.map.get(rowHeader, colHeader);
    }

    private static Map2D getTestInstanceAAA() {
        Map2D map = new Map2D();
        map.put("row1", "col1", "value1");
        map.put("row2", "col2", "value2");
        map.put("row3", "col3", "value3");
        map.put("row1", "col2", "value4");
        return map;
    }

    private static Map2D getTestInstanceBBB() {
        Map2D map = new Map2D();
        map.put("row1", "col1", new Integer(1));
        map.put("row2", "col2", new Integer(2));
        map.put("row3", "col3", new Integer(3));
        map.put("row1", "col2", new Integer(4));
        return map;
    }

    private static void display(Map2DTableModel model) {
        JTable t = new JTable(model);
        JFrame f = new JFrame();
        f.getContentPane().add(new JScrollPane(t));
        f.pack();
        f.setVisible(true);
    }

    private static void runTestAAA() {
        Map2DTableModel.display(new Map2DTableModel(Map2DTableModel.getTestInstanceAAA()));
    }

    private static void runTestBBB() {
        Map2DTableModel.display(new Map2DTableModel(Map2DTableModel.getTestInstanceBBB()));
    }

    public static void main(String[] argv) throws Exception {
        Map2DTableModel.runTestBBB();
    }
}

