/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing.table;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class JTableLib {
    public static void sizeAllColumnsToFitData(JTable table) {
        JTableLib.sizeColumnsToFitData(0, table.getColumnCount(), table);
    }

    public static void sizeAllColumnsToFitData(JTable table, boolean flagAlsoCheckHeaders) {
        JTableLib.sizeColumnsToFitData(0, table.getColumnCount(), table, flagAlsoCheckHeaders);
    }

    public static void sizeColumnsToFitData(int startCol, int endCol, JTable table) {
        JTableLib.sizeColumnsToFitData(startCol, endCol, table, false);
    }

    public static void sizeColumnsToFitData(int startCol, int endCol, JTable table, boolean flagAlsoCheckHeaders) {
        int col = startCol;
        while (col < endCol) {
            TableColumn curColumn = table.getColumn(table.getColumnName(col));
            if (curColumn != null) {
                int modelColumn = curColumn.getModelIndex();
                int maxColWidth = 0;
                int numRows = table.getRowCount();
                int start = 0;
                if (flagAlsoCheckHeaders) {
                    start = -1;
                }
                int row = start;
                while (row < numRows) {
                    TableCellRenderer curRend = table.getCellRenderer(row, modelColumn);
                    Object value = row < 0 ? table.getColumnName(col) : table.getValueAt(row, modelColumn);
                    Component curComp = curRend.getTableCellRendererComponent(table, value, true, true, row, modelColumn);
                    Dimension cellDim = curComp.getPreferredSize();
                    if (cellDim.width > maxColWidth) {
                        maxColWidth = cellDim.width;
                    }
                    ++row;
                }
                Dimension cellSpacing = table.getIntercellSpacing();
                curColumn.setPreferredWidth(maxColWidth + (cellSpacing != null ? cellSpacing.width : 1));
            }
            ++col;
        }
    }

    public static void sizeAllColumnsToFitHeaders(JTable table) {
        JTableLib.sizeColumnsToFitHeaders(0, table.getColumnCount(), table);
    }

    public static void sizeColumnsToFitHeaders(int startCol, int endCol, JTable table) {
        int col = startCol;
        while (col < endCol) {
            TableColumn curColumn = table.getColumn(table.getColumnName(col));
            if (curColumn != null) {
                int modelColumn = curColumn.getModelIndex();
                String value = table.getColumnName(col);
                int row = -1;
                TableCellRenderer curRend = table.getCellRenderer(row, modelColumn);
                Component curComp = curRend.getTableCellRendererComponent(table, value, true, true, row, modelColumn);
                Dimension cellDim = curComp.getPreferredSize();
                Dimension cellSpacing = table.getIntercellSpacing();
                curColumn.setPreferredWidth((int)cellDim.getWidth() + (cellSpacing != null ? cellSpacing.width : 1));
            }
            ++col;
        }
    }
}

