/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing.list;

import edu.berkeley.guir.lib.swing.list.ListLib;
import edu.berkeley.guir.lib.swing.list.Row;
import edu.berkeley.guir.lib.swing.list.SeparatorRow;
import edu.berkeley.guir.lib.swing.list.SimpleRow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class TableListCellRenderer
extends DefaultListCellRenderer {
    JList list;
    ListDataListener lstnr = new InternalListDataListener();
    Row[] table;
    int[] widths;

    protected static Row[] createTable(ListModel model) {
        Row[] table = new Row[model.getSize()];
        int i = 0;
        while (i < model.getSize()) {
            table[i] = (Row)model.getElementAt(i);
            ++i;
        }
        return table;
    }

    protected void updateTable() {
        if (this.list.getModel().getSize() > 0) {
            try {
                this.table = TableListCellRenderer.createTable(this.list.getModel());
                this.widths = ListLib.calcWidths(this.table);
            }
            catch (Exception e) {
                this.table = null;
                this.widths = null;
            }
        } else {
            this.table = null;
            this.widths = null;
        }
    }

    protected void updateJList(JList aList) {
        if (aList != this.list) {
            if (this.list != null) {
                this.list.getModel().removeListDataListener(this.lstnr);
            }
            this.list = aList;
            this.list.getModel().addListDataListener(this.lstnr);
            this.updateTable();
        }
    }

    protected JPanel createRow(JList list, int rowIndex) {
        this.updateJList(list);
        ListModel model = list.getModel();
        JPanel p = new JPanel(new FlowLayout(0, 3, 0));
        Row row = (Row)model.getElementAt(rowIndex);
        int i = 0;
        while (i < row.numCols()) {
            JLabel lbl = new JLabel(row.get(i).toString());
            lbl.setFont(list.getFont());
            p.add(lbl);
            if (!row.isIgnoredForWidthCalculations()) {
                Dimension dim = lbl.getPreferredSize();
                dim.setSize((double)(this.widths[i] + 3), dim.getHeight());
                lbl.setMinimumSize(dim);
                lbl.setPreferredSize(dim);
            }
            ++i;
        }
        p.invalidate();
        return p;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        ListModel model = list.getModel();
        Object obj = model.getElementAt(index);
        if (obj instanceof SeparatorRow) {
            return SeparatorRow.JSEPARATOR;
        }
        if (obj instanceof Row) {
            JPanel comp = this.createRow(list, index);
            if (isSelected) {
                comp.setForeground(list.getSelectionForeground());
                comp.setBackground(list.getSelectionBackground());
            } else {
                comp.setForeground(list.getForeground());
                comp.setBackground(list.getBackground());
            }
            return comp;
        }
        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
    }

    private static Row[] getTestTableInstanceAAA() {
        return new Row[]{new SimpleRow("valIIAAA", (Object)"\u2013", (Object)"valI", (Object)"va123478lIIII"), new SimpleRow("valAAAAA", (Object)"\u2013", (Object)"valAAA", (Object)"val123478AAAA"), new SimpleRow("valBBAAA", (Object)"\u2013", (Object)"valBBB", (Object)"val123478BBBB"), new SimpleRow("valCCAAA", (Object)"\u2014", (Object)"valCCC", (Object)"val123478CCCC"), new SimpleRow("valDDAAA", (Object)"\u2014", (Object)"valGGG", (Object)"val123478JJJJ"), SeparatorRow.SEPARATOR, new SimpleRow("valEEAAA", (Object)"\u2014", (Object)"55valHHH", (Object)"val123478KKKK")};
    }

    private static void runTestCCC() {
        JFrame f = new JFrame();
        JComboBox<Row> comboBox = new JComboBox<Row>(TableListCellRenderer.getTestTableInstanceAAA());
        comboBox.setRenderer(new TableListCellRenderer());
        f.getContentPane().setLayout(new FlowLayout());
        f.getContentPane().add(comboBox);
        f.pack();
        f.setVisible(true);
    }

    public static void main(String[] argv) throws Exception {
        TableListCellRenderer.runTestCCC();
    }

    class InternalListDataListener
    implements ListDataListener {
        InternalListDataListener() {
        }

        public void contentsChanged(ListDataEvent evt) {
            TableListCellRenderer.this.updateTable();
        }

        public void intervalAdded(ListDataEvent evt) {
            TableListCellRenderer.this.updateTable();
        }

        public void intervalRemoved(ListDataEvent evt) {
            TableListCellRenderer.this.updateTable();
        }
    }
}

