/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing.list;

import edu.berkeley.guir.lib.swing.list.ListLib;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ArrayListCellRenderer
extends DefaultListCellRenderer {
    JList list;
    ListDataListener lstnr = new InternalListDataListener();
    String[][] table;
    int[] widths;

    protected static String[][] createTable(ListModel model) {
        String[][] table = new String[model.getSize()][];
        int i = 0;
        while (i < model.getSize()) {
            table[i] = (String[])model.getElementAt(i);
            ++i;
        }
        return table;
    }

    protected void updateTable() {
        if (this.list.getModel().getSize() > 0) {
            try {
                this.table = ArrayListCellRenderer.createTable(this.list.getModel());
                this.widths = ListLib.calcWidths(this.table);
            }
            catch (Exception e) {
                this.table = null;
                this.widths = null;
            }
        } else {
            this.table = null;
            this.widths = null;
        }
    }

    protected void updateJList(JList aList) {
        if (aList != this.list) {
            if (this.list != null) {
                this.list.getModel().removeListDataListener(this.lstnr);
            }
            this.list = aList;
            this.list.getModel().addListDataListener(this.lstnr);
            this.updateTable();
        }
    }

    protected JPanel createRow(JList list, int row) {
        this.updateJList(list);
        ListModel model = list.getModel();
        JPanel p = new JPanel(new FlowLayout(0, 3, 0));
        String[] arr = (String[])model.getElementAt(row);
        int i = 0;
        while (i < arr.length) {
            JLabel lbl = new JLabel(arr[i]);
            lbl.setFont(list.getFont());
            p.add(lbl);
            Dimension dim = lbl.getPreferredSize();
            dim.setSize((double)(this.widths[i] + 3), dim.getHeight());
            lbl.setMinimumSize(dim);
            lbl.setPreferredSize(dim);
            ++i;
        }
        p.invalidate();
        return p;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        ListModel model = list.getModel();
        Object obj = model.getElementAt(index);
        if (obj instanceof String[]) {
            JPanel comp = this.createRow(list, index);
            if (isSelected) {
                comp.setForeground(list.getSelectionForeground());
                comp.setBackground(list.getSelectionBackground());
            } else {
                comp.setForeground(list.getForeground());
                comp.setBackground(list.getBackground());
            }
            return comp;
        }
        return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
    }

    private static JList getTestJListInstanceAAA() {
        return new JList<String>(new String[]{"valAA", "valBB", "valCC", "valDD"});
    }

    private static JList getTestJListInstanceBBB() {
        return new JList((E[])ArrayListCellRenderer.getTestTableInstanceAAA());
    }

    private static String[][] getTestTableInstanceAAA() {
        return new String[][]{{"valIIAAA", "\u2013", "valI", "va123478lIIII"}, {"valAAAAA", "\u2013", "valAAA", "val123478AAAA"}, {"valBBAAA", "\u2013", "valBBB", "val123478BBBB"}, {"valCCAAA", "\u2014", "valCCC", "val123478CCCC"}, {"valDDAAA", "\u2014", "valGGG", "val123478JJJJ"}, {"valEEAAA", "\u2014", "55valHHH", "val123478KKKK"}};
    }

    private static void runTestAAA() {
        JFrame f = new JFrame();
        JList list = ArrayListCellRenderer.getTestJListInstanceBBB();
        list.setCellRenderer(new ArrayListCellRenderer());
        f.getContentPane().add(list);
        f.pack();
        f.setVisible(true);
    }

    private static void runTestBBB() {
        JList list = ArrayListCellRenderer.getTestJListInstanceBBB();
        ListModel model = list.getModel();
        String[][] table = ArrayListCellRenderer.createTable(model);
        ListLib.debugln(table);
        ListLib.debugln(ListLib.calcWidths(table));
    }

    private static void runTestCCC() {
        JFrame f = new JFrame();
        JComboBox<Object> comboBox = new JComboBox<Object>((E[])ArrayListCellRenderer.getTestTableInstanceAAA());
        comboBox.setRenderer(new ArrayListCellRenderer());
        f.getContentPane().setLayout(new FlowLayout());
        f.getContentPane().add(comboBox);
        f.pack();
        f.setVisible(true);
    }

    public static void main(String[] argv) throws Exception {
        ArrayListCellRenderer.runTestCCC();
    }

    class InternalListDataListener
    implements ListDataListener {
        InternalListDataListener() {
        }

        public void contentsChanged(ListDataEvent evt) {
            ArrayListCellRenderer.this.updateTable();
        }

        public void intervalAdded(ListDataEvent evt) {
            ArrayListCellRenderer.this.updateTable();
        }

        public void intervalRemoved(ListDataEvent evt) {
            ArrayListCellRenderer.this.updateTable();
        }
    }
}

