/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing.layout;

import java.awt.Component;
import java.awt.Container;
import javax.swing.Spring;
import javax.swing.SpringLayout;

public class SpringLib {
    private SpringLib() {
    }

    public static void printSizes(Component c) {
        System.out.println("minimumSize   = " + c.getMinimumSize());
        System.out.println("preferredSize = " + c.getPreferredSize());
        System.out.println("maximumSize   = " + c.getMaximumSize());
    }

    private static SpringLayout getSpringLayout(Container parent) {
        try {
            SpringLayout layout = (SpringLayout)parent.getLayout();
            return layout;
        }
        catch (ClassCastException exc) {
            throw new IllegalArgumentException("Must use SpringLayout");
        }
    }

    public static void makeGrid(Container parent, int rows, int cols, int padding) {
        SpringLib.makeGrid(parent, rows, cols, padding, padding, padding, padding);
    }

    public static void makeGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout.Constraints cons;
        SpringLayout layout = SpringLib.getSpringLayout(parent);
        Spring xPadSpring = Spring.constant(xPad);
        Spring yPadSpring = Spring.constant(yPad);
        Spring initialXSpring = Spring.constant(initialX);
        Spring initialYSpring = Spring.constant(initialY);
        int max = rows * cols;
        Spring maxWidthSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        Spring maxHeightSpring = layout.getConstraints(parent.getComponent(0)).getWidth();
        int i = 1;
        while (i < max) {
            cons = layout.getConstraints(parent.getComponent(i));
            maxWidthSpring = Spring.max(maxWidthSpring, cons.getWidth());
            maxHeightSpring = Spring.max(maxHeightSpring, cons.getHeight());
            ++i;
        }
        i = 0;
        while (i < max) {
            cons = layout.getConstraints(parent.getComponent(i));
            cons.setWidth(maxWidthSpring);
            cons.setHeight(maxHeightSpring);
            ++i;
        }
        SpringLayout.Constraints lastCons = null;
        SpringLayout.Constraints lastRowCons = null;
        int i2 = 0;
        while (i2 < max) {
            SpringLayout.Constraints cons2 = layout.getConstraints(parent.getComponent(i2));
            if (i2 % cols == 0) {
                lastRowCons = lastCons;
                cons2.setX(initialXSpring);
            } else {
                cons2.setX(Spring.sum(lastCons.getConstraint("East"), xPadSpring));
            }
            if (i2 / cols == 0) {
                cons2.setY(initialYSpring);
            } else {
                cons2.setY(Spring.sum(lastRowCons.getConstraint("South"), yPadSpring));
            }
            lastCons = cons2;
            ++i2;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", Spring.sum(Spring.constant(yPad), lastCons.getConstraint("South")));
        pCons.setConstraint("East", Spring.sum(Spring.constant(xPad), lastCons.getConstraint("East")));
    }

    private static SpringLayout.Constraints getConstraintsForCell(int row, int col, Container parent, int cols) {
        SpringLayout layout = (SpringLayout)parent.getLayout();
        Component c = parent.getComponent(row * cols + col);
        return layout.getConstraints(c);
    }

    public static void makeCompactGrid(Container parent, int rows, int cols, int padding) {
        SpringLib.makeCompactGrid(parent, rows, cols, padding, padding, padding, padding);
    }

    public static void makeCompactGrid(Container parent, int rows, int cols, int initialX, int initialY, int xPad, int yPad) {
        SpringLayout layout = SpringLib.getSpringLayout(parent);
        Spring x = Spring.constant(initialX);
        int c = 0;
        while (c < cols) {
            Spring width = Spring.constant(0);
            int r = 0;
            while (r < rows) {
                width = Spring.max(width, SpringLib.getConstraintsForCell(r, c, parent, cols).getWidth());
                ++r;
            }
            r = 0;
            while (r < rows) {
                SpringLayout.Constraints constraints = SpringLib.getConstraintsForCell(r, c, parent, cols);
                constraints.setX(x);
                constraints.setWidth(width);
                ++r;
            }
            x = Spring.sum(x, Spring.sum(width, Spring.constant(xPad)));
            ++c;
        }
        Spring y = Spring.constant(initialY);
        int r = 0;
        while (r < rows) {
            Spring height = Spring.constant(0);
            int c2 = 0;
            while (c2 < cols) {
                height = Spring.max(height, SpringLib.getConstraintsForCell(r, c2, parent, cols).getHeight());
                ++c2;
            }
            c2 = 0;
            while (c2 < cols) {
                SpringLayout.Constraints constraints = SpringLib.getConstraintsForCell(r, c2, parent, cols);
                constraints.setY(y);
                constraints.setHeight(height);
                ++c2;
            }
            y = Spring.sum(y, Spring.sum(height, Spring.constant(yPad)));
            ++r;
        }
        SpringLayout.Constraints pCons = layout.getConstraints(parent);
        pCons.setConstraint("South", y);
        pCons.setConstraint("East", x);
    }
}

