/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing.layout;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class LayoutLib {
    static JPanel p = new JPanel();

    private LayoutLib() {
    }

    public static synchronized Dimension getPreferredSize(Component comp) {
        p.removeAll();
        p.add(comp);
        Dimension dim = comp.getPreferredSize();
        p.removeAll();
        return dim;
    }

    public Dimension getMaxSize(Component[] comps) {
        Dimension dim = comps[0].getPreferredSize();
        int i = 1;
        while (i < comps.length) {
            Dimension dimTmp = comps[i].getPreferredSize();
            dim.setSize(Math.max(dim.getWidth(), dimTmp.getWidth()), Math.max(dim.getHeight(), dimTmp.getHeight()));
            ++i;
        }
        return dim;
    }

    public static void fakeResizeEvent(Component aComp) {
        Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new ComponentEvent(aComp, 101));
    }

    public static void fakeResizeEventOnRoot(Component aComp) {
        Component root = SwingUtilities.getRoot(aComp);
        LayoutLib.fakeResizeEvent(root);
    }

    public static void revalidateAll(Component aComponent) {
        Component c = SwingUtilities.getRoot(aComponent);
        if (c instanceof Window) {
            Window wnd = (Window)c;
            wnd.invalidate();
            aComponent.invalidate();
            wnd.validate();
        }
    }

    public static void packContainingWindow(Component aComponent) {
        Component c = SwingUtilities.getRoot(aComponent);
        if (c instanceof Window) {
            ((Window)c).pack();
        }
    }

    public static void packContainingWindow(Component aComponent, boolean flagAllowGrowWidth, boolean flagAllowShrinkWidth, boolean flagAllowGrowHeight, boolean flagAllowShrinkHeight) {
        Component c = SwingUtilities.getRoot(aComponent);
        if (c instanceof Window) {
            Window wnd = (Window)c;
            Dimension dimOld = null;
            Dimension dimNew = null;
            if (flagAllowGrowWidth || flagAllowShrinkWidth || flagAllowGrowHeight || flagAllowShrinkHeight) {
                dimOld = wnd.getSize();
            }
            aComponent.invalidate();
            wnd.invalidate();
            wnd.validate();
            wnd.pack();
            if (flagAllowGrowWidth || flagAllowShrinkWidth || flagAllowGrowHeight || flagAllowShrinkHeight) {
                dimNew = wnd.getSize();
                double width = dimNew.getWidth();
                double height = dimNew.getHeight();
                width = dimOld.getWidth() < dimNew.getWidth() ? (flagAllowGrowWidth ? dimNew.getWidth() : dimOld.getWidth()) : (flagAllowShrinkWidth ? dimNew.getWidth() : dimOld.getWidth());
                height = dimOld.getHeight() < dimNew.getHeight() ? (flagAllowGrowHeight ? dimNew.getHeight() : dimOld.getHeight()) : (flagAllowShrinkHeight ? dimNew.getHeight() : dimOld.getHeight());
                dimNew.setSize(width, height);
                wnd.setSize(dimNew);
                wnd.invalidate();
                wnd.validate();
                if (wnd instanceof JFrame) {
                    JFrame f = (JFrame)wnd;
                    f.getContentPane().invalidate();
                    if (f.getContentPane() instanceof JComponent) {
                        JComponent jcomp = (JComponent)f.getContentPane();
                        jcomp.setPreferredSize(jcomp.getPreferredSize());
                        f.pack();
                    } else {
                        f.getContentPane().validate();
                    }
                } else {
                    wnd.invalidate();
                    wnd.validate();
                }
                wnd.setSize(dimNew);
            }
        }
    }

    private static void runTestAAA() {
        System.out.println(LayoutLib.getPreferredSize(new JLabel("blah")));
        System.out.println(LayoutLib.getPreferredSize(new JLabel("blahblahj")));
    }

    public static void main(String[] argv) throws Exception {
        LayoutLib.runTestAAA();
    }
}

