/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;

public class LogScaleSlider
extends JSlider {
    public LogScaleSlider(int min, int max, int value, double steps) {
        super(min, max);
        if (value < min) {
            System.err.println("Given value: " + value + " is below the min value: " + min);
            value = min;
        } else if (value > max) {
            System.err.println("Given value: " + value + " is above the max value: " + max);
            value = max;
        }
        super.setValue(this.logToLinear(value));
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        ((Dictionary)labels).put(new Integer(min), new JLabel(String.valueOf(min)));
        ((Dictionary)labels).put(new Integer(max), new JLabel(String.valueOf(max)));
        double logMin = Math.log(min);
        double logMax = Math.log(max);
        double logDiff = logMax - logMin;
        int i = 0;
        while ((double)i < steps) {
            double fraction = ((double)i + 1.0) / (steps + 1.0);
            int step = (int)Math.exp(fraction * logDiff + logMin);
            ((Dictionary)labels).put(new Integer((int)(fraction * (double)(max - min))), new JLabel(String.valueOf(step)));
            ++i;
        }
        this.setLabelTable(labels);
        this.setPaintLabels(true);
        this.setEnabled(true);
    }

    public int getLogValue() {
        return this.linearToLog(this.getValue());
    }

    private int logToLinear(int value) {
        int min = this.getMinimum();
        int max = this.getMaximum();
        double logMax = Math.log(max);
        double logMin = Math.log(min);
        double logDiff = logMax - logMin;
        double fraction = (Math.log(value) - logMin) / logDiff;
        return (int)((double)min + fraction * (double)(max - min));
    }

    private int linearToLog(int value) {
        int min = this.getMinimum();
        int max = this.getMaximum();
        double fraction = (double)this.getValue() / (double)(max - min);
        double logMax = Math.log(max);
        double logMin = Math.log(min);
        double logDiff = logMax - logMin;
        return (int)Math.exp(fraction * logDiff + logMin);
    }
}

