/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing;

import edu.berkeley.guir.lib.swing.JWizardListener;
import edu.berkeley.guir.lib.swing.JWizardPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class JWizard
extends JFrame {
    CardLayout layout;
    Map mapPanelAction = new HashMap();
    List listListeners = new LinkedList();
    boolean flagFirstPanel = true;

    public JWizard() {
        this.commonInit();
    }

    public JWizard(String strTitle) {
        super(strTitle);
        this.commonInit();
    }

    private void commonInit() {
        this.setSize(400, 200);
        this.layout = new CardLayout();
        this.getContentPane().setLayout(this.layout);
    }

    public void addPanel(JWizardPanel pwiz) {
        JPanel p = new JPanel();
        p.setLayout(new BorderLayout());
        p.add((Component)pwiz, "Center");
        p.add((Component)new JLabel("   "), "North");
        p.add((Component)new JLabel("   "), "West");
        WizardActionPanel pAction = new WizardActionPanel(pwiz);
        this.mapPanelAction.put(pwiz, pAction);
        pwiz.setWizard(this);
        pAction.getBackButton().addActionListener(new BackActionListener(pwiz));
        pAction.getNextButton().addActionListener(new NextActionListener(pwiz));
        pAction.getCancelButton().addActionListener(new CancelActionListener());
        p.add((Component)pAction, "South");
        this.getContentPane().add((Component)p, pwiz.getStateName());
        if (this.flagFirstPanel) {
            this.flagFirstPanel = false;
            pwiz.setBackEnabled(false);
        }
    }

    public void onUpdate(JWizardPanel pwiz) {
        WizardActionPanel pAction = (WizardActionPanel)this.mapPanelAction.get(pwiz);
        pAction.getBackButton().setEnabled(pwiz.isBackEnabled());
        pAction.getNextButton().setEnabled(pwiz.isNextEnabled());
    }

    public void addListener(JWizardListener lstnr) {
        this.listListeners.add(lstnr);
    }

    public void removeListener(JWizardListener lstnr) {
        this.listListeners.remove(lstnr);
    }

    public void clearListeners() {
        this.listListeners.clear();
    }

    protected void fireOnFinish() {
        Iterator it = this.listListeners.iterator();
        while (it.hasNext()) {
            JWizardListener l = (JWizardListener)it.next();
            l.onFinish();
        }
    }

    protected void fireOnCancel() {
        Iterator it = this.listListeners.iterator();
        while (it.hasNext()) {
            JWizardListener l = (JWizardListener)it.next();
            l.onCancel();
        }
    }

    public static void main(String[] argv) {
        JWizard wiz = new JWizard();
        wiz.addPanel(new MainPanel());
        wiz.addPanel(new OptionAPanel());
        wiz.addPanel(new OptionBPanel());
        wiz.addListener(new Listener());
        wiz.setVisible(true);
    }

    class NextActionListener
    implements ActionListener {
        JWizardPanel p;

        public NextActionListener(JWizardPanel newp) {
            this.p = newp;
        }

        public void actionPerformed(ActionEvent evt) {
            if ("Finished".equalsIgnoreCase(this.p.getNextState())) {
                JWizard.this.dispose();
                JWizard.this.fireOnFinish();
            } else {
                JWizard.this.layout.show(JWizard.this.getContentPane(), this.p.getNextState());
            }
        }
    }

    class BackActionListener
    implements ActionListener {
        JWizardPanel p;

        public BackActionListener(JWizardPanel newp) {
            this.p = newp;
        }

        public void actionPerformed(ActionEvent evt) {
            JWizard.this.layout.show(JWizard.this.getContentPane(), this.p.getBackState());
        }
    }

    class CancelActionListener
    implements ActionListener {
        CancelActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            JWizard.this.dispose();
            JWizard.this.fireOnCancel();
        }
    }

    class WizardActionPanel
    extends JPanel {
        JWizardPanel wiz;
        JButton buttonBack;
        JButton buttonNext;
        JButton buttonCancel;

        public WizardActionPanel(JWizardPanel newWiz) {
            this.setLayout(new FlowLayout(2));
            this.wiz = newWiz;
            this.buttonBack = new JButton("< Back");
            if (!newWiz.isBackEnabled()) {
                this.buttonBack.setEnabled(false);
            }
            this.buttonNext = "Finished".equalsIgnoreCase(newWiz.getNextState()) ? new JButton("Finished") : new JButton("Next >");
            if (!newWiz.isNextEnabled()) {
                this.buttonNext.setEnabled(false);
            }
            this.buttonCancel = new JButton("Cancel");
            this.add(new JLabel("                  "));
            this.add(this.buttonBack);
            this.add(this.buttonNext);
            this.add(new JLabel("   "));
            this.add(this.buttonCancel);
        }

        public JButton getBackButton() {
            return this.buttonBack;
        }

        public JButton getNextButton() {
            return this.buttonNext;
        }

        public JButton getCancelButton() {
            return this.buttonCancel;
        }
    }

    static class MainPanel
    extends JWizardPanel {
        JRadioButton optionA;
        JRadioButton optionB;

        public MainPanel() {
            super("Main");
            this.setLayout(new BoxLayout(this, 1));
            ButtonGroup grp = new ButtonGroup();
            this.optionA = new JRadioButton("A");
            this.optionB = new JRadioButton("B");
            this.optionA.addItemListener(new MyItemListener());
            this.optionB.addItemListener(new MyItemListener());
            grp.add(this.optionA);
            grp.add(this.optionB);
            this.add(new JLabel("Choose an option:"));
            this.add(this.optionA);
            this.add(this.optionB);
            this.setNextEnabled(false);
        }

        public String getNextState() {
            if (this.optionA.isSelected()) {
                return "A";
            }
            if (this.optionB.isSelected()) {
                return "B";
            }
            return null;
        }

        class MyItemListener
        implements ItemListener {
            MyItemListener() {
            }

            public void itemStateChanged(ItemEvent evt) {
                MainPanel.this.setNextEnabled(true);
            }
        }
    }

    static class OptionAPanel
    extends JWizardPanel {
        public OptionAPanel() {
            super("A");
            this.add(new JLabel("OptionA panel"));
        }

        public String getNextState() {
            return "Finished";
        }

        public String getBackState() {
            return "Main";
        }
    }

    static class OptionBPanel
    extends JWizardPanel {
        public OptionBPanel() {
            super("B");
            this.add(new JLabel("OptionB panel"));
        }

        public String getNextState() {
            return "Finished";
        }

        public String getBackState() {
            return "Main";
        }
    }

    public static class Listener
    implements JWizardListener {
        public void onFinish() {
            System.out.println("Wizard finished");
        }

        public void onCancel() {
            System.out.println("Wizard cancelled");
        }
    }
}

