/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class FancySliderUI
extends BasicSliderUI {
    protected final int TICK_BUFFER = 4;
    protected boolean filledSlider = false;
    protected static Color thumbColor;
    protected static Color highlightColor;
    protected static Color darkShadowColor;
    protected static int trackWidth;
    protected static int tickLength;
    protected static Icon horizThumbIcon;
    protected static Icon vertThumbIcon;
    protected final String SLIDER_FILL = "JSlider.isFilled";

    public static ComponentUI createUI(JComponent c) {
        return new FancySliderUI();
    }

    public FancySliderUI() {
        super(null);
    }

    public void installUI(JComponent c) {
        trackWidth = 15;
        tickLength = (Integer)UIManager.get("Slider.majorTickLength");
        horizThumbIcon = new HorizontalSliderThumbIcon();
        vertThumbIcon = UIManager.getIcon("Slider.verticalThumbIcon");
        super.installUI(c);
        thumbColor = UIManager.getColor("Slider.thumb");
        highlightColor = UIManager.getColor("Slider.highlight");
        darkShadowColor = UIManager.getColor("Slider.darkShadow");
        this.scrollListener.setScrollByBlock(false);
        Object sliderFillProp = c.getClientProperty("JSlider.isFilled");
        if (sliderFillProp != null) {
            this.filledSlider = (Boolean)sliderFillProp;
        }
    }

    public void paintThumb(Graphics g) {
        Rectangle knobBounds = this.thumbRect;
        g.translate(knobBounds.x, knobBounds.y);
        if (this.slider.getOrientation() == 0) {
            horizThumbIcon.paintIcon(this.slider, g, 0, 0);
        } else {
            vertThumbIcon.paintIcon(this.slider, g, 0, 0);
        }
        g.translate(-knobBounds.x, -knobBounds.y);
    }

    public void paintTrack(Graphics g) {
        ColorUIResource trackColor = !this.slider.isEnabled() ? MetalLookAndFeel.getControlShadow() : this.slider.getForeground();
        boolean leftToRight = FancySliderUI.isLeftToRight(this.slider);
        g.translate(this.trackRect.x, this.trackRect.y);
        int trackLeft = 0;
        int trackTop = 0;
        int trackRight = 0;
        int trackBottom = 0;
        if (this.filledSlider) {
            int middleOfThumb = 0;
            int fillTop = 0;
            int fillLeft = 0;
            int fillBottom = 0;
            int fillRight = 0;
            if (this.slider.getOrientation() == 0) {
                middleOfThumb = this.thumbRect.x + this.thumbRect.width / 2;
                middleOfThumb -= this.trackRect.x;
                fillTop = !this.slider.isEnabled() ? trackTop : trackTop + 1;
                int n = fillBottom = !this.slider.isEnabled() ? trackBottom - 1 : trackBottom - 2;
                if (!this.drawInverted()) {
                    fillLeft = !this.slider.isEnabled() ? trackLeft : trackLeft + 1;
                    fillRight = middleOfThumb;
                } else {
                    fillLeft = middleOfThumb;
                    fillRight = !this.slider.isEnabled() ? trackRight - 1 : trackRight - 2;
                }
            } else {
                middleOfThumb = this.thumbRect.y + this.thumbRect.height / 2;
                middleOfThumb -= this.trackRect.y;
                fillLeft = !this.slider.isEnabled() ? trackLeft : trackLeft + 1;
                int n = fillRight = !this.slider.isEnabled() ? trackRight - 1 : trackRight - 2;
                if (!this.drawInverted()) {
                    fillTop = middleOfThumb;
                    fillBottom = !this.slider.isEnabled() ? trackBottom - 1 : trackBottom - 2;
                } else {
                    fillTop = !this.slider.isEnabled() ? trackTop : trackTop + 1;
                    fillBottom = middleOfThumb;
                }
            }
            if (this.slider.isEnabled()) {
                g.setColor(this.slider.getBackground());
                g.drawLine(fillLeft, fillTop, fillRight, fillTop);
                g.drawLine(fillLeft, fillTop, fillLeft, fillBottom);
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.fillRect(fillLeft + 1, fillTop + 1, fillRight - fillLeft, fillBottom - fillTop);
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
                g.fillRect(fillLeft, fillTop, fillRight - fillLeft, trackBottom - trackTop);
            }
        }
        g.translate(-this.trackRect.x, -this.trackRect.y);
    }

    public int getTickLength() {
        return this.slider.getOrientation() == 0 ? tickLength + 4 + 1 : tickLength + 4 + 3;
    }

    protected int getTrackWidth() {
        return 20;
    }

    protected int getTrackLength() {
        if (this.slider.getOrientation() == 0) {
            return this.trackRect.width;
        }
        return this.trackRect.height;
    }

    protected int getThumbOverhang() {
        return 7;
    }

    static boolean isLeftToRight(Component c) {
        return c.getComponentOrientation().isLeftToRight();
    }

    public void paintLabels(Graphics g) {
        g.translate(0, -20);
        super.paintLabels(g);
        g.translate(0, 20);
    }

    private static class HorizontalSliderThumbIcon
    implements Icon,
    Serializable,
    UIResource {
        public void paintIcon(Component c, Graphics g, int x, int y) {
            JSlider slider = (JSlider)c;
            g.translate(x, y);
            if (slider.hasFocus()) {
                g.setColor(MetalLookAndFeel.getPrimaryControlInfo());
            } else {
                g.setColor(slider.isEnabled() ? MetalLookAndFeel.getPrimaryControlInfo() : MetalLookAndFeel.getControlDarkShadow());
            }
            g.drawLine(1, 0, 13, 0);
            g.drawLine(0, 1, 0, 8);
            g.drawLine(14, 1, 14, 8);
            g.drawLine(1, 9, 7, 15);
            g.drawLine(7, 15, 14, 8);
            if (slider.hasFocus()) {
                g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.5f));
            } else {
                g.setColor(new Color(0.0f, 0.0f, 1.0f, 0.5f));
            }
            g.fillRect(1, 1, 13, 8);
            g.drawLine(2, 9, 12, 9);
            g.drawLine(3, 10, 11, 10);
            g.drawLine(4, 11, 10, 11);
            g.drawLine(5, 12, 9, 12);
            g.drawLine(6, 13, 8, 13);
            g.drawLine(7, 14, 7, 14);
            if (slider.isEnabled()) {
                g.setColor(slider.hasFocus() ? MetalLookAndFeel.getPrimaryControl() : MetalLookAndFeel.getControlHighlight());
                g.drawLine(1, 1, 13, 1);
                g.drawLine(1, 1, 1, 8);
            }
            g.translate(-x, -y);
        }

        public int getIconWidth() {
            return 15;
        }

        public int getIconHeight() {
            return 16;
        }
    }
}

