/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing;

import edu.berkeley.guir.lib.util.DayOfWeekLib;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DayOfWeekSelector
extends JPanel {
    public static final int SUNDAY = 0;
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    JToggleButton[] buttons;
    MyListSelectionModel selModel;
    List listItemListeners = new LinkedList();

    public DayOfWeekSelector() {
        this.commonInit();
    }

    public DayOfWeekSelector(int day) {
        this();
        this.setSelected(day, true);
    }

    public DayOfWeekSelector(int start, int end) {
        this();
        int i = start;
        while (i <= end) {
            this.setSelected(i, true);
            ++i;
        }
    }

    private void commonInit() {
        this.setLayout(new FlowLayout(1, 0, 0));
        this.createDayOfWeek();
        this.selModel = new MyListSelectionModel();
    }

    protected void createDayOfWeek() {
        this.buttons = new JToggleButton[7];
        this.buttons[0] = new JToggleButton("S");
        this.buttons[1] = new JToggleButton("M");
        this.buttons[2] = new JToggleButton("T");
        this.buttons[3] = new JToggleButton("W");
        this.buttons[4] = new JToggleButton("T");
        this.buttons[5] = new JToggleButton("F");
        this.buttons[6] = new JToggleButton("S");
        Insets insets = new Insets(1, 1, 1, 1);
        int i = 0;
        while (i < this.buttons.length) {
            this.buttons[i].setMargin(insets);
            ++i;
        }
        MyItemListener lstnr = new MyItemListener();
        int i2 = 0;
        while (i2 < this.buttons.length) {
            this.add(this.buttons[i2]);
            this.buttons[i2].addItemListener(lstnr);
            ++i2;
        }
    }

    public Dimension getPreferredSize() {
        this.validate();
        int maxHeight = 0;
        int maxWidth = 0;
        Dimension dimTmp = new Dimension();
        int i = 0;
        while (i < this.buttons.length) {
            dimTmp = this.buttons[i].getSize();
            maxHeight = (int)Math.max(dimTmp.getHeight(), (double)maxHeight);
            maxWidth = (int)Math.max(dimTmp.getWidth(), (double)maxWidth);
            ++i;
        }
        dimTmp.setSize(maxWidth, maxHeight);
        i = 0;
        while (i < this.buttons.length) {
            this.buttons[i].setSize(dimTmp);
            this.buttons[i].setMinimumSize(dimTmp);
            this.buttons[i].setPreferredSize(dimTmp);
            ++i;
        }
        return super.getPreferredSize();
    }

    public ListSelectionModel getListSelectionModel() {
        return this.selModel;
    }

    public void addItemListener(ItemListener l) {
        this.listItemListeners.add(l);
    }

    public void removeItemListener(ItemListener l) {
        this.listItemListeners.remove(l);
    }

    protected void fireItemEvent(ItemEvent evt) {
        Iterator it = this.listItemListeners.iterator();
        while (it.hasNext()) {
            ItemListener lstnr = (ItemListener)it.next();
            lstnr.itemStateChanged(evt);
        }
    }

    public void setSelected(int index, boolean flagSelected) {
        this.buttons[index].setSelected(flagSelected);
    }

    public void setSelected(int[] daysArr, boolean flagSelected) {
        int i = 0;
        while (i < daysArr.length) {
            this.setSelected(daysArr[i], flagSelected);
            ++i;
        }
    }

    public void setSelected(int start, int end, boolean flagSelected) {
        int i = start;
        while (i <= end) {
            this.buttons[i].setSelected(flagSelected);
            ++i;
        }
    }

    public void setAllSelected(boolean flagSelected) {
        int i = 0;
        while (i < this.buttons.length) {
            this.buttons[i].setSelected(flagSelected);
            ++i;
        }
    }

    public boolean isSelected(int index) {
        return this.buttons[index].isSelected();
    }

    public int[] getSelectedAsIntArray() {
        List listSelected = this.getSelectedAsList();
        int[] arrSelected = new int[listSelected.size()];
        Iterator it = listSelected.iterator();
        int index = 0;
        while (it.hasNext()) {
            Integer value = (Integer)it.next();
            arrSelected[index++] = value;
        }
        return arrSelected;
    }

    public String[] getSelectedAsStringArray(boolean flagFullDay) {
        return DayOfWeekLib.asStringArray(this.getSelectedAsIntArray(), flagFullDay);
    }

    protected List getSelectedAsList() {
        LinkedList<Integer> listSelected = new LinkedList<Integer>();
        int i = 0;
        while (i < this.buttons.length) {
            if (this.buttons[i].isSelected()) {
                listSelected.add(new Integer(i));
            }
            ++i;
        }
        return listSelected;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ", selected: " + this.getSelectedAsList();
    }

    public String toCSVDays(boolean flagUseFullDay) {
        return DayOfWeekLib.toCSVDays(this.getSelectedAsIntArray(), flagUseFullDay);
    }

    public String toConsecutiveDays(String strThru, boolean flagUseFullDay) {
        return DayOfWeekLib.toConsecutiveDays(this.getSelectedAsIntArray(), strThru, flagUseFullDay);
    }

    private static void createFrame(DayOfWeekSelector comp) {
        JFrame f = new JFrame();
        f.getContentPane().add(comp);
        f.pack();
        f.setVisible(true);
    }

    private static void runTestAAA() {
        DayOfWeekSelector.createFrame(new DayOfWeekSelector());
        DayOfWeekSelector.createFrame(new DayOfWeekSelector(1));
        DayOfWeekSelector.createFrame(new DayOfWeekSelector(1, 5));
    }

    public static void main(String[] argv) {
        DayOfWeekSelector.runTestAAA();
    }

    class MyListSelectionModel
    extends DefaultListSelectionModel {
        MyListSelectionModel() {
        }

        public void addSelectionInterval(int start, int end) {
            super.addSelectionInterval(start, end);
            int i = start;
            while (i < end) {
                DayOfWeekSelector.this.setSelected(i, true);
                ++i;
            }
        }

        public void clearSelection() {
            DayOfWeekSelector.this.setAllSelected(false);
        }

        public int getMaxSelectionIndex() {
            int i = DayOfWeekSelector.this.buttons.length - 1;
            while (i >= 0) {
                if (DayOfWeekSelector.this.buttons[i].isSelected()) {
                    return i;
                }
                --i;
            }
            return -1;
        }

        public int getMinSelectionIndex() {
            int i = 0;
            while (i < DayOfWeekSelector.this.buttons.length) {
                if (DayOfWeekSelector.this.buttons[i].isSelected()) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public int getSelectionMode() {
            return 2;
        }

        public boolean getValueIsAdjusting() {
            return false;
        }

        public boolean isLeadAnchorNotificationEnabled() {
            return false;
        }

        public boolean isSelectedIndex(int index) {
            return DayOfWeekSelector.this.isSelected(index);
        }

        public boolean isSelectionEmpty() {
            return this.getMinSelectionIndex() < 0;
        }

        public void setSelectionInterval(int start, int end) {
            DayOfWeekSelector.this.setAllSelected(false);
            int i = start;
            while (i < end) {
                DayOfWeekSelector.this.setSelected(i, true);
                ++i;
            }
        }

        public void setSelectionMode(int val) {
        }

        public void setValueIsAdjusting(boolean flag) {
        }

        public void fireValueChanged(int start, int end) {
            super.fireValueChanged(start, end);
        }
    }

    class MyItemListener
    implements ItemListener {
        MyItemListener() {
        }

        public void itemStateChanged(ItemEvent evt) {
            int index = -1;
            Object src = evt.getSource();
            int i = 0;
            while (i < DayOfWeekSelector.this.buttons.length) {
                if (DayOfWeekSelector.this.buttons[i] == src) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index < 0) {
                return;
            }
            DayOfWeekSelector.this.selModel.fireValueChanged(index, index);
            evt.setSource(DayOfWeekSelector.this);
            DayOfWeekSelector.this.fireItemEvent(evt);
        }
    }

    class DebugItemListener
    implements ItemListener {
        DebugItemListener() {
        }

        public void itemStateChanged(ItemEvent evt) {
            System.out.println(evt);
            System.out.println(evt.getSource().getClass());
            System.out.println(DayOfWeekSelector.this.getSelectedAsList());
            System.out.println(DayOfWeekSelector.this.selModel.getMinSelectionIndex());
            System.out.println(DayOfWeekSelector.this.selModel.getMaxSelectionIndex());
        }
    }

    class DebugListSelectionListener
    implements ListSelectionListener {
        DebugListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent evt) {
            System.out.println(evt);
            System.out.println(DayOfWeekSelector.this.getSelectedAsList());
            System.out.println(DayOfWeekSelector.this.selModel.getMinSelectionIndex());
            System.out.println(DayOfWeekSelector.this.selModel.getMaxSelectionIndex());
        }
    }
}

