/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing;

import com.sun.java.swing.plaf.motif.MotifComboBoxUI;
import com.sun.java.swing.plaf.windows.WindowsComboBoxUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class DateComboBox
extends JComboBox {
    private static final String BACKGROUND = "ComboBox.background";
    private static final String FOREGROUND = "ComboBox.foreground";
    private static final String SEL_BACKGROUND = "ComboBox.selectionBackground";
    private static final String SEL_FOREGROUND = "ComboBox.selectionForeground";
    static final Border BORDER_SELECTED = new EtchedBorder();
    static final Border BORDER_UNSELECTED = new EmptyBorder(BORDER_SELECTED.getBorderInsets(new JLabel()));
    SimpleDateFormat dateFormat = new SimpleDateFormat("MMM d, yyyy");

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    public void setSelectedItem(Object item) {
        this.removeAllItems();
        this.addItem(item);
        super.setSelectedItem(item);
    }

    public void updateUI() {
        Object cui = (ComboBoxUI)UIManager.getUI(this);
        if (cui instanceof MetalComboBoxUI) {
            cui = new MetalDateComboBoxUI();
        } else if (cui instanceof MotifComboBoxUI) {
            cui = new MotifDateComboBoxUI();
        } else if (cui instanceof WindowsComboBoxUI) {
            cui = new WindowsDateComboBoxUI();
        }
        this.setUI((ComboBoxUI)cui);
    }

    public static void main(String[] argv) throws Exception {
        JFrame f = new JFrame();
        Container c = f.getContentPane();
        c.setLayout(new FlowLayout());
        c.add(new JLabel("Date 1:"));
        c.add(new DateComboBox());
        c.add(new JLabel("Date 2:"));
        DateComboBox dcb = new DateComboBox();
        dcb.setEditable(true);
        c.add(dcb);
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setSize(500, 200);
        f.setVisible(true);
    }

    class MetalDateComboBoxUI
    extends MetalComboBoxUI {
        MetalDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    class WindowsDateComboBoxUI
    extends WindowsComboBoxUI {
        WindowsDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    class MotifDateComboBoxUI
    extends MotifComboBoxUI {
        MotifDateComboBoxUI() {
        }

        protected ComboPopup createPopup() {
            return new DatePopup(this.comboBox);
        }
    }

    class DatePopup
    implements ComboPopup,
    MouseMotionListener,
    MouseListener,
    KeyListener,
    PopupMenuListener {
        JComboBox comboBox;
        Calendar calendar;
        JPopupMenu popup;
        JLabel monthLabel;
        JPanel days = null;
        SimpleDateFormat monthFormat = new SimpleDateFormat("MMM yyyy");
        Color selectedBackground;
        Color selectedForeground;
        Color background;
        Color foreground;
        JList list = new JList();
        protected boolean mouseInside = false;
        protected boolean hideNext = false;

        public DatePopup(JComboBox comboBox) {
            this.comboBox = comboBox;
            this.calendar = Calendar.getInstance();
            this.background = UIManager.getColor(DateComboBox.BACKGROUND);
            this.foreground = UIManager.getColor(DateComboBox.FOREGROUND);
            this.selectedBackground = UIManager.getColor(DateComboBox.SEL_BACKGROUND);
            this.selectedForeground = UIManager.getColor(DateComboBox.SEL_FOREGROUND);
            this.initializePopup();
        }

        public void show() {
            try {
                this.calendar.setTime(DateComboBox.this.dateFormat.parse(this.comboBox.getSelectedItem().toString()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updatePopup();
            this.popup.show(this.comboBox, 0, this.comboBox.getHeight());
        }

        public void hide() {
            this.popup.setVisible(false);
        }

        public JList getList() {
            return this.list;
        }

        public MouseListener getMouseListener() {
            return this;
        }

        public MouseMotionListener getMouseMotionListener() {
            return this;
        }

        public KeyListener getKeyListener() {
            return this;
        }

        public boolean isVisible() {
            return this.popup.isVisible();
        }

        public void uninstallingUI() {
            this.popup.removePopupMenuListener(this);
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (!this.comboBox.isEnabled()) {
                return;
            }
            if (this.comboBox.isEditable()) {
                this.comboBox.getEditor().getEditorComponent().requestFocus();
            } else {
                this.comboBox.requestFocus();
            }
            this.togglePopup();
        }

        public void mouseEntered(MouseEvent e) {
            this.mouseInside = true;
        }

        public void mouseExited(MouseEvent e) {
            this.mouseInside = false;
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 32 || e.getKeyCode() == 10) {
                this.togglePopup();
            }
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.hideNext = this.mouseInside;
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        protected void togglePopup() {
            if (this.isVisible() || this.hideNext) {
                this.hide();
            } else {
                this.show();
            }
            this.hideNext = false;
        }

        protected JLabel createUpdateButton(int field, int amount) {
            JLabel label = new JLabel();
            label.setBorder(BORDER_UNSELECTED);
            label.setForeground(this.foreground);
            label.addMouseListener(new MouseAdapter(this, field, amount, label){
                final /* synthetic */ DatePopup this$1;
                private final /* synthetic */ int val$field;
                private final /* synthetic */ int val$amount;
                private final /* synthetic */ JLabel val$label;
                {
                    this.this$1 = datePopup;
                    this.val$field = n;
                    this.val$amount = n2;
                    this.val$label = jLabel;
                }

                public void mouseReleased(MouseEvent e) {
                    this.this$1.calendar.add(this.val$field, this.val$amount);
                    this.this$1.updatePopup();
                }

                public void mouseEntered(MouseEvent e) {
                    this.val$label.setBorder(BORDER_SELECTED);
                }

                public void mouseExited(MouseEvent e) {
                    this.val$label.setBorder(BORDER_UNSELECTED);
                }
            });
            return label;
        }

        protected void initializePopup() {
            JPanel header = new JPanel();
            header.setLayout(new BoxLayout(header, 0));
            header.setBackground(this.background);
            header.setOpaque(true);
            JLabel label = this.createUpdateButton(1, -1);
            label.setText("<<");
            label.setToolTipText("Previous Year");
            header.add(Box.createHorizontalStrut(12));
            header.add(label);
            header.add(Box.createHorizontalStrut(12));
            label = this.createUpdateButton(2, -1);
            label.setText("<");
            label.setToolTipText("Previous Month");
            header.add(label);
            this.monthLabel = new JLabel("", 0);
            this.monthLabel.setForeground(this.foreground);
            header.add(Box.createHorizontalGlue());
            header.add(this.monthLabel);
            header.add(Box.createHorizontalGlue());
            label = this.createUpdateButton(2, 1);
            label.setText(">");
            label.setToolTipText("Next Month");
            header.add(label);
            label = this.createUpdateButton(1, 1);
            label.setText(">>");
            label.setToolTipText("Next Year");
            header.add(Box.createHorizontalStrut(12));
            header.add(label);
            header.add(Box.createHorizontalStrut(12));
            this.popup = new JPopupMenu();
            this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
            this.popup.setLayout(new BorderLayout());
            this.popup.setBackground(this.background);
            this.popup.addPopupMenuListener(this);
            this.popup.add("North", header);
        }

        protected void updatePopup() {
            this.monthLabel.setText(this.monthFormat.format(this.calendar.getTime()));
            if (this.days != null) {
                this.popup.remove(this.days);
            }
            this.days = new JPanel(new GridLayout(0, 7));
            this.days.setBackground(this.background);
            this.days.setOpaque(true);
            Calendar setupCalendar = (Calendar)this.calendar.clone();
            setupCalendar.set(7, setupCalendar.getFirstDayOfWeek());
            int i = 0;
            while (i < 7) {
                int dayInt = setupCalendar.get(7);
                JLabel label = new JLabel();
                label.setHorizontalAlignment(0);
                label.setForeground(this.foreground);
                if (dayInt == 1) {
                    label.setText("Sun");
                } else if (dayInt == 2) {
                    label.setText("Mon");
                } else if (dayInt == 3) {
                    label.setText("Tue");
                } else if (dayInt == 4) {
                    label.setText("Wed");
                } else if (dayInt == 5) {
                    label.setText("Thu");
                } else if (dayInt == 6) {
                    label.setText("Fri");
                } else if (dayInt == 7) {
                    label.setText("Sat");
                }
                this.days.add(label);
                setupCalendar.roll(7, true);
                ++i;
            }
            setupCalendar = (Calendar)this.calendar.clone();
            setupCalendar.set(5, 1);
            int first = setupCalendar.get(7);
            int i2 = 0;
            while (i2 < first - 1) {
                this.days.add(new JLabel(""));
                ++i2;
            }
            i2 = 1;
            while (i2 <= setupCalendar.getActualMaximum(5)) {
                int day = i2++;
                JLabel label = new JLabel(String.valueOf(day));
                label.setHorizontalAlignment(0);
                label.setForeground(this.foreground);
                label.addMouseListener(new MouseListener(this, label, day){
                    final /* synthetic */ DatePopup this$1;
                    private final /* synthetic */ JLabel val$label;
                    private final /* synthetic */ int val$day;
                    {
                        this.this$1 = datePopup;
                        this.val$label = jLabel;
                        this.val$day = n;
                    }

                    public void mousePressed(MouseEvent e) {
                    }

                    public void mouseClicked(MouseEvent e) {
                    }

                    public void mouseReleased(MouseEvent e) {
                        this.val$label.setOpaque(false);
                        this.val$label.setBackground(this.this$1.background);
                        this.val$label.setForeground(this.this$1.foreground);
                        this.this$1.calendar.set(5, this.val$day);
                        this.this$1.comboBox.setSelectedItem(DatePopup.access$0((DatePopup)this.this$1).dateFormat.format(this.this$1.calendar.getTime()));
                        this.this$1.comboBox.requestFocus();
                    }

                    public void mouseEntered(MouseEvent e) {
                        this.val$label.setOpaque(true);
                        this.val$label.setBackground(this.this$1.selectedBackground);
                        this.val$label.setForeground(this.this$1.selectedForeground);
                    }

                    public void mouseExited(MouseEvent e) {
                        this.val$label.setOpaque(false);
                        this.val$label.setBackground(this.this$1.background);
                        this.val$label.setForeground(this.this$1.foreground);
                    }
                });
                this.days.add(label);
            }
            this.popup.add("Center", this.days);
            this.popup.pack();
        }

        static /* synthetic */ DateComboBox access$0(DatePopup datePopup) {
            return datePopup.DateComboBox.this;
        }
    }
}

