/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import javax.swing.JComponent;

public class Arrowhead
extends JComponent {
    private static final double ALPHA = 0.29670597283903605;
    private Polygon m_arrowhead;
    private boolean m_target = true;
    private int[] m_xPoints = new int[3];
    private int[] m_yPoints = new int[3];
    private int m_arrowSize = 20;
    private int m_tx;
    private int m_ty;
    private double m_theta;

    public void setArrowhead(Point tar, double theta) {
        if (tar.x != this.m_tx || tar.y != this.m_ty || theta != this.m_theta) {
            this.m_tx = tar.x;
            this.m_ty = tar.y;
            this.m_theta = theta;
            this.m_xPoints[0] = tar.x;
            this.m_yPoints[0] = tar.y;
            this.m_xPoints[1] = tar.x - (int)((double)this.m_arrowSize * Math.cos(theta - 0.29670597283903605));
            this.m_yPoints[1] = tar.y - (int)((double)this.m_arrowSize * Math.sin(theta - 0.29670597283903605));
            this.m_xPoints[2] = tar.x - (int)((double)this.m_arrowSize * Math.cos(theta + 0.29670597283903605));
            this.m_yPoints[2] = tar.y - (int)((double)this.m_arrowSize * Math.sin(theta + 0.29670597283903605));
            this.m_arrowhead = new Polygon(this.m_xPoints, this.m_yPoints, 3);
            this.setBounds(this.m_arrowhead.getBounds());
            this.setBounds(this.getX() - 1, this.getY() - 1, this.getWidth() + 2, this.getHeight() + 2);
            this.m_arrowhead.translate(-this.getX(), -this.getY());
        }
    }

    public void setArrowSize(int size) {
        this.m_arrowSize = size;
    }

    public int getArrowSize() {
        return this.m_arrowSize;
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(this.getForeground());
        if (this.m_target) {
            g2d.fill(this.m_arrowhead);
        } else {
            g2d.draw(this.m_arrowhead);
        }
    }

    public void setTarget(boolean b) {
        this.m_target = b;
    }
}

