/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.sql;

import edu.berkeley.guir.lib.collection.tuple.Tuple;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

public class SqlLib {
    public static List createListOfTuplesFromResultSet(ResultSet rset, String strTupleType) throws SQLException {
        LinkedList<Tuple> listResults = new LinkedList<Tuple>();
        if (rset == null) {
            return listResults;
        }
        ResultSetMetaData metadata = rset.getMetaData();
        int numCols = metadata.getColumnCount();
        while (rset.next()) {
            Tuple t = new Tuple(strTupleType);
            int i = 1;
            while (i <= numCols) {
                double dVal;
                String strColName = metadata.getColumnName(i);
                String strColType = metadata.getColumnTypeName(i);
                if ("VARCHAR".equals(strColType) || "CHAR".equals(strColType)) {
                    String strVal = rset.getString(i);
                    t.setAttribute(strColName, strVal);
                } else if ("DOUBLE".equals(strColType)) {
                    dVal = rset.getDouble(i);
                    t.setAttribute(strColName, dVal);
                } else if ("FLOAT".equals(strColType)) {
                    dVal = rset.getFloat(i);
                    t.setAttribute(strColName, dVal);
                } else if ("LONG".equals(strColType)) {
                    long lVal = rset.getLong(i);
                    t.setAttribute(strColName, lVal);
                } else if ("INTEGER".equals(strColType)) {
                    int iVal = rset.getInt(i);
                    t.setAttribute(strColName, iVal);
                } else {
                    throw new IllegalArgumentException("Don't know how to handle type: " + strColType);
                }
                ++i;
            }
            listResults.add(t);
        }
        return listResults;
    }
}

