/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.widgets;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.Book;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class SatinExceptionDialog
extends JDialog {
    public static final String DEFAULT_TITLE = "Exception Caught!";
    public static final String MESSAGE_LABEL = "Message:";
    public static final String NULL_EXCEPTION_MSG = "No exception given (null)";
    public static final String CLOSE_BUTTON_CAPTION = "Close";
    public static final String SHOW_DETAILS_BUTTON_CAPTION = "Show Details";
    public static final String HIDE_DETAILS_BUTTON_CAPTION = "Hide Details";
    public static final String DETAILS_BORDER_TITLE = "Details:";
    public static final String SAVE_BUTTON_CAPTION = "Save To File";
    public static final String PRINT_BUTTON_CAPTION = "Print";
    public static final String SAVE_TO_FILE_DIALOG_TITLE = "Save Stack Trace(s) To File";
    public static final int PREFERRED_WIDTH = 500;
    public static final int PREFERRED_NO_DETAILS_HEIGHT = 200;
    public static final int PREFERRED_DETAILS_HEIGHT = 500;
    protected JButton _showDetailsBtn;
    protected JPanel _bottomPanel;
    protected boolean _isShowingDetails = false;
    protected JTextArea _detailsTextArea;
    protected JScrollPane _detailsScrollPane;

    public SatinExceptionDialog(Throwable pEx) {
        this.setTitle(DEFAULT_TITLE);
        this.initGui(pEx);
    }

    public SatinExceptionDialog(Dialog pOwner, Throwable pEx) {
        super(pOwner, DEFAULT_TITLE);
        this.initGui(pEx);
    }

    public SatinExceptionDialog(Dialog pOwner, Throwable pEx, boolean pModal) {
        super(pOwner, DEFAULT_TITLE, pModal);
        this.initGui(pEx);
    }

    public SatinExceptionDialog(Dialog pOwner, Throwable pEx, String pTitle) {
        super(pOwner, pTitle);
        this.initGui(pEx);
    }

    public SatinExceptionDialog(Dialog pOwner, Throwable pEx, String pTitle, boolean pModal) {
        super(pOwner, pTitle, pModal);
        this.initGui(pEx);
    }

    public SatinExceptionDialog(Frame pOwner, Throwable pEx) {
        super(pOwner, DEFAULT_TITLE);
        this.initGui(pEx);
    }

    public SatinExceptionDialog(Frame pOwner, Throwable pEx, boolean pModal) {
        super(pOwner, DEFAULT_TITLE, pModal);
        this.initGui(pEx);
    }

    public SatinExceptionDialog(Frame pOwner, Throwable pEx, String pTitle) {
        super(pOwner, pTitle);
        this.initGui(pEx);
    }

    public SatinExceptionDialog(Frame pOwner, Throwable pEx, String pTitle, boolean pModal) {
        super(pOwner, pTitle, pModal);
        this.initGui(pEx);
    }

    protected void initGui(Throwable pEx) {
        this.setSize(new Dimension(500, 200));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel msgPanel = new JPanel(new BorderLayout(10, 5));
        msgPanel.add((Component)new JLabel(MESSAGE_LABEL), "West");
        String exMsg = "WARNING!  Caught a run-time error that may cause more problems.  \nIt is advisable to exit and restart the program before continuing.  \nIf you have unsaved work, you should probably try to save it first.\nIf this problem re-occurs and you have trouble working around it, \nplease consider passing the error details along to the developers.";
        JTextArea _msgTextArea = new JTextArea(exMsg);
        JScrollPane _msgScrollPane = new JScrollPane();
        _msgScrollPane.getViewport().add(_msgTextArea);
        msgPanel.add((Component)_msgScrollPane, "Center");
        JPanel topBtnPanel = new JPanel(new FlowLayout(2));
        JButton closeBtn = new JButton(CLOSE_BUTTON_CAPTION);
        this._showDetailsBtn = new JButton(SHOW_DETAILS_BUTTON_CAPTION);
        topBtnPanel.add(closeBtn);
        topBtnPanel.add(this._showDetailsBtn);
        topPanel.add((Component)msgPanel, "North");
        topPanel.add((Component)topBtnPanel, "Center");
        contentPane.add((Component)topPanel, "North");
        this._bottomPanel = new JPanel(new BorderLayout());
        JPanel detailPanel = new JPanel(new BorderLayout());
        detailPanel.setBorder(new TitledBorder(DETAILS_BORDER_TITLE));
        this._detailsTextArea = new JTextArea();
        this._detailsTextArea.setTabSize(2);
        this._detailsScrollPane = new JScrollPane();
        this._detailsScrollPane.getViewport().add(this._detailsTextArea);
        detailPanel.add((Component)this._detailsScrollPane, "Center");
        JPanel bottomBtnPanel = new JPanel(new FlowLayout(2));
        JButton saveToFileBtn = new JButton(SAVE_BUTTON_CAPTION);
        JButton printBtn = new JButton(PRINT_BUTTON_CAPTION);
        bottomBtnPanel.add(saveToFileBtn);
        bottomBtnPanel.add(printBtn);
        this._bottomPanel.add((Component)detailPanel, "Center");
        this._bottomPanel.add((Component)bottomBtnPanel, "South");
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        pEx.printStackTrace(printWriter);
        try {
            printWriter.close();
            stringWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._detailsTextArea.setText(stringWriter.toString());
        closeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SatinExceptionDialog.this.dispose();
            }
        });
        this._showDetailsBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SatinExceptionDialog.this.showDetails(!SatinExceptionDialog.this._isShowingDetails);
            }
        });
        saveToFileBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SatinExceptionDialog.this.saveDetailsToFile();
            }
        });
        printBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new PrintThread(SatinExceptionDialog.this._detailsTextArea.getText()).start();
            }
        });
        this.centerDialog();
    }

    public void showDetails(boolean pShowDetails) {
        int newHeight;
        if (pShowDetails == this._isShowingDetails) {
            return;
        }
        Dimension oldSize = this.getSize();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Container contentPane = this.getContentPane();
        if (pShowDetails) {
            contentPane.add((Component)this._bottomPanel, "Center");
            this._showDetailsBtn.setText(HIDE_DETAILS_BUTTON_CAPTION);
            this._detailsScrollPane.getViewport().setViewPosition(new Point(0, 0));
            newHeight = 500 > screenSize.height ? screenSize.height : 500;
        } else {
            contentPane.remove(this._bottomPanel);
            this._showDetailsBtn.setText(SHOW_DETAILS_BUTTON_CAPTION);
            newHeight = 200;
        }
        this._isShowingDetails = pShowDetails;
        this.setSize(new Dimension(oldSize.width, newHeight));
        Point location = this.getLocationOnScreen();
        if (location.getY() + (double)newHeight > (double)screenSize.height) {
            this.centerDialog();
        }
        this.validate();
    }

    public void centerDialog() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        int remainderWidth = screenSize.width - dialogSize.width;
        int remainderHeight = screenSize.height - dialogSize.height;
        this.setLocation(new Point(remainderWidth / 2, remainderHeight / 2));
    }

    public void saveDetailsToFile() {
        Frame frame = this.getParentFrame(this.getOwner());
        FileDialog fileDialog = new FileDialog(frame, SAVE_TO_FILE_DIALOG_TITLE, 1);
        fileDialog.show();
        String filename = fileDialog.getFile();
        if (filename != null) {
            String directory = fileDialog.getDirectory();
            try {
                FileWriter fileWriter = new FileWriter(String.valueOf(directory) + filename);
                fileWriter.write(this._detailsTextArea.getText());
                fileWriter.close();
            }
            catch (IOException ex) {
                this.showInternalException(ex);
            }
        }
    }

    private Frame getParentFrame(Window pSibling) {
        Window current = pSibling;
        while (current != null && !(current instanceof Frame)) {
            current = current.getOwner();
        }
        return (Frame)current;
    }

    private void showInternalException(Throwable pEx) {
        SatinExceptionDialog exceptionDialog = this.getOwner() instanceof Dialog ? new SatinExceptionDialog((Dialog)this.getOwner(), pEx, true) : (this.getOwner() instanceof Frame ? new SatinExceptionDialog((Frame)this.getOwner(), pEx, true) : new SatinExceptionDialog(null, pEx, true));
        exceptionDialog.show();
    }

    static /* synthetic */ void access$0(SatinExceptionDialog satinExceptionDialog, Throwable throwable) {
        satinExceptionDialog.showInternalException(throwable);
    }

    private class PrintThread
    extends Thread {
        private String _exceptionDetails;

        public PrintThread(String pExceptionDetails) {
            this._exceptionDetails = pExceptionDetails;
        }

        public void run() {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            Book book = new Book();
            PagePrinter pagePrinter = new PagePrinter(this._exceptionDetails);
            PageFormat pageFormat = printerJob.pageDialog(printerJob.defaultPage());
            int numPages = pagePrinter.calculatePageCount(pageFormat);
            book.append(pagePrinter, pageFormat, numPages);
            printerJob.setPageable(book);
            if (printerJob.printDialog()) {
                try {
                    printerJob.print();
                }
                catch (PrinterException ex) {
                    SwingUtilities.invokeLater(new Runnable(this, ex){
                        final /* synthetic */ PrintThread this$1;
                        private final /* synthetic */ PrinterException val$ex;
                        {
                            this.this$1 = printThread;
                            this.val$ex = printerException;
                        }

                        public void run() {
                            SatinExceptionDialog.access$0(PrintThread.access$0(this.this$1), this.val$ex);
                        }
                    });
                }
            }
        }

        static /* synthetic */ SatinExceptionDialog access$0(PrintThread printThread) {
            return printThread.SatinExceptionDialog.this;
        }
    }

    private class PagePrinter
    implements Printable {
        private String _exceptionDetails;
        private ArrayList _pages;
        PageFormat _currentPageFormat;
        Font _font = new Font("TimesRoman", 0, 12);

        public PagePrinter(String pExceptionDetails) {
            this._exceptionDetails = pExceptionDetails;
        }

        public int calculatePageCount(PageFormat pPageFormat) {
            ArrayList pages = this.repaginate(pPageFormat);
            return pages.size();
        }

        public int print(Graphics pGraphics, PageFormat pPageFormat, int pPageIndex) throws PrinterException {
            if (this._currentPageFormat != pPageFormat) {
                this._currentPageFormat = pPageFormat;
                this._pages = this.repaginate(pPageFormat);
            }
            if (pPageIndex >= this._pages.size()) {
                return 1;
            }
            pGraphics.setFont(this._font);
            pGraphics.setColor(Color.black);
            this.renderPage(pGraphics, pPageFormat, pPageIndex);
            return 0;
        }

        private ArrayList repaginate(PageFormat pPageFormat) {
            int maxPageHeight = (int)pPageFormat.getImageableHeight();
            int lineHeight = this._font.getSize();
            ArrayList pageList = new ArrayList();
            ArrayList<String> currentPage = new ArrayList<String>();
            int currentPageHeight = 0;
            StringTokenizer tokenizer = new StringTokenizer(this._exceptionDetails, "\n");
            while (tokenizer.hasMoreTokens()) {
                String line = tokenizer.nextToken();
                if (currentPageHeight + lineHeight > maxPageHeight) {
                    pageList.add(currentPage);
                    currentPage = new ArrayList();
                    currentPageHeight = 0;
                }
                currentPage.add(line);
                currentPageHeight += lineHeight;
            }
            pageList.add(currentPage);
            return pageList;
        }

        private void renderPage(Graphics pGraphics, PageFormat pPageFormat, int pPageIndex) {
            int xOrigin = (int)pPageFormat.getImageableX();
            int yOrigin = (int)pPageFormat.getImageableY();
            int yOffset = this._font.getSize();
            ArrayList pageLines = (ArrayList)this._pages.get(pPageIndex);
            Iterator it = pageLines.iterator();
            while (it.hasNext()) {
                String line = (String)it.next();
                pGraphics.drawString(line, xOrigin, yOffset + yOrigin);
                yOffset += this._font.getSize();
            }
        }
    }
}

