/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.widgets;

import edu.berkeley.guir.lib.satin.widgets.PenButton;
import edu.berkeley.guir.lib.satin.widgets.PieMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JMenuItem;

public class PopupPieMenu
extends PenButton {
    private PieMenu m_pieMenu = new PieMenu();
    private Icon myIcon;

    public PopupPieMenu(String[] filterStrings, int startIndex) {
        super(filterStrings[startIndex]);
        this.myIcon = new PieMenuIcon(super.getPreferredSize().height / 2);
        super.setIcon(this.myIcon);
        super.setHorizontalTextPosition(2);
        this.m_pieMenu.addPieMenuTo(this);
        PieMenu.setAllInitialDelay(0L);
        this.m_pieMenu.setAcceptLeftButton(true);
        this.m_pieMenu.setLineNorth(true);
        PieMenu.setAllTapOpen();
        PieMenu.setAllClipping(true);
    }

    public JMenuItem add(String s) {
        JMenuItem j = this.m_pieMenu.add(s);
        j.addActionListener(new PopupActionListener(s));
        return j;
    }

    public void setSelectedItem(String s) {
        this.setText(s);
    }

    private class PieMenuIcon
    implements Icon {
        private static final int SPACE = 10;
        private int m_size;

        PieMenuIcon(int size) {
            this.m_size = size;
        }

        public int getIconHeight() {
            return this.m_size;
        }

        public int getIconWidth() {
            return this.m_size + 10;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(Color.gray);
            g2d.fillArc(x += 9, y, this.m_size, this.m_size, 45, 90);
            g.setColor(Color.black);
            g2d.drawOval(x, y, this.m_size, this.m_size);
        }
    }

    private class PopupActionListener
    implements ActionListener {
        private String m_filterName;

        PopupActionListener(String s) {
            this.m_filterName = s;
        }

        public void actionPerformed(ActionEvent e) {
            PopupPieMenu.this.setText(this.m_filterName);
        }
    }
}

