/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.widgets;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class PieMenu
extends JPanel
implements MenuElement {
    static final long serialVersionUID = 9008472948612331581L;
    public static final double DEFAULT_START = 1.5707963267948966;
    public static final int DEFAULT_BIG_RADIUS = 100;
    public static final int DEFAULT_SMALL_RADIUS = 20;
    public static final long DEFAULT_INITIAL_DELAY = 200L;
    public static final long DEFAULT_SUBMENU_DELAY = 500L;
    public static final boolean DEFAULT_AUTO_OPEN = false;
    public static final boolean DEFAULT_CLIP_FLAG = false;
    public static final double DEFAULT_SCALING_FACTOR = 0.65;
    public static final Color DEFAULT_FILL_COLOR = new Color(204, 204, 204);
    public static final Color DEFAULT_LINE_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.35f);
    public static final Color DEFAULT_SELECTED_COLOR = new Color(167, 167, 167);
    public static final Color DEFAULT_FONT_COLOR = Color.black;
    public static final Font DEFAULT_FONT = new Font("SansSerif", 0, 15);
    public static final float DEFAULT_LINE_WIDTH = 0.7f;
    private static final int STATE_TAP_OPEN = 90;
    private static final int STATE_TAPHOLD_OPEN = 91;
    private static final int STATE_DRAG_OPEN = 92;
    private static final int ORIENT_TOP = 1;
    private static final int ORIENT_TOPRIGHT = 2;
    private static final int ORIENT_BOTTOM = 3;
    private static final int ORIENT_TOPLEFT = 4;
    private static final int ORIENT_BOTRIGHT = 5;
    private static final int ORIENT_BOTLEFT = 6;
    static boolean enableSubmenus = true;
    static boolean enableSelect = true;
    static boolean defaultAutoOpen = false;
    static int defaultOpenState = 90;
    static boolean defaultRelocateSubmenusFlag = true;
    static long defaultInitialDelay = 200L;
    static long defaultSubmenuDelay = 500L;
    static boolean defaultFlagPenMode = false;
    static Color defaultFillColor = DEFAULT_FILL_COLOR;
    static Color defaultLineColor = DEFAULT_LINE_COLOR;
    static Color defaultSelectedColor = DEFAULT_SELECTED_COLOR;
    static Color defaultFontColor = DEFAULT_FONT_COLOR;
    static Font defaultFont = DEFAULT_FONT;
    static float defaultLineWidth = 0.7f;
    static int defaultBigRadius = 100;
    static int defaultSmallRadius = 20;
    static double defaultScalingFactor = 0.65;
    static boolean defaultClipFlag = false;
    static boolean defaultFlagLineNorth = false;
    static Image defaultSubmenuIcon = null;
    Color tmpFillColor;
    Color tmpSelectedColor;
    boolean flagDone = true;
    int count = 0;
    BlinkActionListener blinkListener = new BlinkActionListener();
    Color fillColor;
    Color lineColor;
    Color fontColor;
    Color selectedColor;
    Color defaultSelectedItemColor;
    Font font;
    boolean flagLineNorth;
    BlinkTimer timer;
    transient Image submenuIconImage;
    transient BasicStroke stroke;
    PieMenuListener lstnr;
    ItemListener clistener;
    MouseEvent lastEvent;
    PieMenuHandler handler;
    boolean flagCanAbortSubmenu;
    boolean flagDraggedInPieMenu;
    boolean flagJustClosedSubmenu;
    boolean flagJustOpened;
    private boolean flagAcceptLeft = false;
    private boolean flagAcceptMid = false;
    private boolean flagAcceptRight = false;
    int radius;
    int smallRadius;
    transient Ellipse2D bigCircle;
    transient Ellipse2D smallCircle;
    transient Ellipse2D clipCircle;
    transient Map newHints;
    boolean flagPenMode;
    double scalingFactor;
    String strText;
    Icon icon;
    Container parent;
    List list;
    int selected = -1;
    int defaultSelected = -1;
    ShowThread showThread;
    ShowSubmenuThread submenuThread;
    int submenuPos;
    PieMenu submenu;
    PieMenu parentMenu = null;
    ArrayList popupMenuListeners;

    private static synchronized void enableSubmenus() {
        enableSubmenus = true;
    }

    private static synchronized void disableSubmenus() {
        enableSubmenus = false;
    }

    private static synchronized boolean submenusAreEnabled() {
        return enableSubmenus;
    }

    private static synchronized void enableSelect() {
        enableSelect = true;
    }

    private static synchronized void disableSelect() {
        enableSelect = false;
    }

    private static synchronized boolean selectIsEnabled() {
        return enableSelect;
    }

    public static void setAllAutoOpen(boolean flag) {
        defaultAutoOpen = flag;
    }

    public static boolean getAllAutoOpen() {
        return defaultAutoOpen;
    }

    public static boolean isTapOpen() {
        return defaultOpenState == 90;
    }

    public static boolean isTapHoldOpen() {
        return defaultOpenState == 91;
    }

    public static boolean isDragOpen() {
        return defaultOpenState == 92;
    }

    public static void setAllTapOpen() {
        defaultOpenState = 90;
    }

    public static void setAllTapHoldOpen() {
        defaultOpenState = 91;
        PieMenu.setAllInitialDelay(400L);
    }

    public static void setAllDragOpen() {
        defaultOpenState = 92;
    }

    public static void setAllRelocateSubmenus(boolean flag) {
        defaultRelocateSubmenusFlag = flag;
    }

    public static boolean getAllRelocateSubmenus() {
        return defaultRelocateSubmenusFlag;
    }

    private static void updatePieMenuToCurrentMode(PieMenu pm) {
        PieMenu.updateToPenMode(pm);
        PieMenu.updateToMouseMode(pm);
    }

    private static void updateToPenMode(PieMenu pm) {
        if (PieMenu.isAllPenMode() && !pm.getPenMode()) {
            pm.setPenMode();
            PieMenu.setAllTapOpen();
        }
    }

    private static void updateToMouseMode(PieMenu pm) {
        if (PieMenu.isAllMouseMode() && !pm.getMouseMode()) {
            pm.setMouseMode();
            PieMenu.setAllDragOpen();
        }
    }

    public static void setAllToPenMode() {
        PieMenu.setAllTapOpen();
        defaultFlagPenMode = true;
        PieMenu.setAllSubmenuDelay(750L);
    }

    public static void setAllToMouseMode() {
        PieMenu.setAllDragOpen();
        defaultFlagPenMode = false;
        PieMenu.setAllSubmenuDelay(500L);
    }

    public static boolean isAllPenMode() {
        return defaultFlagPenMode;
    }

    public static boolean isAllMouseMode() {
        return !defaultFlagPenMode;
    }

    public static void setAllInitialDelay(long newDelay) {
        defaultInitialDelay = newDelay;
    }

    public static long getAllInitialDelay() {
        return defaultInitialDelay;
    }

    public static void setAllSubmenuDelay(long newDelay) {
        defaultSubmenuDelay = newDelay;
    }

    public static long getAllSubmenuDelay() {
        return defaultSubmenuDelay;
    }

    public static void setAllClipping(boolean flag) {
        defaultClipFlag = flag;
    }

    public static boolean getAllClipping() {
        return defaultClipFlag;
    }

    public static void setDefaultSubmenuIcon(Image newImage) {
        defaultSubmenuIcon = newImage;
    }

    public static Image getDefaultSubmenuIcon() {
        return defaultSubmenuIcon;
    }

    public static void setDefaultFillColor(Color newColor) {
        defaultFillColor = newColor;
    }

    public static Color getDefaultFillColor() {
        return defaultFillColor;
    }

    public static void setDefaultLineColor(Color newColor) {
        defaultLineColor = newColor;
    }

    public static Color getDefaultLineColor() {
        return defaultLineColor;
    }

    public static void setDefaultSelectedColor(Color newColor) {
        defaultSelectedColor = newColor;
    }

    public static Color getDefaultSelectedColor() {
        return defaultSelectedColor;
    }

    public static void setDefaultFontColor(Color newColor) {
        defaultFontColor = newColor;
    }

    public static Color getDefaultFontColor() {
        return defaultFontColor;
    }

    public static void setDefaultFont(Font newFont) {
        defaultFont = newFont;
    }

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static void setDefaultLineWidth(float newLineWidth) {
        defaultLineWidth = newLineWidth;
    }

    public static float getDefaultLineWidth() {
        return defaultLineWidth;
    }

    public static void setDefaultBigRadius(int newRadius) {
        defaultBigRadius = newRadius;
    }

    public static int getDefaultBigRadius() {
        return defaultBigRadius;
    }

    public static void setDefaultSmallRadius(int newRadius) {
        defaultSmallRadius = newRadius;
    }

    public static int getDefaultSmallRadius() {
        return defaultSmallRadius;
    }

    public static void setDefaultScalingFactor(double newScalingFactor) {
        defaultScalingFactor = newScalingFactor;
    }

    public static double getDefaultScalingFactor() {
        return defaultScalingFactor;
    }

    public static void setDefaultLineNorth(boolean flag) {
        defaultFlagLineNorth = flag;
    }

    public static boolean getDefaultLineNorth() {
        return defaultFlagLineNorth;
    }

    public PieMenu() {
        this(100);
    }

    public PieMenu(int radius) {
        this("", null, radius);
    }

    public PieMenu(String str) {
        this(str, null, 100);
    }

    public PieMenu(String str, Icon icon) {
        this(str, icon, 100);
    }

    public PieMenu(String str, int radius) {
        this(str, null, radius);
    }

    public PieMenu(String str, Icon icon, int radius) {
        this.setFillColor(PieMenu.getDefaultFillColor());
        this.setLineColor(PieMenu.getDefaultLineColor());
        this.setFontColor(PieMenu.getDefaultFontColor());
        this.setSelectedColor(PieMenu.getDefaultSelectedColor());
        this.setFont(PieMenu.getDefaultFont());
        this.setLineWidth(PieMenu.getDefaultLineWidth());
        this.setLineNorth(PieMenu.getDefaultLineNorth());
        this.setScalingFactor(PieMenu.getDefaultScalingFactor());
        this.submenuIconImage = PieMenu.getDefaultSubmenuIcon();
        this.bigCircle = new Ellipse2D.Double();
        this.smallCircle = new Ellipse2D.Double();
        this.clipCircle = new Ellipse2D.Double();
        this.list = new ArrayList();
        this.timer = new BlinkTimer();
        this.setDoubleBuffered(true);
        this.popupMenuListeners = new ArrayList();
        this.setOpaque(false);
        this.handler = new PieMenuHandler();
        this.lstnr = new PieMenuListener();
        this.clistener = new ItemListener();
        this.setLocation(0, 0);
        this.setVisible(true);
        this.setFont(PieMenu.getDefaultFont());
        this.setBigRadius(PieMenu.getDefaultBigRadius());
        this.setSmallRadius(PieMenu.getDefaultSmallRadius());
        this.setIcon(icon);
        this.setText(str);
        this.addMouseListener(this.lstnr);
        this.addMouseMotionListener(this.lstnr);
        this.newHints = new HashMap();
        this.newHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.newHints.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        this.newHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.newHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
    }

    public MenuElement[] getSubElements() {
        MenuElement[] m = new MenuElement[this.list.size()];
        int i = 0;
        while (i < this.list.size()) {
            m[i] = (MenuElement)this.list.get(i);
            ++i;
        }
        return m;
    }

    public void menuSelectionChanged(boolean isIncluded) {
    }

    public void processKeyEvent(KeyEvent evt, MenuElement[] path, MenuSelectionManager manager) {
        throw new RuntimeException("this method has not been implemented yet");
    }

    public void processMouseEvent(MouseEvent evt, MenuElement[] path, MenuSelectionManager manager) {
        throw new RuntimeException("this method has not been implemented yet");
    }

    private PolarCoordinate getPolarCoordinates(int x, int y) {
        int xx = x - this.radius;
        int yy = y - this.radius;
        double distance = Math.sqrt(xx * xx + yy * yy);
        double normalizedRadius = (double)xx / distance;
        double theta = Math.acos(normalizedRadius);
        if (yy > 0) {
            theta = Math.PI * 2 - theta;
        }
        return new PolarCoordinate(distance, theta);
    }

    Point polarToCartesian(int x, int y, double radian, double radius, Point pt) {
        pt.x = (int)((double)x + radius * Math.cos(radian));
        pt.y = (int)((double)y - radius * Math.sin(radian));
        if (Math.abs((double)pt.x - radius) <= 1.0) {
            pt.x = (int)radius;
        }
        if (Math.abs((double)pt.y - radius) <= 1.0) {
            pt.y = (int)radius;
        }
        return pt;
    }

    static boolean isBetween(double angle, double a, double b) {
        angle %= Math.PI * 2;
        if ((a %= Math.PI * 2) < (b %= Math.PI * 2)) {
            return a <= angle && angle <= b;
        }
        return b >= angle || angle >= a;
    }

    private void setPenMode() {
        this.flagPenMode = true;
    }

    private boolean getPenMode() {
        return this.flagPenMode;
    }

    private void setMouseMode() {
        this.flagPenMode = false;
    }

    private boolean getMouseMode() {
        return !this.flagPenMode;
    }

    private double getStartRadian() {
        int numItems = this.getItemCount();
        if (this.getLineNorth() || numItems <= 1) {
            return 1.5707963267948966;
        }
        double offset = Math.PI * 2 / (double)numItems;
        return 1.5707963267948966 - offset / 2.0;
    }

    private int getSliceNumber(int x, int y) {
        PolarCoordinate polar = this.getPolarCoordinates(x, y);
        int numItems = this.getItemCount();
        if (this.smallCircle.contains(x, y)) {
            return -1;
        }
        double currentRadian = this.getStartRadian();
        double stepRadian = Math.PI * 2 / (double)numItems;
        double theta = Math.PI * 2 + polar.theta;
        int count = 0;
        int i = 0;
        while (i < 2 * numItems) {
            if (currentRadian < theta && theta <= currentRadian + stepRadian) {
                return count % numItems;
            }
            ++count;
            theta -= stepRadian;
            ++i;
        }
        return -1;
    }

    PieMenu getActiveMenu() {
        PieMenu pm = this.getActiveMenuHelper();
        if (pm == null) {
            return this;
        }
        return pm;
    }

    PieMenu getActiveMenuHelper() {
        PieMenu pm;
        if (this.submenu != null && (pm = this.submenu.getActiveMenuHelper()) != null) {
            return pm;
        }
        if (this.isShowing()) {
            return this;
        }
        return null;
    }

    MouseEvent convertMouseEventSpace(MouseEvent evt) {
        Point ptComponent = evt.getComponent().getLocationOnScreen();
        PieMenu activeMenu = this.getActiveMenu();
        Point ptPie = activeMenu.getLocationOnScreen();
        evt.translatePoint(ptComponent.x - ptPie.x, ptComponent.y - ptPie.y);
        return evt;
    }

    PieMenuHandler getDispatcher() {
        PieMenu activeMenu = this.getActiveMenu();
        return activeMenu.getPieMenuHandler();
    }

    PieMenuHandler getPieMenuHandler() {
        return this.handler;
    }

    private int fixPieLocationX(int x) {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int returnvalue = x;
        if (x + defaultBigRadius > dim.width) {
            returnvalue = dim.width - defaultBigRadius;
        }
        if (x - defaultBigRadius < 0) {
            returnvalue = defaultBigRadius;
        }
        return returnvalue;
    }

    private int fixPieLocationY(int y) {
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int returnvalue = y;
        if (y + defaultBigRadius > dim.height) {
            returnvalue = dim.height - defaultBigRadius;
        }
        if (y - defaultBigRadius < 0) {
            returnvalue = defaultBigRadius;
        }
        return returnvalue;
    }

    void updateShowLocation(int x, int y) {
        if (this.submenuThread != null) {
            this.submenuThread.setShowLocation(x, y);
        }
        if (this.showThread != null && (PieMenu.isTapOpen() || PieMenu.isTapHoldOpen())) {
            this.showThread.setShowLocation(x, y);
        }
    }

    void clearLastMouseEvent() {
        this.lastEvent = null;
    }

    void setLastMouseEvent(MouseEvent evt) {
        this.lastEvent = new MouseEvent(evt.getComponent(), evt.getID(), 0L, evt.getModifiers(), evt.getX(), evt.getY(), evt.getClickCount(), evt.isPopupTrigger());
    }

    void forwardLastEvent() {
        if (this.lastEvent != null) {
            PieMenuHandler redispatcher = this.getDispatcher();
            MouseEvent evt = this.convertMouseEventSpace(this.lastEvent);
            switch (this.lastEvent.getID()) {
                case 503: {
                    redispatcher.handleMouseMoved(this.lastEvent);
                    break;
                }
                case 506: {
                    redispatcher.handleMouseDragged(this.lastEvent);
                    break;
                }
                case 502: {
                    redispatcher.handleMouseReleased(this.lastEvent);
                }
            }
            this.clearLastMouseEvent();
        }
    }

    public void setFillColor(Color newColor) {
        this.fillColor = newColor;
    }

    public Color getFillColor() {
        return this.fillColor;
    }

    public void setLineColor(Color newColor) {
        this.lineColor = newColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setSelectedColor(Color newColor) {
        this.selectedColor = newColor;
        this.defaultSelectedItemColor = new Color(this.selectedColor.getRed(), this.selectedColor.getGreen(), this.selectedColor.getBlue(), 127);
    }

    public Color getSelectedColor() {
        return this.selectedColor;
    }

    public void setFontColor(Color newColor) {
        this.fontColor = newColor;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFont(Font newFont) {
        super.setFont(newFont);
    }

    public Font getFont() {
        return super.getFont();
    }

    public void setLineWidth(float newWidth) {
        this.stroke = new BasicStroke(newWidth);
    }

    public void setBigRadius(int radius) {
        if (radius > 0) {
            this.radius = radius;
            this.setSize(2 * radius + 1, 2 * radius + 1);
            Dimension dim = new Dimension(2 * radius, 2 * radius);
            this.setMinimumSize(dim);
            this.setMaximumSize(dim);
            this.setPreferredSize(dim);
            this.updateShape();
        }
    }

    public int getBigRadius() {
        return this.radius;
    }

    public void setSmallRadius(int newRadius) {
        this.smallRadius = newRadius;
        this.updateShape();
    }

    public int getSmallRadius() {
        return this.smallRadius;
    }

    public void setScalingFactor(double newScalingFactor) {
        this.scalingFactor = newScalingFactor;
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public void setLineNorth(boolean flag) {
        this.flagLineNorth = flag;
    }

    public boolean getLineNorth() {
        return this.flagLineNorth;
    }

    public void setAcceptLeftButton(boolean bool) {
        this.flagAcceptLeft = bool;
    }

    public void setAcceptRightButton(boolean bool) {
        this.flagAcceptRight = bool;
    }

    public void setAcceptMidButton(boolean bool) {
        this.flagAcceptMid = bool;
    }

    private void abortSubmenu() {
        if (this.submenuThread != null && this.flagCanAbortSubmenu) {
            this.submenuThread.abort();
            if (this.submenu != null) {
                this.submenu.setVisible(false);
            }
            this.submenuThread = null;
            this.submenu = null;
        }
    }

    public void setSelectedItem(int index) {
        if (!PieMenu.selectIsEnabled()) {
            return;
        }
        if (index != this.selected) {
            if (this.submenuThread != null && !this.flagCanAbortSubmenu) {
                return;
            }
            this.abortSubmenu();
            this.selected = index;
            this.flagJustClosedSubmenu = false;
            this.repaintBounds();
        }
    }

    public int getSelectedItem() {
        return this.selected;
    }

    public void setDefaultSelectedItem(int pos) {
        if (pos >= this.getItemCount()) {
            pos = -1;
        }
        this.defaultSelected = pos;
    }

    public int getDefaultSelectedItem() {
        return this.defaultSelected;
    }

    public boolean doesActivateMenu(MouseEvent evt) {
        if (this.flagAcceptLeft) {
            return SwingUtilities.isLeftMouseButton(evt);
        }
        if (this.flagAcceptRight) {
            return SwingUtilities.isRightMouseButton(evt);
        }
        if (this.flagAcceptMid) {
            return SwingUtilities.isMiddleMouseButton(evt);
        }
        if (System.getProperty("os.name").equals("Mac OS X")) {
            return evt.isControlDown();
        }
        return SwingUtilities.isRightMouseButton(evt);
    }

    public void addPieMenuTo(Component c) {
        c.addMouseListener(this.clistener);
        c.addMouseMotionListener(this.clistener);
        c.addComponentListener(this.clistener);
    }

    protected void updateShape() {
        Rectangle bounds = this.getBounds();
        this.bigCircle.setFrame(0.0, 0.0, 2 * this.radius, 2 * this.radius);
        this.clipCircle.setFrame(-2.0, -2.0, 2 * this.radius + 4, 2 * this.radius + 4);
        this.smallCircle.setFrame(this.radius - this.smallRadius, this.radius - this.smallRadius, 2 * this.smallRadius, 2 * this.smallRadius);
    }

    public boolean contains(int x, int y) {
        if (!this.isVisible()) {
            return false;
        }
        return this.bigCircle.contains(x, y);
    }

    public boolean contains(Point pt) {
        if (!this.isVisible()) {
            return false;
        }
        return this.contains(pt.x, pt.y);
    }

    public void setText(String str) {
        this.strText = str;
    }

    public String getText() {
        return this.strText;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Component getComponent() {
        return this.parent;
    }

    public int getItemCount() {
        return this.list.size();
    }

    private JMenuItemWrapper add(JMenuItemWrapper item, int index) {
        if (index == -1) {
            this.list.add(item);
        } else {
            this.list.add(index, item);
        }
        return item;
    }

    private JMenuItemWrapper add(JMenuItemWrapper item) {
        this.list.add(item);
        return item;
    }

    public JMenuItem add(JMenuItem menuItem, int index) {
        return this.add(menuItem.getText(), menuItem.getIcon(), index);
    }

    public JMenuItem add(JMenuItem menuItem) {
        return this.add(menuItem.getText(), menuItem.getIcon(), -1);
    }

    public JMenuItem add(Icon icon, int index) {
        return this.add(new JMenuItemWrapper(icon), index);
    }

    public JMenuItem add(Icon icon) {
        return this.add(new JMenuItemWrapper(icon));
    }

    public JMenuItem add(String str, int index) {
        return this.add(new JMenuItemWrapper(str), index);
    }

    public JMenuItem add(String str) {
        return this.add(new JMenuItemWrapper(str));
    }

    public JMenuItem add(String str, Icon icon, int index) {
        return this.add(new JMenuItemWrapper(str, icon), index);
    }

    public JMenuItem add(String str, Icon icon) {
        return this.add(new JMenuItemWrapper(str, icon));
    }

    public void add(PieMenu menu, int index) {
        if (index == -1) {
            this.add(menu);
        } else {
            this.list.add(index, menu);
        }
    }

    public void add(PieMenu menu) {
        this.list.add(menu);
    }

    public void remove(int pos) {
        this.list.remove(pos);
    }

    public JMenuItem getItem(int pos) {
        return (JMenuItem)this.list.get(pos);
    }

    public void addPopupMenuListener(PopupMenuListener l) {
        this.popupMenuListeners.add(l);
    }

    public void removePopupMenuListener(PopupMenuListener l) {
        this.popupMenuListeners.remove(l);
    }

    protected void firePopupMenuWillBecomeVisible() {
        ArrayList lst = (ArrayList)this.popupMenuListeners.clone();
        Iterator it = lst.iterator();
        while (it.hasNext()) {
            PopupMenuListener l = (PopupMenuListener)it.next();
            l.popupMenuWillBecomeVisible(new PopupMenuEvent(this));
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        ArrayList lst = (ArrayList)this.popupMenuListeners.clone();
        Iterator it = lst.iterator();
        while (it.hasNext()) {
            PopupMenuListener l = (PopupMenuListener)it.next();
            l.popupMenuWillBecomeInvisible(new PopupMenuEvent(this));
        }
    }

    protected void firePopupMenuCanceled() {
        ArrayList lst = (ArrayList)this.popupMenuListeners.clone();
        Iterator it = lst.iterator();
        while (it.hasNext()) {
            PopupMenuListener l = (PopupMenuListener)it.next();
            l.popupMenuCanceled(new PopupMenuEvent(this));
        }
    }

    public void setVisible(boolean flag) {
        if (flag) {
            this.firePopupMenuWillBecomeVisible();
        } else {
            this.firePopupMenuWillBecomeInvisible();
            this.hideInternal();
        }
        super.setVisible(flag);
    }

    private void hideInternal() {
        PieMenu.enableSelect();
        if (this.parent != null) {
            Rectangle rect = this.getBounds();
            this.parent.remove(this);
            this.parent.repaint(rect.x, rect.y, rect.width, rect.height);
            this.parent = null;
            this.flagCanAbortSubmenu = true;
            this.abortSubmenu();
            this.timer.stop();
            this.showThread = null;
            this.submenuThread = null;
            this.submenu = null;
            this.clearLastMouseEvent();
        }
    }

    private void hideDescendants() {
        if (this.submenu != null) {
            this.submenu.hideDescendants();
        }
        this.setVisible(false);
    }

    private void hideAncestors() {
        if (this.parentMenu != null) {
            this.parentMenu.hideAncestors();
        }
        this.setVisible(false);
    }

    private void hideAll() {
        this.hideDescendants();
        this.hideAncestors();
    }

    public void show(Component invoker, int x, int y) {
        if (this.showThread != null) {
            this.showThread.abort();
        }
        this.showThread = new ShowThread(invoker, x, y);
        this.showThread.start();
    }

    public void showNow(Component invoker, int x, int y) {
        if (this.showThread != null) {
            this.showThread.abort();
        }
        this.showInternal(invoker, x, y);
    }

    private void showInternal(Component invoker, int x, int y) {
        PieMenu.enableSelect();
        PieMenu.updatePieMenuToCurrentMode(this);
        this.selected = -1;
        Container parent = null;
        Window parentWindow = null;
        if (invoker != null) {
            parent = invoker.getParent();
        }
        Point pt = invoker.getLocation();
        Container p = parent;
        while (p != null) {
            if (p instanceof JRootPane) {
                parent = ((JRootPane)p).getLayeredPane();
                p = parent.getParent();
                while (p != null && !(p instanceof Window)) {
                    p = p.getParent();
                }
                parentWindow = (Window)p;
                break;
            }
            if (p instanceof Window) {
                throw new RuntimeException("Sorry, Pie Menu does not work with non-Swing widgets yet");
            }
            Point ptTmp = p.getLocation();
            pt.x += ptTmp.x;
            pt.y += ptTmp.y;
            p = p.getParent();
        }
        super.setVisible(false);
        this.setLocation(this.fixPieLocationX(pt.x + x), this.fixPieLocationY(pt.y + y));
        if (parent instanceof JLayeredPane) {
            ((JLayeredPane)parent).add(this, JLayeredPane.POPUP_LAYER, 0);
        } else {
            parent.add(this);
        }
        this.parent = parent;
        this.flagCanAbortSubmenu = true;
        this.flagJustOpened = true;
        this.flagJustClosedSubmenu = false;
        this.flagDraggedInPieMenu = false;
        if (this.showThread != null) {
            this.showThread.abort();
            this.showThread = null;
        }
        if (this.submenuThread != null) {
            this.submenuThread.abort();
            this.submenuThread = null;
            this.submenu = null;
        }
        this.setVisible(true);
    }

    public void setLocation(Point pt) {
        this.setLocation(pt.x, pt.y);
    }

    public void setLocation(int x, int y) {
        super.setLocation(x - this.radius, y - this.radius);
        this.setBigRadius(this.radius);
        this.updateShape();
    }

    private void repaintBounds() {
        if (this.parent == null) {
            return;
        }
        Point pt = this.getLocation();
        Rectangle rect = this.getBounds();
        this.parent.repaint(rect.x, rect.y, rect.width, rect.height);
    }

    protected void renderString(Graphics2D gg, int xx, int yy, String str, double angle, double radius, boolean enabled) {
        Point pt = new Point();
        FontMetrics fmetric = this.getFontMetrics(this.getFont());
        float height = fmetric.getHeight();
        this.polarToCartesian(xx, yy, angle, radius * this.scalingFactor, pt);
        Point m_pt = new Point();
        this.polarToCartesian(xx, yy, angle, radius * this.scalingFactor, m_pt);
        m_pt.x += 100;
        m_pt.y += 100;
        StringTokenizer strtok = new StringTokenizer(str, "\r\n\t");
        int offset = 0;
        pt.y -= (int)((float)(strtok.countTokens() - 1) / 2.0f * height);
        while (strtok.hasMoreTokens()) {
            String token = strtok.nextToken();
            float width = fmetric.stringWidth(token);
            double orientation = this.findAngle(angle);
            if (orientation == 1.0) {
                m_pt.y = (int)(-100.0 * Math.sin(angle));
            }
            if (enabled) {
                gg.setColor(this.getFontColor());
                gg.drawString(token, (int)((double)pt.x - 0.5 * (double)width), (int)((double)pt.y + 0.5 * (double)height) + offset);
            } else {
                gg.setColor(this.getFillColor().darker());
                gg.drawString(token, (int)((double)pt.x - 0.5 * (double)width), (int)((double)pt.y + 0.5 * (double)height) + offset);
            }
            offset = (int)((float)offset + height);
        }
    }

    private int findAngle(double angle) {
        double newAngle = angle % (Math.PI * 2);
        if (newAngle > 0.7853981633974483 && newAngle < 2.356194490192345) {
            return 1;
        }
        if (newAngle < 0.7853981633974483 && newAngle > 0.0) {
            return 2;
        }
        if (newAngle > 5.497787143782138) {
            return 5;
        }
        if (newAngle < 5.497787143782138 && newAngle > 3.9269908169872414) {
            return 3;
        }
        if (newAngle < Math.PI && newAngle > 2.356194490192345) {
            return 4;
        }
        if (newAngle < 3.9269908169872414 && newAngle > Math.PI) {
            return 6;
        }
        return 1;
    }

    protected void renderIcon(Graphics2D gg, int xx, int yy, Icon icon, double angle, double radius, boolean enabled) {
        Point pt = new Point();
        this.polarToCartesian(xx, yy, angle, radius * this.scalingFactor, pt);
        BufferedImage img = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 5);
        Graphics img_g = img.getGraphics();
        icon.paintIcon(this, img_g, 0, 0);
        double scale = 1.0;
        int drawX = (int)((double)pt.x - 0.5 * scale * (double)icon.getIconWidth());
        int drawY = (int)((double)pt.y - 0.5 * scale * (double)icon.getIconHeight());
        gg.drawImage((Image)img, drawX, drawY, null);
    }

    protected void renderSubmenuIcon(Graphics2D gg, int xx, int yy, Image img, double angle, double radius) {
        Point pt = new Point();
        this.polarToCartesian(xx, yy, angle, radius * 0.9, pt);
        AffineTransform txOld = (AffineTransform)gg.getTransform().clone();
        AffineTransform txNew = (AffineTransform)gg.getTransform().clone();
        txNew.concatenate(AffineTransform.getTranslateInstance(pt.x, pt.y));
        txNew.concatenate(AffineTransform.getRotateInstance(-angle + 1.5707963267948966));
        gg.setTransform(txNew);
        gg.drawImage(img, (int)(-0.5 * (double)img.getWidth(null)), (int)(-0.5 * (double)img.getHeight(null)), null);
        gg.setTransform(txOld);
    }

    private String getItemText(Object obj, int pos) {
        int selectedItem = this.getSelectedItem();
        String text = null;
        if (obj instanceof JMenuItem) {
            JMenuItem menuitem = (JMenuItem)obj;
            text = menuitem.getText();
        } else {
            PieMenu pie = (PieMenu)obj;
            text = pie.getText();
        }
        return text;
    }

    private Icon getItemIcon(Object obj, int pos) {
        int selectedItem = this.getSelectedItem();
        Icon icon = null;
        if (obj instanceof JMenuItem) {
            JMenuItem menuitem = (JMenuItem)obj;
            icon = selectedItem == pos ? menuitem.getPressedIcon() : menuitem.getIcon();
        } else {
            PieMenu pie = (PieMenu)obj;
            icon = pie.getIcon();
        }
        return icon;
    }

    public void paintComponent(Graphics g) {
        Graphics2D gg = (Graphics2D)g;
        Color oldc = g.getColor();
        if (PieMenu.getAllClipping()) {
            gg.setClip(this.clipCircle);
        }
        RenderingHints oldHints = gg.getRenderingHints();
        gg.setRenderingHints(this.newHints);
        gg.setStroke(this.stroke);
        gg.setPaintMode();
        int selectedItem = this.getSelectedItem();
        int defaultSelectedItem = this.getDefaultSelectedItem();
        int numItems = this.getItemCount();
        if (numItems <= 0) {
            gg.setColor(this.getFillColor());
            gg.fillOval(0, 0, 2 * this.radius, 2 * this.radius);
        } else {
            double stepRadian = Math.PI * 2 / (double)numItems;
            double currentRadian = this.getStartRadian();
            Shape oldClip = null;
            gg.setColor(this.getLineColor());
            int i = 0;
            while (i < numItems) {
                Arc2D.Float arc = new Arc2D.Float(0.0f, 0.0f, 2 * this.radius, 2 * this.radius, (float)Math.toDegrees(currentRadian), (float)Math.toDegrees(stepRadian), 2);
                if (selectedItem == i) {
                    gg.setColor(this.getSelectedColor());
                    gg.fill(arc);
                } else {
                    gg.setColor(this.getFillColor());
                    gg.fill(arc);
                    if (defaultSelectedItem == i) {
                        gg.setColor(this.defaultSelectedItemColor);
                        gg.fill(arc);
                    }
                }
                gg.setColor(this.lineColor);
                JComponent item = (JComponent)this.list.get(i);
                String text = this.getItemText(item, i);
                Icon icon = this.getItemIcon(item, i);
                if (item instanceof PieMenu) {
                    this.renderSubmenuIcon(gg, this.radius, this.radius, this.getSubmenuIcon(), currentRadian + 0.5 * stepRadian, this.radius);
                }
                if (PieMenu.getAllClipping()) {
                    oldClip = gg.getClip();
                    gg.setClip(arc);
                }
                if (icon == null) {
                    this.renderString(gg, this.radius, this.radius, text, currentRadian + 0.5 * stepRadian, this.radius, item.isEnabled());
                } else {
                    this.renderIcon(gg, this.radius, this.radius, icon, currentRadian + 0.5 * stepRadian, this.radius, item.isEnabled());
                }
                if (PieMenu.getAllClipping()) {
                    gg.setClip(oldClip);
                }
                gg.setColor(this.getLineColor());
                if (numItems > 1) {
                    gg.draw(arc);
                }
                currentRadian += stepRadian;
                ++i;
            }
        }
        gg.setColor(this.getFillColor());
        gg.fill(this.smallCircle);
        if (selectedItem < 0) {
            gg.setColor(this.getSelectedColor());
            gg.fill(this.smallCircle);
        }
        gg.setColor(this.getLineColor());
        gg.draw(this.smallCircle);
        gg.setColor(this.getLineColor());
        gg.drawOval(0, 0, 2 * this.radius, 2 * this.radius);
        gg.setRenderingHints(oldHints);
        gg.setColor(oldc);
    }

    protected Image getSubmenuIcon() {
        if (this.submenuIconImage == null) {
            int width = 10;
            int height = 10;
            this.submenuIconImage = new BufferedImage(width, height, 2);
            Graphics g = this.submenuIconImage.getGraphics();
            Polygon p = new Polygon();
            p.addPoint(0, height);
            p.addPoint(width / 2, 0);
            p.addPoint(width, height);
            g.setColor(new Color(0, 0, 255, 0));
            g.fillRect(0, 0, width, height);
            g.setColor(Color.black);
            g.fillPolygon(p);
        }
        return this.submenuIconImage;
    }

    public String toString() {
        return this.strText;
    }

    final class JMenuItemWrapper
    extends JMenuItem {
        public JMenuItemWrapper() {
        }

        public JMenuItemWrapper(Icon icon) {
            super(icon);
        }

        public JMenuItemWrapper(String text) {
            super(text);
        }

        public JMenuItemWrapper(String text, Icon icon) {
            super(text, icon);
        }

        public JMenuItemWrapper(String text, int mnemonic) {
            super(text, mnemonic);
        }

        public void fireActionPerformed(ActionEvent evt) {
            super.fireActionPerformed(evt);
        }
    }

    final class BlinkTimer
    extends Timer {
        public BlinkTimer() {
            super(20, null);
            this.addActionListener(PieMenu.this.blinkListener);
            this.setInitialDelay(0);
            PieMenu.this.tmpFillColor = PieMenu.this.getFillColor();
            PieMenu.this.tmpSelectedColor = PieMenu.this.getSelectedColor();
        }

        public void start() {
            PieMenu.this.flagDone = false;
            PieMenu.this.count = 0;
            PieMenu.disableSelect();
            super.start();
        }

        public void stop() {
            PieMenu.this.selectedColor = PieMenu.this.tmpSelectedColor;
            PieMenu.this.repaint();
            super.stop();
            PieMenu.this.flagDone = true;
        }

        public boolean isDone() {
            return PieMenu.this.flagDone;
        }
    }

    final class BlinkActionListener
    implements ActionListener,
    Serializable {
        BlinkActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            if (PieMenu.this.count > 2) {
                PieMenu.this.timer.stop();
                return;
            }
            PieMenu.this.selectedColor = PieMenu.this.getSelectedColor() == PieMenu.this.tmpFillColor ? PieMenu.this.tmpSelectedColor : PieMenu.this.tmpFillColor;
            PieMenu.this.repaint();
            ++PieMenu.this.count;
        }
    }

    final class PopupMenuCallback
    implements PopupMenuListener,
    Serializable {
        PopupMenuCallback() {
        }

        public void popupMenuCanceled(PopupMenuEvent evt) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
            if (PieMenu.this.submenu != null && PieMenu.this.submenu.isShowing()) {
                PieMenu.this.submenu = null;
                PieMenu.this.submenuThread = null;
            }
            PieMenu.this.flagJustClosedSubmenu = true;
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            PieMenu.this.timer.stop();
        }
    }

    abstract class DelayThread
    extends Thread {
        long ms;
        boolean flagContinue = true;
        boolean flagDone = false;

        public DelayThread(long ms) {
            this.ms = ms;
            this.setPriority(1);
        }

        public void abort() {
            this.flagContinue = false;
        }

        public boolean isDone() {
            return this.flagDone;
        }

        public final void spin(long ms) {
            try {
                Thread.yield();
                Thread.sleep(ms);
                Thread.yield();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public final void run() {
            this.spin(this.ms);
            if (this.flagContinue) {
                this.doit();
            }
            this.flagDone = true;
            if (!this.flagContinue) {
                this.undo();
            }
        }

        public abstract void doit();

        public void undo() {
        }
    }

    final class ShowThread
    extends DelayThread {
        Component c;
        int x;
        int y;

        public ShowThread(Component c, int x, int y) {
            this(c, x, y, PieMenu.getAllInitialDelay());
        }

        public ShowThread(Component c, int x, int y, long ms) {
            super(ms);
            this.c = c;
            this.x = x;
            this.y = y;
        }

        public void setShowLocation(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void doit() {
            while (!PieMenu.this.timer.isDone()) {
                this.spin(50L);
            }
            PieMenu.this.showInternal(this.c, this.x, this.y);
            PieMenu.this.forwardLastEvent();
        }
    }

    final class CancelPieMenuThread
    extends DelayThread {
        JMenuItemWrapper item;
        ActionEvent evt;

        public CancelPieMenuThread(long ms) {
            super(ms);
        }

        public CancelPieMenuThread(long ms, JMenuItemWrapper item, ActionEvent evt) {
            super(ms);
            this.item = item;
            this.evt = evt;
        }

        public void doit() {
            while (!PieMenu.this.timer.isDone()) {
                this.spin(50L);
            }
            PieMenu.this.firePopupMenuWillBecomeInvisible();
            if (this.item != null && this.item.isEnabled()) {
                PieMenu.this.hideAll();
            } else {
                PieMenu.this.firePopupMenuCanceled();
            }
            if (this.item != null && this.item.isEnabled()) {
                this.item.fireActionPerformed(this.evt);
            }
        }
    }

    final class ShowSubmenuThread
    extends DelayThread {
        PieMenu pm;
        int x;
        int y;

        public ShowSubmenuThread(PieMenu pm, int x, int y) {
            super(PieMenu.getAllSubmenuDelay());
            this.pm = pm;
            this.x = x;
            this.y = y;
        }

        public ShowSubmenuThread(PieMenu pm, int pos) {
            super(PieMenu.getAllSubmenuDelay());
            this.pm = pm;
            Point pt = new Point();
            Point ptPie = PieMenu.this.getLocation();
            double current = PieMenu.this.getStartRadian();
            double stepRadian = Math.PI * 2 / (double)PieMenu.this.getItemCount();
            double angle = current + (0.5 + (double)pos) * stepRadian;
            PieMenu.this.polarToCartesian(PieMenu.this.radius, PieMenu.this.radius, angle, (double)PieMenu.this.radius * PieMenu.this.scalingFactor, pt);
            this.x = ptPie.x + pt.x;
            this.y = ptPie.y + pt.y;
        }

        public void abort() {
            super.abort();
            this.pm.setVisible(false);
        }

        public void setShowLocation(int x, int y) {
            this.x = x;
            this.y = y;
        }

        /*
         * Unable to fully structure code
         */
        public void doit() {
            if (PieMenu.this.submenu != null) ** GOTO lbl4
            return;
lbl-1000:
            // 1 sources

            {
                this.spin(50L);
lbl4:
                // 2 sources

                ** while (!PieMenu.this.timer.isDone())
            }
lbl5:
            // 1 sources

            PieMenu.access$1(this.pm, PieMenu.this.getComponent(), this.x, this.y);
            this.pm.addPopupMenuListener(new PopupMenuCallback());
            PieMenu.this.flagDraggedInPieMenu = false;
        }

        public void undo() {
            if (!this.flagContinue) {
                this.pm.setVisible(false);
            }
        }
    }

    final class ItemListener
    implements MouseListener,
    MouseMotionListener,
    ComponentListener,
    Serializable {
        int pressedX = 0;
        int pressedY = 0;
        int distX = 0;
        int distY = 0;

        ItemListener() {
        }

        private boolean hasTravelledTooFar() {
            return this.distX * this.distX + this.distY * this.distY > PieMenu.this.getSmallRadius() * PieMenu.this.getSmallRadius();
        }

        private void updateDistances(MouseEvent evt) {
            int dx = Math.abs(this.pressedX - evt.getX());
            int dy = Math.abs(this.pressedY - evt.getY());
            if (dx > this.distX) {
                this.distX = dx;
            }
            if (dy > this.distY) {
                this.distY = dy;
            }
        }

        public void mousePressed(MouseEvent evt) {
            PieMenu.this.clearLastMouseEvent();
            Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
            if (PieMenu.this.doesActivateMenu(evt)) {
                this.pressedX = evt.getX();
                this.pressedY = evt.getY();
                this.distX = 0;
                this.distY = 0;
                PieMenu.this.flagJustOpened = false;
                if (!PieMenu.this.isShowing() && (PieMenu.isDragOpen() || PieMenu.isTapHoldOpen())) {
                    PieMenu.this.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            } else {
                PieMenu.this.getActiveMenu().setSelectedItem(-1);
            }
        }

        public void mouseDragged(MouseEvent evt) {
            PieMenu.this.setLastMouseEvent(evt);
            if (PieMenu.this.submenu == null && !PieMenu.this.isShowing()) {
                PieMenu.this.updateShowLocation(evt.getX(), evt.getY());
                this.updateDistances(evt);
                if (PieMenu.isTapOpen() || PieMenu.isTapHoldOpen()) {
                    if (this.hasTravelledTooFar()) {
                        if (PieMenu.this.showThread != null) {
                            PieMenu.this.showThread.abort();
                            PieMenu.this.showThread = null;
                        }
                    } else {
                        evt.consume();
                    }
                }
                return;
            }
            evt = PieMenu.this.convertMouseEventSpace(evt);
            PieMenuHandler redispatcher = PieMenu.this.getDispatcher();
            redispatcher.handleMouseDragged(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            PieMenu.this.setLastMouseEvent(evt);
            if (PieMenu.this.submenu == null && !PieMenu.this.isShowing()) {
                if (PieMenu.this.doesActivateMenu(evt) && (PieMenu.isTapOpen() || PieMenu.isTapHoldOpen())) {
                    if (PieMenu.isTapOpen() && !this.hasTravelledTooFar()) {
                        PieMenu.this.clearLastMouseEvent();
                        PieMenu.this.show(evt.getComponent(), evt.getX(), evt.getY());
                    } else if (PieMenu.isTapHoldOpen() && PieMenu.this.showThread != null) {
                        PieMenu.this.showThread.abort();
                        PieMenu.this.showThread = null;
                    }
                }
                return;
            }
            if (PieMenu.this.isShowing() && PieMenu.isTapHoldOpen() && PieMenu.this.flagJustOpened) {
                evt.consume();
                return;
            }
            evt = PieMenu.this.convertMouseEventSpace(evt);
            PieMenuHandler redispatcher = PieMenu.this.getDispatcher();
            redispatcher.handleMouseReleased(evt);
        }

        public void mouseClicked(MouseEvent evt) {
            PieMenu.this.setLastMouseEvent(evt);
        }

        public void mouseMoved(MouseEvent evt) {
            this.mouseDragged(evt);
        }

        public void mouseEntered(MouseEvent evt) {
        }

        public void mouseExited(MouseEvent evt) {
        }

        public void componentHidden(ComponentEvent evt) {
        }

        public void componentMoved(ComponentEvent evt) {
        }

        public void componentShown(ComponentEvent evt) {
        }

        public void componentResized(ComponentEvent evt) {
            if (PieMenu.this.isShowing()) {
                PieMenu.this.hideAll();
            }
        }
    }

    final class PieMenuListener
    implements MouseListener,
    MouseMotionListener,
    Serializable {
        PieMenuListener() {
        }

        public final void mouseClicked(MouseEvent evt) {
        }

        public final void mouseExited(MouseEvent evt) {
        }

        public final void mouseEntered(MouseEvent evt) {
            evt.consume();
        }

        public final void mousePressed(MouseEvent evt) {
            evt.consume();
            PieMenu.this.flagJustOpened = false;
            PieMenu.this.setLastMouseEvent(evt);
            evt = PieMenu.this.convertMouseEventSpace(evt);
            PieMenuHandler redispatcher = PieMenu.this.getDispatcher();
            redispatcher.handleMousePressed(evt);
        }

        public final void mouseReleased(MouseEvent evt) {
            evt.consume();
            PieMenu.this.setLastMouseEvent(evt);
            evt = PieMenu.this.convertMouseEventSpace(evt);
            PieMenuHandler redispatcher = PieMenu.this.getDispatcher();
            redispatcher.handleMouseReleased(evt);
        }

        public final void mouseDragged(MouseEvent evt) {
            evt.consume();
            PieMenu.this.setLastMouseEvent(evt);
            evt = PieMenu.this.convertMouseEventSpace(evt);
            PieMenuHandler redispatcher = PieMenu.this.getDispatcher();
            redispatcher.handleMouseDragged(evt);
        }

        public final void mouseMoved(MouseEvent evt) {
            evt.consume();
            PieMenu.this.setLastMouseEvent(evt);
            evt = PieMenu.this.convertMouseEventSpace(evt);
            PieMenuHandler redispatcher = PieMenu.this.getDispatcher();
            redispatcher.handleMouseMoved(evt);
        }
    }

    final class PieMenuHandler
    implements Serializable {
        PieMenuHandler() {
        }

        private boolean mouseButtonIsDown(MouseEvent evt) {
            return SwingUtilities.isLeftMouseButton(evt) || SwingUtilities.isMiddleMouseButton(evt) || SwingUtilities.isRightMouseButton(evt);
        }

        private void handleMousePressed(MouseEvent evt) {
            evt.consume();
            PieMenu.this.flagJustOpened = false;
            PieMenu.this.setSelectedItem(PieMenu.this.getSliceNumber(evt.getX(), evt.getY()));
            if (this.maybeShowPieSubmenu(evt.getX(), evt.getY())) {
                PieMenu.this.flagCanAbortSubmenu = true;
            }
        }

        private void handleMouseReleased(MouseEvent evt) {
            evt.consume();
            if (PieMenu.this.flagJustOpened && PieMenu.isTapHoldOpen()) {
                PieMenu.this.flagJustOpened = false;
                return;
            }
            PieMenu.this.flagJustOpened = false;
            if (!(PieMenu.this.doesActivateMenu(evt) || PieMenu.this.flagDraggedInPieMenu || PieMenu.this.bigCircle.contains(evt.getX(), evt.getY()))) {
                PieMenu.this.firePopupMenuCanceled();
                PieMenu.this.setVisible(false);
                return;
            }
            int pos = PieMenu.this.getSliceNumber(evt.getX(), evt.getY());
            if (pos < 0) {
                PieMenu.this.firePopupMenuCanceled();
                PieMenu.this.hideDescendants();
                return;
            }
            this.maybeShowPieSubmenu(evt.getX(), evt.getY());
            PieMenu.this.flagCanAbortSubmenu = false;
            if (PieMenu.this.submenu != null) {
                if (!PieMenu.this.submenu.isEnabled()) {
                    PieMenu.this.submenu = null;
                    PieMenu.this.submenuThread = null;
                } else {
                    PieMenu.this.timer.start();
                }
                return;
            }
            JMenuItem item = PieMenu.this.getItem(pos);
            if (!item.isEnabled()) {
                return;
            }
            PieMenu.this.timer.start();
            ActionEvent fevt = new ActionEvent(this, 1001, item.getText());
            new CancelPieMenuThread(300L, (JMenuItemWrapper)item, fevt).start();
        }

        private void handleMouseDragged(MouseEvent evt) {
            evt.consume();
            if (PieMenu.this.bigCircle.contains(evt.getX(), evt.getY())) {
                PieMenu.this.flagDraggedInPieMenu = true;
            } else if (!PieMenu.this.flagDraggedInPieMenu && this.mouseButtonIsDown(evt) && !PieMenu.this.doesActivateMenu(evt)) {
                PieMenu.this.setSelectedItem(-1);
                return;
            }
            int selectedItem = PieMenu.this.getSliceNumber(evt.getX(), evt.getY());
            if (PieMenu.this.flagJustClosedSubmenu && selectedItem == PieMenu.this.submenuPos) {
                return;
            }
            PieMenu.this.setSelectedItem(selectedItem);
            if (selectedItem < 0) {
                return;
            }
            PieMenu.this.flagJustOpened = false;
            if (PieMenu.getAllRelocateSubmenus()) {
                Point pt = PieMenu.this.getLocation();
                int drawX = evt.getX() + pt.x;
                int drawY = evt.getY() + pt.y;
                PieMenu.this.updateShowLocation(drawX, drawY);
            }
            if (PieMenu.getAllAutoOpen() && this.maybeShowPieSubmenu(evt.getX(), evt.getY())) {
                PieMenu.this.flagCanAbortSubmenu = true;
            }
        }

        private void handleMouseMoved(MouseEvent evt) {
            evt.consume();
            this.handleMouseDragged(evt);
            PieMenu.this.flagDraggedInPieMenu = false;
        }

        private boolean maybeShowPieSubmenu(int x, int y) {
            PieMenu pm;
            if (!PieMenu.submenusAreEnabled()) {
                return false;
            }
            int pos = PieMenu.this.getSliceNumber(x, y);
            if (pos < 0) {
                return false;
            }
            if (PieMenu.this.submenu != null || PieMenu.this.submenuThread != null) {
                return false;
            }
            Object obj = PieMenu.this.list.get(pos);
            if (obj instanceof PieMenu && !(pm = (PieMenu)obj).isShowing()) {
                Point pt = PieMenu.this.getLocation();
                int drawX = x + pt.x;
                int drawY = y + pt.y;
                Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
                drawX = PieMenu.this.fixPieLocationX(drawX);
                drawY = PieMenu.this.fixPieLocationY(drawY);
                PieMenu.this.submenu = pm;
                PieMenu.this.submenu.parentMenu = PieMenu.this;
                PieMenu.this.submenuPos = pos;
                if (PieMenu.this.submenuThread != null) {
                    PieMenu.this.submenuThread.abort();
                }
                if (!PieMenu.this.submenu.isEnabled()) {
                    return false;
                }
                PieMenu.this.submenuThread = PieMenu.getAllRelocateSubmenus() ? new ShowSubmenuThread(pm, drawX, drawY) : new ShowSubmenuThread(pm, pos);
                PieMenu.this.submenuThread.start();
                return true;
            }
            return false;
        }
    }

    final class PolarCoordinate {
        public double radius;
        public double theta;

        public PolarCoordinate(double radius, double theta) {
            this.radius = radius;
            this.theta = theta;
        }

        public String toString() {
            return "[r: " + this.radius + ", theta: " + this.theta + "]";
        }
    }
}

