/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.widgets;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class JSatinComponent
extends JComponent
implements SatinConstants {
    GraphicalObject gob;
    SatinGraphics sg = new SatinGraphics();
    boolean flagIgnoreTranslation = true;

    public JSatinComponent(GraphicalObject newGob) {
        this(newGob, true);
    }

    public JSatinComponent(GraphicalObject newGob, boolean flagIgnoreTranslate) {
        this.gob = newGob;
        this.flagIgnoreTranslation = flagIgnoreTranslate;
        this.updateSize();
    }

    public void updateSize() {
        Rectangle2D bounds = this.gob.getBounds2D(12);
        Dimension dim = new Dimension();
        this.setBounds(0, 0, (int)bounds.getWidth() + 1, (int)bounds.getHeight() + 1);
        dim.width = (int)bounds.getWidth() + 1;
        dim.height = (int)bounds.getHeight() + 1;
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
        this.setMinimumSize(dim);
    }

    public void paintComponent(Graphics g) {
        AffineTransform tx;
        super.paintComponent(g);
        this.sg.setGraphics((Graphics2D)g);
        this.sg.pushStyle(this.gob.getStyleRef());
        if (this.flagIgnoreTranslation) {
            tx = this.gob.getTransform(11);
            tx.translate(-tx.getTranslateX(), -tx.getTranslateY());
        } else {
            tx = this.gob.getTransformRef();
        }
        this.sg.pushTransform(tx);
        this.gob.render(this.sg);
    }

    public static void main(String[] argv) {
        JFrame f = new JFrame("Test");
        TimedStroke stk1 = new TimedStroke();
        stk1.addPoint(0, 0);
        stk1.addPoint(10, 10);
        stk1.addPoint(10, 0);
        stk1.addPoint(0, 10);
        TimedStroke stk2 = new TimedStroke();
        stk2.addPoint(4, 12);
        stk2.addPoint(5, 40);
        stk2.addPoint(3, 68);
        stk2.addPoint(1, 88);
        stk2.addPoint(1, 104);
        stk2.addPoint(2, 115);
        stk2.addPoint(6, 117);
        stk2.addPoint(25, 114);
        stk2.addPoint(56, 106);
        stk2.addPoint(77, 101);
        stk2.addPoint(96, 99);
        stk2.addPoint(109, 99);
        stk2.addPoint(111, 89);
        stk2.addPoint(109, 67);
        stk2.addPoint(114, 43);
        stk2.addPoint(117, 26);
        stk2.addPoint(118, 16);
        stk2.addPoint(115, 6);
        stk2.addPoint(108, 1);
        stk2.addPoint(99, 0);
        stk2.addPoint(67, 4);
        stk2.addPoint(34, 11);
        stk2.addPoint(13, 17);
        stk2.addPoint(3, 20);
        stk2.addPoint(0, 23);
        stk2.moveBy(11, 100.0, 100.0);
        f.getContentPane().setLayout(new FlowLayout());
        JSatinComponent c = new JSatinComponent(stk1);
        f.getContentPane().add(c);
        f.getContentPane().add(new JButton("Hey"));
        f.getContentPane().add(new JButton("There"));
        c = new JSatinComponent(stk2);
        f.getContentPane().add(c);
        f.setSize(500, 500);
        f.setVisible(true);
        System.out.println(c);
    }
}

