/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.watch;

import edu.berkeley.guir.lib.collection.WeakHashSet;
import edu.berkeley.guir.lib.satin.watch.Watchable;
import edu.berkeley.guir.lib.satin.watch.Watcher;
import java.util.Iterator;

public class WatchableImpl
implements Watchable {
    static final long serialVersionUID = 4604130210793179861L;
    WeakHashSet watchers = new WeakHashSet();
    transient int enabledCount = 0;

    public Watcher addWatcher(Watcher w) {
        this.watchers.add(w);
        return w;
    }

    public int countWatchers() {
        return this.watchers.size();
    }

    public Watcher removeWatcher(Watcher w) {
        this.watchers.remove(w);
        return w;
    }

    public void clearWatchers() {
        this.watchers.clear();
    }

    public void disableNotify() {
        ++this.enabledCount;
    }

    public void enableNotify() {
        --this.enabledCount;
        if (this.enabledCount < 0) {
            throw new RuntimeException("Error - unbalanced number of disable/enable notify calls made");
        }
    }

    public boolean hasNotifyEnabled() {
        return this.enabledCount <= 0;
    }

    private void notify(NotifyStrategy strategy) {
        if (!this.hasNotifyEnabled()) {
            return;
        }
        Iterator it = this.watchers.iterator();
        while (it.hasNext()) {
            Watcher w = (Watcher)it.next();
            strategy.runNotify(w);
        }
    }

    private void notifyModify(NotifyStrategy strategy) {
        if (!this.hasNotifyEnabled()) {
            return;
        }
        WeakHashSet hashTmp = (WeakHashSet)this.watchers.clone();
        Iterator it = hashTmp.iterator();
        while (it.hasNext()) {
            Watcher w = (Watcher)it.next();
            strategy.runNotify(w);
        }
    }

    public void notifyWatchers() {
        throw new RuntimeException("Call one of the other notifyWatchers() methods instead");
    }

    public void notifyWatchers(Object arg) {
        throw new RuntimeException("Call one of the other notifyWatchers() methods instead");
    }

    public void notifyWatchers(Watchable watchable) {
        this.notifyWatchers(watchable, null);
    }

    public void notifyWatchers(Watchable watchable, Object arg) {
        this.notify(new NotifyGenericStrategy(watchable, arg));
    }

    public void notifyWatchersUpdate(Object arg) {
        throw new RuntimeException("Call one of the other notifyWatchersUpdate() methods instead");
    }

    public void notifyWatchersUpdate(String strProperty, Object oldVal, Object newVal) {
        throw new RuntimeException("Call one of the other notifyWatchersUpdate() methods instead");
    }

    public void notifyWatchersUpdate(Watchable watchable) {
        this.notify(new NotifyUpdateSingleStrategy(watchable, null));
    }

    public void notifyWatchersUpdate(Watchable watchable, Object arg) {
        this.notify(new NotifyUpdateSingleStrategy(watchable, arg));
    }

    public void notifyWatchersUpdate(Watchable watchable, String strProperty, Object oldVal, Object newVal) {
        this.notify(new NotifyUpdateMultiStrategy(watchable, strProperty, oldVal, newVal));
    }

    public void notifyWatchersDelete() {
        throw new RuntimeException("Call the other notifyWatchersDelete() method instead");
    }

    public void notifyWatchersDelete(Watchable watchable) {
        this.notifyModify(new NotifyDeleteStrategy(watchable));
    }

    public String toString() {
        StringBuffer strbuf = new StringBuffer();
        Iterator it = this.watchers.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            strbuf.append(obj.hashCode());
            strbuf.append(", ");
        }
        return strbuf.toString();
    }

    public Object clone() {
        WatchableImpl w = new WatchableImpl();
        w.watchers = (WeakHashSet)this.watchers.clone();
        return w;
    }

    static abstract class NotifyStrategy {
        NotifyStrategy() {
        }

        public abstract void runNotify(Watcher var1);
    }

    final class NotifyGenericStrategy
    extends NotifyStrategy {
        Watchable w;
        Object arg;

        public NotifyGenericStrategy(Watchable w, Object arg) {
            this.w = w;
            this.arg = arg;
        }

        public void runNotify(Watcher watcher) {
            watcher.onNotify(this.w, this.arg);
        }
    }

    final class NotifyUpdateSingleStrategy
    extends NotifyStrategy {
        Watchable w;
        Object arg;

        public NotifyUpdateSingleStrategy(Watchable w, Object arg) {
            this.w = w;
            this.arg = arg;
        }

        public void runNotify(Watcher watcher) {
            watcher.onUpdate(this.w, this.arg);
        }
    }

    final class NotifyUpdateMultiStrategy
    extends NotifyStrategy {
        Watchable w;
        String strProperty;
        Object oldVal;
        Object newVal;

        public NotifyUpdateMultiStrategy(Watchable w, String strProperty, Object oldVal, Object newVal) {
            this.w = w;
            this.strProperty = strProperty;
            this.oldVal = oldVal;
            this.newVal = newVal;
        }

        public void runNotify(Watcher watcher) {
            if (this.oldVal == this.newVal || this.oldVal.equals(this.newVal)) {
                return;
            }
            watcher.onUpdate(this.w, this.strProperty, this.oldVal, this.newVal);
        }
    }

    final class NotifyDeleteStrategy
    extends NotifyStrategy {
        Watchable w;

        public NotifyDeleteStrategy(Watchable w) {
            this.w = w;
        }

        public void runNotify(Watcher watcher) {
            watcher.onDelete(this.w);
        }
    }
}

