/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.view;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.view.View;
import edu.berkeley.guir.lib.satin.view.ViewImpl;
import edu.berkeley.guir.lib.util.StringLib;

public abstract class ViewWrapper
extends ViewImpl {
    View v;

    public ViewWrapper() {
    }

    public ViewWrapper(View v) {
        this.setView(v);
    }

    public ViewWrapper(ViewWrapper vw) {
        this.setAttachedGraphicalObject(vw.getAttachedGraphicalObject());
        this.setView((View)vw.getView().clone());
    }

    public View setView(View v) {
        this.v = v;
        v.setAttachedGraphicalObject(this.getAttachedGraphicalObject());
        return v;
    }

    public GraphicalObject setAttachedGraphicalObject(GraphicalObject newGob) {
        super.setAttachedGraphicalObject(newGob);
        if (this.v != null) {
            this.v.setAttachedGraphicalObject(newGob);
        }
        return newGob;
    }

    public void setBoundingPoints2DRef(Polygon2D p) {
        if (this.v != null) {
            this.v.setBoundingPoints2DRef(p);
        }
    }

    public Polygon2D getBoundingPoints2DRef() {
        return this.v.getBoundingPoints2DRef();
    }

    public View getView() {
        return this.v;
    }

    public String getName() {
        if (this.getView() == null) {
            return String.valueOf(super.getName()) + " - no view";
        }
        return String.valueOf(super.getName()) + " - " + this.v.getName();
    }

    protected ViewWrapper clone(ViewWrapper vw) {
        super.clone(vw);
        vw.v = (View)this.v.clone();
        vw.setBoundingPoints2DRef(this.getBoundingPoints2DRef());
        return vw;
    }

    public String toString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        strbuf.append(super.toString());
        strbuf.append("\nContained View:\n");
        strbuf.append(StringLib.indent(this.v.toString(), 3));
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }
}

