/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.view;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.view.View;
import edu.berkeley.guir.lib.util.StringLib;

public abstract class ViewImpl
implements View {
    static final long serialVersionUID = 4847550940120905079L;
    protected GraphicalObject gob;
    protected Polygon2D poly = new Polygon2D();
    private String strName = "unnamed";
    private boolean flagVisible = true;

    public void setBoundingPoints2DRef(Polygon2D p) {
        this.poly = p;
    }

    public GraphicalObject setAttachedGraphicalObject(GraphicalObject newGob) {
        this.gob = newGob;
        return newGob;
    }

    public String setName(String strName) {
        this.strName = strName;
        return strName;
    }

    public void setVisible(boolean flag) {
        this.flagVisible = flag;
    }

    public Polygon2D getBoundingPoints2DRef() {
        return this.poly;
    }

    public GraphicalObject getAttachedGraphicalObject() {
        return this.gob;
    }

    public String getName() {
        return this.strName;
    }

    public boolean isVisible() {
        return this.flagVisible && this.getViewDisplayValue() > 0.0f;
    }

    public String toString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        Polygon2D p = this.getBoundingPoints2DRef();
        strbuf.append("View Name:           " + this.getName());
        strbuf.append("\nCurrent bounding box:" + StringLib.toString(p.getBounds2D()));
        strbuf.append("\nCurrent bounds:      " + p);
        strbuf.append("\nflagVis:             " + this.flagVisible);
        strbuf.append("\nCurrent Display Val: ");
        if (this.getAttachedGraphicalObject() == null) {
            strbuf.append("Not attached");
        } else {
            strbuf.append(this.getViewDisplayValue());
        }
        strbuf.append("\nAttached GOb ID:     ");
        if (this.getAttachedGraphicalObject() == null) {
            strbuf.append("Not attached");
        } else {
            strbuf.append(this.getAttachedGraphicalObject().getUniqueID());
        }
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    public abstract Object clone();

    protected ViewImpl clone(ViewImpl v) {
        v.setAttachedGraphicalObject(this.getAttachedGraphicalObject());
        v.setVisible(this.isVisible());
        v.setBoundingPoints2DRef((Polygon2D)this.getBoundingPoints2DRef().clone());
        return v;
    }
}

