/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.view;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.satin.view.StickyViewWrapper;
import edu.berkeley.guir.lib.satin.view.View;
import java.awt.geom.AffineTransform;

public class StickyZViewWrapper
extends StickyViewWrapper {
    static final long serialVersionUID = -1212309582093653860L;
    double desiredScale = 1.0;

    public StickyZViewWrapper() {
    }

    public StickyZViewWrapper(View v) {
        super(v);
        this.setView(v);
        this.commonInitializations();
    }

    public StickyZViewWrapper(View v, double newScale) {
        super(v);
        this.setView(v);
        this.setDesiredScale(newScale);
    }

    public StickyZViewWrapper(View v, double newScale, double startScale, double endScale) {
        super(v);
        this.setView(v);
        this.setDesiredScale(newScale);
        this.setDisplayRange(startScale, endScale);
    }

    public StickyZViewWrapper(View v, double newScale, double fIn, double startScale, double endScale, double fOut) {
        super(v);
        this.setView(v);
        this.setDesiredScale(newScale);
        this.setDisplayRange(fIn, startScale, endScale, fOut);
    }

    private void commonInitializations() {
        this.setName("Sticky Z Wrapper");
    }

    protected AffineTransform getStickyTransform(AffineTransform txTmp) {
        this.getAttachedGraphicalObject().getTransform(12, txTmp);
        double curScale = AffineTransformLib.getScaleFactor(txTmp);
        double scale = this.desiredScale / curScale;
        txTmp.setToScale(scale, scale);
        return txTmp;
    }

    public double getDesiredScale() {
        return this.desiredScale;
    }

    public double setDesiredScale(double newScale) {
        this.desiredScale = newScale;
        return newScale;
    }

    public Object clone() {
        return this.clone(new StickyZViewWrapper());
    }

    protected StickyZViewWrapper clone(StickyZViewWrapper vw) {
        super.clone(vw);
        vw.desiredScale = this.desiredScale;
        return vw;
    }
}

