/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.view;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.satin.view.StickyViewWrapper;
import edu.berkeley.guir.lib.satin.view.View;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;

public class StickyXYViewWrapper
extends StickyViewWrapper {
    static final long serialVersionUID = 2772309583094858853L;
    double x;
    double y;

    public StickyXYViewWrapper() {
    }

    public StickyXYViewWrapper(View v) {
        super(v);
        this.setView(v);
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("Sticky XY Wrapper");
    }

    protected AffineTransform getStickyTransform(AffineTransform txTmp) {
        this.getAttachedGraphicalObject().getTransform(12, txTmp);
        Point2D pt = AffineTransformLib.getTranslateFactor(txTmp);
        double dx = this.x - pt.getX();
        double dy = this.y - pt.getY();
        txTmp.translate(dx, dy);
        return txTmp;
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Object clone() {
        return this.clone(new StickyXYViewWrapper());
    }

    protected StickyXYViewWrapper clone(StickyXYViewWrapper vw) {
        super.clone(vw);
        vw.x = this.x;
        vw.y = this.y;
        return vw;
    }
}

