/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.view;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.view.SemanticZoomViewWrapper;
import edu.berkeley.guir.lib.satin.view.View;
import java.awt.geom.AffineTransform;

public abstract class StickyViewWrapper
extends SemanticZoomViewWrapper {
    Polygon2D stickypoly = new Polygon2D();

    protected StickyViewWrapper() {
    }

    public StickyViewWrapper(View v) {
        super(v);
        this.setView(v);
    }

    protected Polygon2D getUnstickyBoundingPoints2DRef() {
        return super.getBoundingPoints2DRef();
    }

    public Polygon2D getBoundingPoints2DRef() {
        AffineTransform txTmp = (AffineTransform)SatinConstants.poolTx.getObject();
        this.getStickyTransform(txTmp);
        this.stickypoly.setToShape(super.getBoundingPoints2DRef());
        this.stickypoly.transform(txTmp);
        SatinConstants.poolTx.releaseObject(txTmp);
        return this.stickypoly;
    }

    protected abstract AffineTransform getStickyTransform(AffineTransform var1);

    public void render(SatinGraphics g) {
        AffineTransform txTmp = (AffineTransform)SatinConstants.poolTx.getObject();
        this.getStickyTransform(txTmp);
        g.pushTransform(txTmp);
        this.v.render(g);
        g.popTransform();
        SatinConstants.poolTx.releaseObject(txTmp);
    }

    protected StickyViewWrapper clone(StickyViewWrapper vw) {
        super.clone(vw);
        return vw;
    }
}

