/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.view;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.satin.view.StickyViewWrapper;
import edu.berkeley.guir.lib.satin.view.View;
import java.awt.geom.AffineTransform;

public class StickyRViewWrapper
extends StickyViewWrapper {
    static final long serialVersionUID = -8663846670040591126L;

    public StickyRViewWrapper() {
        this.commonInitializations();
    }

    public StickyRViewWrapper(View v) {
        super(v);
        this.setView(v);
        this.commonInitializations();
    }

    public StickyRViewWrapper(StickyRViewWrapper v) {
        super((View)v);
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("Sticky R Wrapper");
    }

    protected AffineTransform getStickyTransform(AffineTransform txTmp) {
        this.getAttachedGraphicalObject().getTransform(12, txTmp);
        double theta = AffineTransformLib.getRotationFactor(txTmp);
        txTmp.setToRotation(-theta);
        return txTmp;
    }

    public Object clone() {
        return this.clone(new StickyRViewWrapper());
    }

    protected StickyRViewWrapper clone(StickyRViewWrapper vw) {
        super.clone(vw);
        return vw;
    }
}

