/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.view;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.view.StickyViewWrapper;
import edu.berkeley.guir.lib.satin.view.View;
import java.awt.geom.AffineTransform;

public class StickyAllViewWrapper
extends StickyViewWrapper {
    static final long serialVersionUID = 2772309582093858853L;
    double x;
    double y;

    public StickyAllViewWrapper() {
        this.commonInitializations();
    }

    public StickyAllViewWrapper(View v) {
        super(v);
        this.setView(v);
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("Sticky All Wrapper");
    }

    protected AffineTransform getStickyTransform(AffineTransform txTmp) {
        this.getAttachedGraphicalObject().getInverseTransform(12, txTmp);
        txTmp.translate(this.x, this.y);
        return txTmp;
    }

    public void setLocation(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public void render(SatinGraphics g) {
        AffineTransform txTmp = (AffineTransform)SatinConstants.poolTx.getObject();
        g.ignoreTransforms();
        txTmp.setToTranslation(this.x, this.y);
        g.transform(txTmp);
        this.v.render(g);
        SatinConstants.poolTx.releaseObject(txTmp);
        g.dontIgnoreTransforms();
    }

    public Object clone() {
        return this.clone(new StickyAllViewWrapper());
    }

    protected StickyAllViewWrapper clone(StickyAllViewWrapper vw) {
        super.clone(vw);
        vw.x = this.x;
        vw.y = this.y;
        return vw;
    }
}

