/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.view;

import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectLib;
import edu.berkeley.guir.lib.satin.view.SemanticZoomView;
import edu.berkeley.guir.lib.satin.view.View;
import edu.berkeley.guir.lib.satin.view.ViewWrapper;
import edu.berkeley.guir.lib.util.StringLib;

public class SemanticZoomViewWrapper
extends ViewWrapper
implements SemanticZoomView {
    static final long serialVersionUID = 2087432905825712779L;
    double fadeIn = 0.0;
    double startScale = 0.0;
    double endScale = Double.MAX_VALUE;
    double fadeOut = Double.MAX_VALUE;

    public SemanticZoomViewWrapper() {
        this.commonInitializations();
    }

    public SemanticZoomViewWrapper(View v) {
        this.setView(v);
        this.commonInitializations();
    }

    public SemanticZoomViewWrapper(View v, double start, double end) {
        this.setView(v);
        this.setDisplayRange(start, end);
        this.commonInitializations();
    }

    public SemanticZoomViewWrapper(View v, double fIn, double s, double e, double fOut) {
        this.setView(v);
        this.setDisplayRange(fIn, s, e, fOut);
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("Semantic Zoom Wrapper");
    }

    public void setDisplayRange(double fadeIn, double startScale, double endScale, double fadeOut) {
        if (fadeIn < 0.0 || startScale < 0.0 || endScale < 0.0 || fadeOut < 0.0) {
            throw new IllegalArgumentException("Scale values should be strictly positive");
        }
        if (!(fadeIn <= startScale && startScale <= endScale && endScale <= fadeOut)) {
            throw new IllegalArgumentException("Scale values must be increasing from left to right (ie fadeIn <= startScale <= endScale <= fadeOut)");
        }
        this.fadeIn = fadeIn;
        this.startScale = startScale;
        this.endScale = endScale;
        this.fadeOut = fadeOut;
    }

    public void setDisplayRange(double startScale, double endScale) {
        this.setDisplayRange(startScale, startScale, endScale, endScale);
    }

    public double getFadeIn() {
        return this.fadeIn;
    }

    public double getStartScale() {
        return this.startScale;
    }

    public double getEndScale() {
        return this.endScale;
    }

    public double getFadeOut() {
        return this.fadeOut;
    }

    protected double getScaleFactor() {
        double scale = GraphicalObjectLib.getScaleFactor(12, this.getAttachedGraphicalObject());
        return scale;
    }

    public float getViewDisplayValue() {
        double scale = this.getScaleFactor();
        if (scale < this.fadeIn || scale > this.fadeOut) {
            return 0.0f;
        }
        if (this.startScale <= scale && scale <= this.endScale) {
            return 1.0f;
        }
        double s = scale < this.startScale ? (scale - this.fadeIn) / (this.startScale - this.fadeIn) : (this.fadeOut - scale) / (this.fadeOut - this.endScale);
        if (s < 0.001) {
            return 0.0f;
        }
        return (float)s;
    }

    public String toString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        strbuf.append(super.toString());
        strbuf.append("\nBounding Box:        " + StringLib.toString(this.getBoundingPoints2DRef().getBounds2D()));
        strbuf.append("\nFadeIn:              " + this.getFadeIn());
        strbuf.append("\nStart Val:           " + this.getStartScale());
        strbuf.append("\nEnd Val:             " + this.getEndScale());
        strbuf.append("\nFadeOut:             " + this.getFadeOut());
        strbuf.append("\nCur Absolute Scale:  ");
        if (this.getAttachedGraphicalObject() == null) {
            strbuf.append("not attached");
        } else {
            strbuf.append(this.getScaleFactor());
            strbuf.append("\nAttached Gob:        " + this.getAttachedGraphicalObject().getClass() + this.getAttachedGraphicalObject().getUniqueID());
            strbuf.append("\nRel transform:       " + this.getAttachedGraphicalObject().getTransform(11));
            strbuf.append("\nAbs transform:       " + this.getAttachedGraphicalObject().getTransform(12));
            if (this.getAttachedGraphicalObject().getParentGroup() != null) {
                strbuf.append("\nParent Rel transform:" + this.getAttachedGraphicalObject().getParentGroup().getTransform(11));
                strbuf.append("\nParent Abs transform:" + this.getAttachedGraphicalObject().getParentGroup().getTransform(12));
            }
            if (this.getAttachedGraphicalObject().getSheet() != null) {
                strbuf.append("\nSheet Rel transform: " + this.getAttachedGraphicalObject().getSheet().getTransform(11));
                strbuf.append("\nSheet Abs transform: " + this.getAttachedGraphicalObject().getSheet().getTransform(12));
            }
        }
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    public void render(SatinGraphics g) {
        this.v.render(g);
    }

    public Object clone() {
        return this.clone(new SemanticZoomViewWrapper());
    }

    protected SemanticZoomViewWrapper clone(SemanticZoomViewWrapper vw) {
        super.clone(vw);
        vw.fadeIn = this.fadeIn;
        vw.startScale = this.startScale;
        vw.endScale = this.endScale;
        vw.fadeOut = this.fadeOut;
        return vw;
    }
}

