/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.view;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.view.SemanticZoomView;
import edu.berkeley.guir.lib.satin.view.ViewImpl;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.geom.AffineTransform;

public abstract class SemanticZoomViewImpl
extends ViewImpl
implements SemanticZoomView {
    static final long serialVersionUID = -7683529812197365412L;
    double fadeIn = 0.0;
    double startScale = 0.0;
    double endScale = Double.MAX_VALUE;
    double fadeOut = Double.MAX_VALUE;

    public SemanticZoomViewImpl() {
        this.commonInitializations();
    }

    public SemanticZoomViewImpl(double start, double end) {
        this.setDisplayRange(start, end);
        this.commonInitializations();
    }

    public SemanticZoomViewImpl(double fIn, double s, double e, double fOut) {
        this.setDisplayRange(fIn, s, e, fOut);
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("Semantic Zoom View");
    }

    public void setDisplayRange(double fadeIn, double startScale, double endScale, double fadeOut) {
        if (fadeIn < 0.0 || startScale < 0.0 || endScale < 0.0 || fadeOut < 0.0) {
            throw new IllegalArgumentException("Scale values should be strictly positive");
        }
        if (!(fadeIn <= startScale && startScale <= endScale && endScale <= fadeOut)) {
            throw new IllegalArgumentException("Scale values must be increasing from left to right (ie fadeIn <= startScale <= endScale <= fadeOut)");
        }
        this.fadeIn = fadeIn;
        this.startScale = startScale;
        this.endScale = endScale;
        this.fadeOut = fadeOut;
    }

    public void setDisplayRange(double startScale, double endScale) {
        this.setDisplayRange(startScale, startScale, endScale, endScale);
    }

    public double getFadeIn() {
        return this.fadeIn;
    }

    public double getStartScale() {
        return this.startScale;
    }

    public double getEndScale() {
        return this.endScale;
    }

    public double getFadeOut() {
        return this.fadeOut;
    }

    private final double getAbsoluteScaleFactor() {
        AffineTransform txTmp = (AffineTransform)SatinConstants.poolTx.getObject();
        this.getAttachedGraphicalObject().getTransform(12, txTmp);
        double scale = AffineTransformLib.getScaleFactor(txTmp);
        SatinConstants.poolTx.releaseObject(txTmp);
        return scale;
    }

    public float getViewDisplayValue() {
        double scale = this.getAbsoluteScaleFactor();
        if (scale < this.fadeIn || scale > this.fadeOut) {
            return 0.0f;
        }
        if (this.startScale <= scale && scale <= this.endScale) {
            return 1.0f;
        }
        if (scale < this.startScale) {
            return (float)((scale - this.fadeIn) / (this.startScale - this.fadeIn));
        }
        return (float)((this.fadeOut - scale) / (this.fadeOut - this.endScale));
    }

    protected SemanticZoomViewImpl clone(SemanticZoomViewImpl v) {
        super.clone(v);
        v.fadeIn = this.fadeIn;
        v.startScale = this.startScale;
        v.endScale = this.endScale;
        v.fadeOut = this.fadeOut;
        return v;
    }

    public String toString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        strbuf.append(super.toString());
        strbuf.append("\nBounding box:        " + StringLib.toString(this.getBoundingPoints2DRef().getBounds2D()));
        strbuf.append("\nFadeIn:              " + this.fadeIn);
        strbuf.append("\nStart Val:           " + this.startScale);
        strbuf.append("\nEnd Val:             " + this.endScale);
        strbuf.append("\nFadeOut:             " + this.fadeOut);
        strbuf.append("\nCur Absolute Scale:  ");
        if (this.getAttachedGraphicalObject() == null) {
            strbuf.append("not attached");
        } else {
            strbuf.append(this.getAbsoluteScaleFactor());
        }
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }
}

