/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.view;

import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.view.DefaultMultiViewImpl;
import edu.berkeley.guir.lib.satin.view.SemanticZoomView;
import edu.berkeley.guir.lib.satin.view.SemanticZoomViewWrapper;
import edu.berkeley.guir.lib.satin.view.View;
import java.util.Iterator;

public class SemanticZoomMultiViewImpl
extends DefaultMultiViewImpl {
    static final long serialVersionUID = -6368648157879758229L;

    public SemanticZoomMultiViewImpl() {
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("SemanticZoomMultiViewImpl");
    }

    public View add(View v) {
        if (v instanceof SemanticZoomView) {
            super.add(v);
        } else {
            v = new SemanticZoomViewWrapper(v);
            super.add(v);
        }
        return v;
    }

    public void render(SatinGraphics g) {
        Iterator it = this.getValidViews();
        while (it.hasNext()) {
            View v = (View)it.next();
            float t = v.getViewDisplayValue();
            if (!((double)t > 0.001)) continue;
            g.setTransparency(t);
            v.render(g);
            g.setTransparency(1.0f);
        }
    }

    public Object clone() {
        return this.clone(new SemanticZoomMultiViewImpl());
    }

    protected SemanticZoomMultiViewImpl clone(SemanticZoomMultiViewImpl vm) {
        super.clone(vm);
        return vm;
    }
}

