/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.view;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.view.DefaultMultiViewImpl;
import edu.berkeley.guir.lib.satin.view.View;
import java.util.Iterator;
import java.util.LinkedList;

public class MultiplexedMultiViewImpl
extends DefaultMultiViewImpl {
    static final long serialVersionUID = 3427621134004369722L;
    View currentView = null;
    int currentIndex = 0;

    public MultiplexedMultiViewImpl() {
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("MultiplexedMultiViewImpl");
    }

    public View add(View v) {
        super.add(v);
        if (this.currentView == null) {
            this.currentView = v;
        }
        return v;
    }

    public void setCurrent(int index) {
        this.currentIndex = index;
        this.currentView = this.get(index);
    }

    public void setCurrent(View v) {
        if (!this.contains(v)) {
            throw new RuntimeException("Does not contain this view");
        }
        this.currentView = v;
    }

    public Polygon2D getBoundingPoints2DRef() {
        return this.currentView.getBoundingPoints2DRef();
    }

    protected Iterator getValidViews() {
        LinkedList<View> list = new LinkedList<View>();
        list.add(this.currentView);
        return list.iterator();
    }

    public boolean isVisible() {
        return this.currentView.isVisible();
    }

    public void render(SatinGraphics g) {
        if (this.currentView != null) {
            this.currentView.render(g);
        }
    }

    public Object clone() {
        return this.clone(new MultiplexedMultiViewImpl());
    }

    protected MultiplexedMultiViewImpl clone(MultiplexedMultiViewImpl vm) {
        super.clone(vm);
        vm.setCurrent(this.currentIndex);
        return vm;
    }
}

