/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.view;

import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObject;
import edu.berkeley.guir.lib.satin.view.MultiView;
import edu.berkeley.guir.lib.satin.view.View;
import edu.berkeley.guir.lib.satin.view.ViewImpl;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public class DefaultMultiViewImpl
extends ViewImpl
implements MultiView {
    static final long serialVersionUID = 3427621134004369722L;
    LinkedList listViews = new LinkedList();
    Comparator comp = new ViewComparator();

    public DefaultMultiViewImpl() {
        this.commonInitializations();
    }

    private void commonInitializations() {
        this.setName("DefaultMultiViewImpl");
    }

    public void setBoundingPoints2DRef(Polygon2D p) {
        Iterator it = this.listViews.iterator();
        while (it.hasNext()) {
            View v = (View)it.next();
            v.setBoundingPoints2DRef(p);
        }
    }

    public GraphicalObject setAttachedGraphicalObject(GraphicalObject gob) {
        super.setAttachedGraphicalObject(gob);
        Iterator it = this.listViews.iterator();
        while (it.hasNext()) {
            View v = (View)it.next();
            v.setAttachedGraphicalObject(gob);
        }
        return gob;
    }

    public View add(View v) {
        this.listViews.add(v);
        v.setAttachedGraphicalObject(this.gob);
        return v;
    }

    public View remove(View v) {
        this.listViews.remove(v);
        return v;
    }

    public void clear() {
        this.listViews.clear();
    }

    public Polygon2D getBoundingPoints2DRef() {
        Polygon2D p;
        Rectangle2D r = (Rectangle2D)SatinConstants.poolRects.getObject();
        boolean flagFirst = true;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            View v = (View)it.next();
            if ((double)v.getViewDisplayValue() <= 0.0) continue;
            p = v.getBoundingPoints2DRef();
            Rectangle2D rtmp = p.getBounds2D();
            if (flagFirst) {
                flagFirst = false;
                r.setRect(rtmp);
                continue;
            }
            Rectangle2D.union(r, rtmp, r);
        }
        p = super.getBoundingPoints2DRef();
        p.setToShape(r);
        SatinConstants.poolRects.releaseObject(r);
        return p;
    }

    public Iterator iterator() {
        this.sortViewsByDisplayValue();
        return this.listViews.iterator();
    }

    public View get(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return (View)this.listViews.get(index);
    }

    public boolean contains(View v) {
        return this.listViews.contains(v);
    }

    public int size() {
        return this.listViews.size();
    }

    protected Iterator getValidViews() {
        this.sortViewsByDisplayValue();
        int i = 0;
        while (i < this.listViews.size()) {
            View v = (View)this.listViews.get(i);
            if (v.getViewDisplayValue() <= 0.0f) {
                return this.listViews.subList(0, i).iterator();
            }
            ++i;
        }
        return this.listViews.iterator();
    }

    public float getViewDisplayValue() {
        return 1.0f;
    }

    public boolean isVisible() {
        Iterator it = this.listViews.iterator();
        while (it.hasNext()) {
            View v = (View)it.next();
            if (!v.isVisible()) continue;
            return true;
        }
        return false;
    }

    protected void sortViewsByDisplayValue() {
        int size = this.listViews.size();
        if (size > 0) {
            if (size > 10) {
                Collections.sort(this.listViews, this.comp);
            } else {
                boolean flagSwapped = true;
                int i = size - 1;
                while (i >= 0 && flagSwapped) {
                    int j = 0;
                    while (j < i) {
                        Object obj2;
                        flagSwapped = false;
                        Object obj1 = this.listViews.get(j);
                        if (this.comp.compare(obj1, obj2 = this.listViews.get(j + 1)) > 0) {
                            this.listViews.set(j, obj2);
                            this.listViews.set(j + 1, obj1);
                        }
                        ++j;
                    }
                    --i;
                }
            }
        }
    }

    public void render(SatinGraphics g) {
        this.sortViewsByDisplayValue();
        if (this.listViews.size() > 0) {
            ((View)this.listViews.get(0)).render(g);
        }
    }

    public String toString() {
        StringBuffer strbuf = (StringBuffer)SatinConstants.poolStrbuf.getObject();
        Iterator it = this.listViews.iterator();
        strbuf.append(super.toString());
        strbuf.append("\nBounds:              " + StringLib.toString(this.getBoundingPoints2DRef().getBounds2D()));
        strbuf.append("\nContained Views:\n");
        while (it.hasNext()) {
            strbuf.append(StringLib.indent(it.next().toString(), 3));
            if (!it.hasNext()) continue;
            strbuf.append("\n\n");
        }
        String str = strbuf.toString();
        SatinConstants.poolStrbuf.releaseObject(strbuf);
        return str;
    }

    public Object clone() {
        return this.clone(new DefaultMultiViewImpl());
    }

    protected DefaultMultiViewImpl clone(DefaultMultiViewImpl vm) {
        super.clone(vm);
        vm.comp = new ViewComparator();
        vm.listViews = new LinkedList();
        Iterator it = this.listViews.iterator();
        while (it.hasNext()) {
            View v = (View)it.next();
            vm.listViews.add((View)v.clone());
        }
        vm.setAttachedGraphicalObject(this.getAttachedGraphicalObject());
        return vm;
    }

    final class ViewComparator
    implements Comparator,
    Serializable {
        ViewComparator() {
        }

        public final int compare(Object obj1, Object obj2) {
            float v2;
            float v1 = ((View)obj1).getViewDisplayValue();
            if (v1 < (v2 = ((View)obj2).getViewDisplayValue())) {
                return 1;
            }
            if (v1 > v2) {
                return -1;
            }
            return 0;
        }
    }
}

