/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.util;

import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollection;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectCollectionImpl;
import edu.berkeley.guir.lib.satin.objects.Patch;
import edu.berkeley.guir.lib.satin.objects.PatchImpl;
import edu.berkeley.guir.lib.satin.stroke.TimedStroke;
import edu.berkeley.guir.lib.satin.view.SemanticZoomMultiViewImpl;
import edu.berkeley.guir.lib.satin.view.SemanticZoomViewWrapper;
import edu.berkeley.guir.lib.util.RandomLib;
import java.awt.Rectangle;
import java.util.Random;

public final class SatinRandomLib {
    private static final Random rand = new Random(13948371L);

    public static GraphicalObjectCollection getRandomGraphicalObjectCollection(Rectangle rect, int numStks) {
        GraphicalObjectCollectionImpl gobcol = new GraphicalObjectCollectionImpl();
        int i = 0;
        while (i < numStks) {
            gobcol.add(SatinRandomLib.getRandomStroke(rect, 4));
            ++i;
        }
        return gobcol;
    }

    public static TimedStroke getRandomStroke(Rectangle rect, int npoints) {
        TimedStroke stk = new TimedStroke();
        int i = 0;
        while (i < npoints) {
            stk.addPoint(RandomLib.nextInt(rand, rect.x, rect.x + rect.width), RandomLib.nextInt(rand, rect.y, rect.y + rect.width));
            ++i;
        }
        return stk;
    }

    public static Patch getRandomPatch(Rectangle rect) {
        int x = RandomLib.nextInt(rand, rect.x, rect.x + rect.width);
        int y = RandomLib.nextInt(rand, rect.y, rect.y + rect.height);
        int w = RandomLib.nextInt(rand, 0, rect.x + rect.width - x);
        int h = RandomLib.nextInt(rand, 0, rect.y + rect.height - y);
        Rectangle bounds = new Rectangle(x, y, w, h);
        return new PatchImpl(bounds);
    }

    public static Patch getRandomSemanticZoomPatch(Rectangle rect) {
        int x = RandomLib.nextInt(rand, rect.x, rect.x + rect.width);
        int y = RandomLib.nextInt(rand, rect.y, rect.y + rect.height);
        int w = RandomLib.nextInt(rand, 0, rect.x + rect.width - x);
        int h = RandomLib.nextInt(rand, 0, rect.y + rect.height - y);
        Rectangle bounds = new Rectangle(x, y, w, h);
        PatchImpl p = new PatchImpl(bounds);
        double fIn = RandomLib.nextDouble(rand, 0.0, 1.0);
        double start = RandomLib.nextDouble(rand, 1.0, 2.0);
        double end = RandomLib.nextDouble(rand, 2.0, 3.0);
        double fOut = RandomLib.nextDouble(rand, 3.0, 4.0);
        SemanticZoomViewWrapper v = new SemanticZoomViewWrapper(p.getView());
        v.setDisplayRange(fIn, start, end, fOut);
        SemanticZoomMultiViewImpl med = new SemanticZoomMultiViewImpl();
        med.add(v);
        p.setView(med);
        return p;
    }
}

