/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.guir.lib.satin.stroke;

import edu.berkeley.guir.lib.awt.geom.AffineTransformLib;
import edu.berkeley.guir.lib.awt.geom.GeomLib;
import edu.berkeley.guir.lib.awt.geom.Polygon2D;
import edu.berkeley.guir.lib.satin.SatinConstants;
import edu.berkeley.guir.lib.satin.Sheet;
import edu.berkeley.guir.lib.satin.graphics.SatinGraphics;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectGroup;
import edu.berkeley.guir.lib.satin.objects.GraphicalObjectImpl;
import edu.berkeley.guir.lib.satin.objects.Style;
import edu.berkeley.guir.lib.satin.stroke.TimedPolygon2D;
import edu.berkeley.guir.lib.util.StringLib;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class TimedStroke
extends GraphicalObjectImpl
implements SatinConstants {
    static final long serialVersionUID = 1722093520451738482L;
    public static final String TIMEDSTROKE_STYLE_FILE = "TimedStroke.properties";
    static Rectangle damageRect;
    static AffineTransform txBuffer;
    static Point2D ptA;
    static Point2D ptB;
    protected TimedPolygon2D poly;
    protected float lastx = Float.NEGATIVE_INFINITY;
    protected float lasty = Float.NEGATIVE_INFINITY;
    protected double length;
    private boolean flagLeft;
    private boolean flagMiddle;
    private boolean flagRight;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("edu.berkeley.guir.lib.satin.stroke.TimedStroke");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SatinConstants.clprops.setClassProperty(clazz, "STYLE", new Style(TIMEDSTROKE_STYLE_FILE));
        damageRect = new Rectangle();
        txBuffer = new AffineTransform();
        ptA = new Point2D.Float();
        ptB = new Point2D.Float();
    }

    public static void setDrawFix(boolean flag) {
    }

    public TimedStroke() {
        this.poly = new TimedPolygon2D();
        this.setLocalBoundingPoints2DRef(this.poly);
        this.setHasClosedBoundingPoints(false);
    }

    public TimedStroke(Polygon p) {
        this.poly = new TimedPolygon2D(p);
        this.setLocalBoundingPoints2DRef(this.poly);
        this.setHasClosedBoundingPoints(false);
        this.recalculateLength();
    }

    public TimedStroke(Polygon2D p) {
        this.poly = p instanceof TimedPolygon2D ? new TimedPolygon2D((TimedPolygon2D)p) : new TimedPolygon2D(p);
        this.setLocalBoundingPoints2DRef(this.poly);
        this.setHasClosedBoundingPoints(p.isClosed());
        this.recalculateLength();
    }

    public TimedStroke(Shape s) {
        this(new Polygon2D(s));
    }

    public TimedStroke(TimedStroke tstk) {
        this.setStroke(tstk);
    }

    public void setStroke(TimedStroke tstk) {
        this.poly = tstk.getPolygon2D(10);
        this.setLocalBoundingPoints2DRef(this.poly);
        this.recalculateLength();
        this.setTransform(tstk.getTransform(11));
        this.setHasClosedBoundingPoints(tstk.hasClosedBoundingPoints());
    }

    public boolean isLeftButton() {
        return this.flagLeft;
    }

    public boolean isMiddleButton() {
        return this.flagMiddle;
    }

    public boolean isRightButton() {
        return this.flagRight;
    }

    public void setLeftButton(boolean flag) {
        this.flagLeft = flag;
    }

    public void setMiddleButton(boolean flag) {
        this.flagMiddle = flag;
    }

    public void setRightButton(boolean flag) {
        this.flagRight = flag;
    }

    public void setHasClosedBoundingPoints(boolean flag) {
        super.setHasClosedBoundingPoints(flag);
        this.poly.setClosed(flag);
    }

    protected void recalculateLength() {
        this.length = 0.0;
        if (this.poly.npoints < 2) {
            return;
        }
        this.length = this.lengthOfStroke(0, this.poly.npoints - 1);
    }

    protected void updateLength() {
        if (this.poly.npoints < 2) {
            return;
        }
        this.length += (double)GeomLib.distance(this.poly.xpoints[this.poly.npoints - 2], this.poly.ypoints[this.poly.npoints - 2], this.poly.xpoints[this.poly.npoints - 1], this.poly.ypoints[this.poly.npoints - 1]);
    }

    private void damageAroundPoint(int n) {
        float x = this.poly.xpoints[n];
        float y = this.poly.ypoints[n];
        txBuffer = this.getTransform(12, txBuffer);
        if (this.poly.npoints > 0) {
            if (this.poly.npoints == 1) {
                ptA.setLocation(x, y);
                ptB.setLocation(x, y);
            } else if (n == 0) {
                ptA.setLocation(x, y);
                ptB.setLocation(this.poly.xpoints[1], this.poly.ypoints[1]);
            } else if (n == this.poly.npoints - 1) {
                ptA.setLocation(this.poly.xpoints[n - 1], this.poly.ypoints[n - 1]);
                ptB.setLocation(x, y);
            } else {
                float minX = Math.min(this.poly.xpoints[n - 1], x);
                minX = Math.min(minX, this.poly.xpoints[n + 1]);
                float minY = Math.min(this.poly.ypoints[n - 1], y);
                minY = Math.min(minY, this.poly.ypoints[n + 1]);
                float maxX = Math.max(this.poly.xpoints[n - 1], x);
                maxX = Math.max(maxX, this.poly.xpoints[n + 1]);
                float maxY = Math.max(this.poly.ypoints[n - 1], y);
                maxY = Math.max(maxY, this.poly.ypoints[n + 1]);
            }
        }
        txBuffer.transform(ptA, ptA);
        txBuffer.transform(ptB, ptB);
        int width = (int)this.getStyleRef().getLineWidth() + 1;
        damageRect.setRect(Math.min(ptA.getX(), ptB.getX()) - (double)(width / 2) - 1.0, Math.min(ptA.getY(), ptB.getY()) - (double)(width / 2) - 1.0, Math.abs(ptA.getX() - ptB.getX()) + (double)width + 2.0, Math.abs(ptA.getY() - ptB.getY()) + (double)width + 2.0);
        Sheet sheet = this.getSheet();
        if (sheet != null) {
            int damageMode = Sheet.isIdleRenderingMode() ? 22 : 21;
            this.damage(damageMode, damageRect);
        }
    }

    public final void addPoint(float x, float y) {
        this.addPoint(x, y, System.currentTimeMillis());
    }

    public final void addPoint(double x, double y) {
        this.addPoint((float)x, (float)y, System.currentTimeMillis());
    }

    public final void addPoint(Point2D pt) {
        this.addPoint((float)pt.getX(), (float)pt.getY(), System.currentTimeMillis());
    }

    public final void addPoint(double x, double y, long time) {
        this.addPoint((float)x, (float)y, time);
    }

    public void addPoint(int myX, int myY) {
        this.addPoint(myX, myY, System.currentTimeMillis());
    }

    protected final boolean pointFilter(float x, float y) {
        float dx = this.lastx - x;
        float dy = this.lasty - y;
        float distSq = dx * dx + dy * dy;
        if (distSq > 4.0f) {
            this.lastx = x;
            this.lasty = y;
            return true;
        }
        return false;
    }

    public void addPoint(float x, float y, long time) {
        if (this.pointFilter(x, y)) {
            this.poly.addPoint(x, y, time);
            this.updateLength();
            this.setDirty();
            this.damageAroundPoint(this.poly.npoints - 1);
        }
    }

    public final void addPoint(Point2D pt, long time) {
        this.addPoint((float)pt.getX(), (float)pt.getY(), time);
    }

    public TimedStroke doneAddingPoints() {
        this.getViewHandler().normalizeBoundingPoints();
        return this;
    }

    public void clearPoints() {
        this.poly.clearPoints();
    }

    public final void changePoint(int n, double x, double y) {
        ptA.setLocation(x, y);
        try {
            this.getViewHandler().getNormalizingTransform().inverseTransform(ptA, ptA);
            this.getTransform(12).inverseTransform(ptA, ptA);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        this.poly.xpoints[n] = (float)ptA.getX();
        this.poly.ypoints[n] = (float)ptA.getY();
        this.updateLength();
        this.setDirty();
        this.damageAroundPoint(n);
    }

    private TimedStroke getSubstroke(int start, int end) {
        TimedStroke stk = new TimedStroke();
        int i = start;
        while (i < end && i < this.poly.npoints) {
            stk.addPoint(this.poly.xpoints[i], this.poly.ypoints[i], this.poly.times[i]);
            ++i;
        }
        stk.setTransform(this.getTransformRef());
        return stk;
    }

    public TimedStroke getSubstroke(double start, double end) {
        int endPos;
        int startPos;
        double tmpLength = 0.0;
        int i = 0;
        if (start <= 0.0) {
            startPos = 0;
        } else if (start < 0.5) {
            tmpLength = 0.0;
            i = 0;
            while (tmpLength / this.length < start && i < this.poly.npoints - 1) {
                tmpLength += this.lengthOfStroke(i, i + 1);
                ++i;
            }
            startPos = i - 1;
        } else {
            tmpLength = this.length;
            i = this.poly.npoints - 1;
            while (tmpLength / this.length > start && i > 0) {
                tmpLength -= this.lengthOfStroke(i - 1, i);
                --i;
            }
            startPos = i;
        }
        if (end >= 1.0) {
            endPos = this.poly.npoints - 1;
        } else if (end - start < 1.0 - end) {
            while (tmpLength / this.length < end && i < this.poly.npoints - 1) {
                tmpLength += this.lengthOfStroke(i, i + 1);
                ++i;
            }
            endPos = i - 1;
        } else {
            tmpLength = this.length;
            i = this.poly.npoints - 1;
            while (tmpLength / this.length > end && i > 0) {
                tmpLength -= this.lengthOfStroke(i - 1, i);
                --i;
            }
            endPos = i;
        }
        return this.getSubstroke(startPos, endPos);
    }

    private double lengthOfStroke(int start, int end) {
        double tmplength = 0.0;
        int i = start;
        while (i < end) {
            tmplength += (double)GeomLib.distance(this.poly.xpoints[i], this.poly.ypoints[i], this.poly.xpoints[i + 1], this.poly.ypoints[i + 1]);
            ++i;
        }
        return tmplength;
    }

    public int getNumPoints() {
        return this.poly.npoints;
    }

    public TimedPolygon2D getPolygon2D(int cdsys) {
        return this.getPolygon2D(cdsys, null, null);
    }

    public TimedPolygon2D getPolygon2D(int cdsys, AffineTransform tx, TimedPolygon2D p) {
        if (p == null) {
            p = new TimedPolygon2D();
        }
        p.setToShape(this.poly);
        switch (cdsys) {
            case 10: {
                break;
            }
            case 11: {
                p.transform(this.getTransformRef());
                break;
            }
            case 12: {
                p.transform(this.getTransform(12));
                break;
            }
            default: {
                throw new RuntimeException("What the heck was that value?");
            }
        }
        if (tx != null) {
            p.transform(tx);
        }
        return p;
    }

    public Point2D getStartPoint2D(int cdsys) {
        return this.getStartPoint2D(cdsys, null, null);
    }

    public Point2D getStartPoint2D(int cdsys, AffineTransform tx, Point2D pt) {
        if (pt == null) {
            pt = new Point2D.Float();
        }
        pt.setLocation(this.poly.xpoints[0], this.poly.ypoints[0]);
        switch (cdsys) {
            case 10: {
                break;
            }
            case 11: {
                this.getTransformRef().transform(pt, pt);
                break;
            }
            case 12: {
                this.getTransform(12).transform(pt, pt);
                break;
            }
            default: {
                throw new RuntimeException("What the heck was that value?");
            }
        }
        if (tx != null) {
            tx.transform(pt, pt);
        }
        return pt;
    }

    public Point2D getEndPoint2D(int cdsys) {
        return this.getEndPoint2D(cdsys, null, null);
    }

    public Point2D getEndPoint2D(int cdsys, AffineTransform tx, Point2D pt) {
        if (pt == null) {
            pt = new Point2D.Float();
        }
        int pos = this.poly.npoints - 1;
        pt.setLocation(this.poly.xpoints[pos], this.poly.ypoints[pos]);
        switch (cdsys) {
            case 10: {
                break;
            }
            case 11: {
                this.getTransformRef().transform(pt, pt);
                break;
            }
            case 12: {
                this.getTransform(12).transform(pt, pt);
                break;
            }
            default: {
                throw new RuntimeException("What the heck was that value?");
            }
        }
        if (tx != null) {
            tx.transform(pt, pt);
        }
        return pt;
    }

    public double getLength2D(int cdsys) {
        switch (cdsys) {
            case 10: {
                return this.length;
            }
            case 11: {
                double zz = AffineTransformLib.getScaleFactor(this.getTransformRef());
                return zz * this.length;
            }
            case 12: {
                double zz = AffineTransformLib.getScaleFactor(this.getTransform(12));
                return zz * this.length;
            }
        }
        throw new RuntimeException("What the heck was that value?");
    }

    public long getStartTime() {
        return this.poly.times[0];
    }

    public long getEndTime() {
        return this.poly.times[this.poly.npoints - 1];
    }

    public long[] getTimes() {
        return this.poly.times;
    }

    protected void defaultRender(SatinGraphics g) {
        g.draw(this.poly);
    }

    protected void renderSelected(SatinGraphics g, Rectangle2D rect) {
        AffineTransform tx = (AffineTransform)SatinConstants.poolTx.getObject();
        Point2D pt = (Point2D)SatinConstants.poolPoints.getObject();
        this.getTransform(12, tx);
        int len = this.poly.npoints;
        if (len > 0) {
            pt.setLocation(this.poly.xpoints[0], this.poly.ypoints[0]);
            tx.transform(pt, pt);
            this.renderSelectionHandle(g, (int)pt.getX(), (int)pt.getY());
            pt.setLocation(this.poly.xpoints[len - 1], this.poly.ypoints[len - 1]);
            tx.transform(pt, pt);
            this.renderSelectionHandle(g, (int)pt.getX(), (int)pt.getY());
            int i = 1;
            while (i < len) {
                pt.setLocation(this.poly.xpoints[i], this.poly.ypoints[i]);
                tx.transform(pt, pt);
                this.renderSelectionHandle(g, (int)pt.getX(), (int)pt.getY());
                i += 6;
            }
        }
        SatinConstants.poolTx.releaseObject(tx);
        SatinConstants.poolPoints.releaseObject(pt);
    }

    public String getButtonString() {
        int val = 0;
        if (this.isLeftButton()) {
            ++val;
        }
        if (this.isMiddleButton()) {
            val += 2;
        }
        if (this.isRightButton()) {
            val += 4;
        }
        switch (val) {
            case 0: {
                return "   ";
            }
            case 1: {
                return "L  ";
            }
            case 2: {
                return " M ";
            }
            case 3: {
                return "LM ";
            }
            case 4: {
                return "  R";
            }
            case 5: {
                return "L R";
            }
            case 6: {
                return " MR";
            }
            case 7: {
                return "LMR";
            }
        }
        return "   ";
    }

    public String toDebugString() {
        StringBuffer strbuf = new StringBuffer();
        strbuf.append(super.toDebugString());
        strbuf.append("\nButtons Down:   " + this.getButtonString());
        strbuf.append("\nStk Points:     " + StringLib.toString(this.poly));
        return strbuf.toString();
    }

    public Object clone() {
        TimedStroke stk = new TimedStroke();
        this.clone(stk);
        return stk;
    }

    protected TimedStroke clone(TimedStroke stk) {
        super.clone(stk);
        stk.poly = (TimedPolygon2D)this.poly.clone();
        stk.setHasClosedBoundingPoints(false);
        return stk;
    }

    public Object deepClone() {
        return this.clone();
    }

    protected Object deepClone(TimedStroke gobClone) {
        return this.clone(gobClone);
    }

    public static void main(String[] argv) {
        TimedStroke s = new TimedStroke();
        s.addPoint(10, 10);
        s.addPoint(20, 10);
        s.addPoint(20, 20);
        s.addPoint(10, 20);
        System.out.println("len " + s.getLength2D(10));
        s.getSubstroke(0.0, 0.5);
        s.getSubstroke(0.0, 1.0);
        s.getSubstroke(0.0, 0.25);
        System.out.println();
    }

    public void deepClear() {
        super.deepClear();
        this.poly = null;
    }

    public void stroke2DOM(Document doc, Element parent) {
        Element element = doc.createElement("TimedStroke");
        this.setAttributeFromStroke(element);
        TimedPolygon2D refPoly = this.getPolygon2D(11);
        Text text = doc.createTextNode(refPoly.xpoints[0] + ":" + refPoly.ypoints[0] + ";");
        int i = 1;
        while (i < refPoly.npoints) {
            String s = text.getNodeValue();
            text.setNodeValue(String.valueOf(s) + refPoly.xpoints[i] + ":" + refPoly.ypoints[i] + ";");
            ++i;
        }
        element.appendChild(text);
        parent.appendChild(element);
    }

    public static void DOM2Stroke(Element element, GraphicalObjectGroup parent) {
        Polygon2D poly = new Polygon2D();
        Text textNode = (Text)element.getFirstChild();
        String s = textNode.getNodeValue();
        int index1 = 0;
        int index2 = s.indexOf(":");
        String strX = s.substring(0, index2);
        index1 = s.indexOf(";", index1 + 1);
        String strY = s.substring(index2 + 1, index1);
        double x = Double.parseDouble(strX);
        double y = Double.parseDouble(strY);
        poly.addPoint(x, y);
        index2 = s.indexOf(":", index2 + 1);
        while (index2 != -1) {
            strX = s.substring(index1 + 1, index2);
            strY = (index1 = s.indexOf(";", index1 + 1)) != -1 ? s.substring(index2 + 1, index1) : s.substring(index2 + 1, s.length());
            x = Double.parseDouble(strX);
            y = Double.parseDouble(strY);
            poly.addPoint(x, y);
            index2 = s.indexOf(":", index2 + 1);
        }
        poly.setClosed(false);
        TimedStroke wStroke = new TimedStroke(poly);
        wStroke.setAttributeToStroke(element);
        parent.add(wStroke);
    }

    private void setAttributeFromStroke(Element element) {
        element.setAttribute("id", String.valueOf(this.getUniqueID()));
    }

    private void setAttributeToStroke(Element element) {
        this.setUniqueID(Integer.parseInt(element.getAttribute("id")));
    }
}

